/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler.sleigh.sem;

import ghidra.app.plugin.assembler.sleigh.expr.MaskedLong;
import ghidra.app.plugin.assembler.sleigh.expr.RecursiveDescentSolver;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyConstructorSemantic;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyPatternBlock;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolution;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedBackfill;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyTreeResolver;
import ghidra.app.plugin.processors.sleigh.ConstructState;
import ghidra.app.plugin.processors.sleigh.Constructor;
import ghidra.app.plugin.processors.sleigh.ContextOp;
import ghidra.app.plugin.processors.sleigh.symbol.OperandSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.SubtableSymbol;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.lang3.StringUtils;

public class AssemblyResolvedPatterns
extends AssemblyResolution {
    protected static final String INS = "ins:";
    protected static final String CTX = "ctx:";
    protected static final String SEP = ",";
    protected final Constructor cons;
    protected final AssemblyPatternBlock ins;
    protected final AssemblyPatternBlock ctx;
    protected final Set<AssemblyResolvedBackfill> backfills;
    protected final Set<AssemblyResolvedPatterns> forbids;
    protected static final Pattern pat = Pattern.compile("line(\\d*)");

    @Override
    protected int computeHash() {
        int result = 0;
        result += this.ins.hashCode();
        result *= 31;
        result += this.ctx.hashCode();
        result *= 31;
        result += this.backfills.hashCode();
        result *= 31;
        return result += this.forbids.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AssemblyResolvedPatterns)) {
            return false;
        }
        AssemblyResolvedPatterns that = (AssemblyResolvedPatterns)obj;
        if (!this.ins.equals(that.ins)) {
            return false;
        }
        if (!this.ctx.equals(that.ctx)) {
            return false;
        }
        if (!this.backfills.equals(that.backfills)) {
            return false;
        }
        return this.forbids.equals(that.forbids);
    }

    AssemblyResolvedPatterns(String description, Constructor cons, List<? extends AssemblyResolution> children, AssemblyResolution right, AssemblyPatternBlock ins, AssemblyPatternBlock ctx, Set<AssemblyResolvedBackfill> backfills, Set<AssemblyResolvedPatterns> forbids) {
        super(description, children, right);
        this.cons = cons;
        this.ins = ins;
        this.ctx = ctx;
        this.backfills = backfills == null ? Set.of() : backfills;
        this.forbids = forbids == null ? Set.of() : forbids;
    }

    public static AssemblyResolvedPatterns fromString(String str, String description, List<AssemblyResolution> children) {
        AssemblyPatternBlock ins = null;
        if (str.startsWith(INS)) {
            int end = str.indexOf(SEP);
            if (end == -1) {
                end = str.length();
            }
            ins = AssemblyPatternBlock.fromString(str.substring(INS.length(), end));
            if ((str = str.substring(end)).startsWith(SEP)) {
                str = str.substring(1);
            }
        }
        AssemblyPatternBlock ctx = null;
        if (str.startsWith(CTX)) {
            int end = str.length();
            ctx = AssemblyPatternBlock.fromString(str.substring(CTX.length(), end));
            str = str.substring(end);
        }
        if (str.length() != 0) {
            throw new IllegalArgumentException(str);
        }
        return AssemblyResolution.resolved(ins == null ? AssemblyPatternBlock.nop() : ins, ctx == null ? AssemblyPatternBlock.nop() : ctx, description, null, children, null);
    }

    @Override
    public AssemblyResolvedPatterns shift(int amt) {
        if (amt == 0) {
            return this;
        }
        AssemblyPatternBlock newIns = this.ins.shift(amt);
        HashSet<AssemblyResolvedBackfill> newBackfills = new HashSet<AssemblyResolvedBackfill>();
        for (AssemblyResolvedBackfill bf : this.backfills) {
            newBackfills.add(bf.shift(amt));
        }
        HashSet<AssemblyResolvedPatterns> newForbids = new HashSet<AssemblyResolvedPatterns>();
        for (AssemblyResolvedPatterns f : this.forbids) {
            newForbids.add(f.shift(amt));
        }
        return new AssemblyResolvedPatterns(this.description, this.cons, this.children, this.right, newIns, this.ctx, Collections.unmodifiableSet(newBackfills), Collections.unmodifiableSet(newForbids));
    }

    public AssemblyResolvedPatterns truncate(int amt) {
        if (amt == 0) {
            return this;
        }
        AssemblyPatternBlock newIns = this.ins.truncate(amt);
        return new AssemblyResolvedPatterns("Truncated: " + this.description, this.cons, null, this.right, newIns, this.ctx, null, null);
    }

    public AssemblyResolution checkNotForbidden() {
        HashSet<AssemblyResolvedPatterns> newForbids = new HashSet<AssemblyResolvedPatterns>();
        for (AssemblyResolvedPatterns f : this.forbids) {
            AssemblyResolvedPatterns check = this.combine(f);
            if (null == check) continue;
            newForbids.add(f);
            if (!check.bitsEqual(this)) continue;
            return AssemblyResolution.error("The result is forbidden by " + f, this);
        }
        return new AssemblyResolvedPatterns(this.description, this.cons, this.children, this.right, this.ins, this.ctx, this.backfills, Collections.unmodifiableSet(newForbids));
    }

    protected boolean bitsEqual(AssemblyResolvedPatterns that) {
        return this.ins.equals(that.ins) && this.ctx.equals(that.ctx);
    }

    public AssemblyResolvedPatterns combine(AssemblyResolvedPatterns that) {
        return this.combineLessBackfill(that, null);
    }

    protected AssemblyResolvedPatterns combineLessBackfill(AssemblyResolvedPatterns that, AssemblyResolvedBackfill bf) {
        AssemblyPatternBlock newIns = this.ins.combine(that.ins);
        if (newIns == null) {
            return null;
        }
        AssemblyPatternBlock newCtx = this.ctx.combine(that.ctx);
        if (newCtx == null) {
            return null;
        }
        HashSet<AssemblyResolvedBackfill> newBackfills = new HashSet<AssemblyResolvedBackfill>(this.backfills);
        newBackfills.addAll(that.backfills);
        if (bf != null) {
            newBackfills.remove(bf);
        }
        HashSet<AssemblyResolvedPatterns> newForbids = new HashSet<AssemblyResolvedPatterns>(this.forbids);
        newForbids.addAll(that.forbids);
        return new AssemblyResolvedPatterns(this.description, this.cons, this.children, this.right, newIns, newCtx, Collections.unmodifiableSet(newBackfills), Collections.unmodifiableSet(newForbids));
    }

    public AssemblyResolvedPatterns combine(AssemblyResolvedBackfill bf) {
        HashSet<AssemblyResolvedBackfill> newBackfills = new HashSet<AssemblyResolvedBackfill>(this.backfills);
        newBackfills.add(bf);
        return new AssemblyResolvedPatterns(this.description, this.cons, this.children, this.right, this.ins, this.ctx, Collections.unmodifiableSet(newBackfills), this.forbids);
    }

    public AssemblyResolvedPatterns withForbids(Set<AssemblyResolvedPatterns> more) {
        HashSet<AssemblyResolvedPatterns> combForbids = new HashSet<AssemblyResolvedPatterns>(this.forbids);
        combForbids.addAll(more);
        return new AssemblyResolvedPatterns(this.description, this.cons, this.children, this.right, this.ins, this.ctx, this.backfills, Collections.unmodifiableSet(more));
    }

    public AssemblyResolvedPatterns withDescription(String desc) {
        return new AssemblyResolvedPatterns(desc, this.cons, this.children, this.right, this.ins, this.ctx, this.backfills, this.forbids);
    }

    public AssemblyResolvedPatterns withConstructor(Constructor cons) {
        return new AssemblyResolvedPatterns(this.description, cons, this.children, this.right, this.ins, this.ctx, this.backfills, this.forbids);
    }

    public AssemblyResolvedPatterns writeContextOp(ContextOp cop, MaskedLong val) {
        AssemblyPatternBlock newCtx = this.ctx.writeContextOp(cop, val);
        return new AssemblyResolvedPatterns(this.description, this.cons, this.children, this.right, this.ins, newCtx, this.backfills, this.forbids);
    }

    public MaskedLong readContextOp(ContextOp cop) {
        return this.ctx.readContextOp(cop);
    }

    public AssemblyResolvedPatterns copyAppendDescription(String append) {
        AssemblyResolvedPatterns cp = new AssemblyResolvedPatterns(this.description + ": " + append, this.cons, this.children, this.right, this.ins.copy(), this.ctx.copy(), this.backfills, this.forbids);
        return cp;
    }

    @Override
    public AssemblyResolvedPatterns withRight(AssemblyResolution right) {
        AssemblyResolvedPatterns cp = new AssemblyResolvedPatterns(this.description, this.cons, this.children, right, this.ins.copy(), this.ctx.copy(), this.backfills, this.forbids);
        return cp;
    }

    public AssemblyResolvedPatterns nopLeftSibling() {
        return new AssemblyResolvedPatterns("nop-left", null, null, this, this.ins.copy(), this.ctx.copy(), this.backfills, this.forbids);
    }

    @Override
    public AssemblyResolvedPatterns parent(String description, int opCount) {
        List<AssemblyResolution> allRight = this.getAllRight();
        AssemblyResolvedPatterns cp = new AssemblyResolvedPatterns(description, this.cons, allRight.subList(0, opCount), allRight.get(opCount), this.ins, this.ctx, this.backfills, this.forbids);
        return cp;
    }

    public AssemblyResolvedPatterns maskOut(ContextOp cop) {
        AssemblyPatternBlock newCtx = this.ctx.maskOut(cop);
        return new AssemblyResolvedPatterns(this.description, this.cons, this.children, this.right, this.ins, newCtx, this.backfills, this.forbids);
    }

    public AssemblyResolution backfill(RecursiveDescentSolver solver, Map<String, Long> vals) {
        if (!this.hasBackfills()) {
            return this;
        }
        AssemblyResolvedPatterns res = this;
        block0: while (true) {
            for (AssemblyResolvedBackfill bf : res.backfills) {
                AssemblyResolution ar = bf.solve(solver, vals, this);
                if (ar.isError()) continue;
                AssemblyResolvedPatterns rc = (AssemblyResolvedPatterns)ar;
                AssemblyResolvedPatterns check = res.combineLessBackfill(rc, bf);
                if (check == null) {
                    return AssemblyResolution.error("Conflict: Backfill " + bf.description, res);
                }
                res = check;
                continue block0;
            }
            break;
        }
        return res;
    }

    @Override
    public String lineToString() {
        return this.dumpConstructorTree() + ":ins:" + this.ins + ",ctx:" + this.ctx + " (" + this.description + ")";
    }

    public boolean hasBackfills() {
        return !this.backfills.isEmpty();
    }

    private boolean hasForbids() {
        return !this.forbids.isEmpty();
    }

    public AssemblyResolvedPatterns solveContextChangesForForbids(AssemblyConstructorSemantic sem, Map<String, Long> vals) {
        if (!this.hasForbids()) {
            return this;
        }
        HashSet<AssemblyResolvedPatterns> newForbids = new HashSet<AssemblyResolvedPatterns>();
        for (AssemblyResolvedPatterns f : this.forbids) {
            AssemblyResolution t = sem.solveContextChanges(f, vals);
            if (!(t instanceof AssemblyResolvedPatterns)) continue;
            newForbids.add((AssemblyResolvedPatterns)t);
        }
        return new AssemblyResolvedPatterns(this.description, this.cons, this.children, this.right, this.ins, this.ctx, this.backfills, Collections.unmodifiableSet(newForbids));
    }

    public int getInstructionLength() {
        int inslen = this.ins.length();
        for (AssemblyResolvedBackfill bf : this.backfills) {
            inslen = Math.max(inslen, bf.getInstructionLength());
        }
        return inslen;
    }

    public int getDefinedInstructionLength() {
        int i;
        byte[] imsk = this.ins.getMask();
        for (i = imsk.length - 1; i >= 0 && imsk[i] == 0; --i) {
        }
        return this.ins.getOffset() + i + 1;
    }

    public AssemblyPatternBlock getInstruction() {
        return this.ins;
    }

    public AssemblyPatternBlock getContext() {
        return this.ctx;
    }

    public MaskedLong readInstruction(int start, int len) {
        return this.ins.readBytes(start, len);
    }

    public MaskedLong readContext(int start, int len) {
        return this.ctx.readBytes(start, len);
    }

    @Override
    public boolean isError() {
        return false;
    }

    @Override
    public boolean isBackfill() {
        return false;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.hasBackfills() || this.hasForbids();
    }

    @Override
    protected String childrenToString(String indent) {
        StringBuilder sb = new StringBuilder();
        if (super.hasChildren()) {
            sb.append(super.childrenToString(indent) + "\n");
        }
        for (AssemblyResolvedBackfill bf : this.backfills) {
            sb.append(indent);
            sb.append("backfill: " + bf + "\n");
        }
        for (AssemblyResolvedPatterns f : this.forbids) {
            sb.append(indent);
            sb.append("forbidden: " + f + "\n");
        }
        return sb.substring(0, sb.length() - 1);
    }

    public String dumpConstructorTree() {
        StringBuilder sb = new StringBuilder();
        if (this.cons == null) {
            return null;
        }
        sb.append(this.cons.getSourceFile() + ":" + this.cons.getLineno());
        if (this.children == null) {
            return sb.toString();
        }
        ArrayList<String> subs = new ArrayList<String>();
        for (AssemblyResolution c : this.children) {
            AssemblyResolvedPatterns rc;
            String s;
            if (!(c instanceof AssemblyResolvedPatterns) || (s = (rc = (AssemblyResolvedPatterns)c).dumpConstructorTree()) == null) continue;
            subs.add(s);
        }
        if (subs.isEmpty()) {
            return sb.toString();
        }
        sb.append('[');
        sb.append(StringUtils.join(subs, (String)SEP));
        sb.append(']');
        return sb.toString();
    }

    public int getSpecificity() {
        return this.ins.getSpecificity() + this.ctx.getSpecificity();
    }

    public Iterable<byte[]> possibleInsVals(AssemblyPatternBlock forCtx) {
        AssemblyPatternBlock ctxCompat = this.ctx.combine(forCtx);
        if (ctxCompat == null) {
            return List.of();
        }
        final Predicate removeForbidden = val -> {
            for (AssemblyResolvedPatterns f : this.forbids) {
                AssemblyPatternBlock vi;
                AssemblyPatternBlock i;
                if (f.getDefinedInstructionLength() > ((byte[])val).length || null == f.getContext().combine(forCtx) || null == (i = f.getInstruction()).combine(vi = AssemblyPatternBlock.fromBytes(this.ins.length() - ((byte[])val).length, val))) continue;
                return false;
            }
            return true;
        };
        return new Iterable<byte[]>(){

            @Override
            public Iterator<byte[]> iterator() {
                return IteratorUtils.filteredIterator(AssemblyResolvedPatterns.this.ins.possibleVals().iterator(), (Predicate)removeForbidden);
            }
        };
    }

    protected static int getOpIndex(String piece) {
        if (piece.charAt(0) != '\n') {
            return -1;
        }
        return piece.charAt(1) - 65;
    }

    protected static ConstructState getPureRecursion(ConstructState state) {
        List<String> pieces = state.getConstructor().getPrintPieces();
        if (pieces.size() != 1) {
            return null;
        }
        int opIdx = AssemblyResolvedPatterns.getOpIndex(pieces.get(0));
        if (opIdx < 0) {
            return null;
        }
        ConstructState sub = state.getSubState(opIdx);
        if (sub == null || sub.getConstructor() == null || sub.getConstructor().getParent() != state.getConstructor().getParent()) {
            return null;
        }
        return sub;
    }

    public boolean equivalentConstructState(ConstructState state) {
        ConstructState rec = AssemblyResolvedPatterns.getPureRecursion(state);
        if (rec != null) {
            if (state.getConstructor() == this.cons) {
                assert (this.children.size() == 1);
                AssemblyResolvedPatterns recRes = (AssemblyResolvedPatterns)this.children.get(0);
                return recRes.equivalentConstructState(rec);
            }
            return this.equivalentConstructState(rec);
        }
        if (state.getConstructor() != this.cons) {
            return false;
        }
        int opCount = this.cons.getNumOperands();
        for (int opIdx = 0; opIdx < opCount; ++opIdx) {
            ConstructState subState;
            OperandSymbol opSym = this.cons.getOperand(opIdx);
            Set printed = Arrays.stream(this.cons.getOpsPrintOrder()).boxed().collect(Collectors.toSet());
            if (!(opSym.getDefiningSymbol() instanceof SubtableSymbol)) {
                AssemblyTreeResolver.DBG.println("Operand " + opSym + " is not a sub-table");
                continue;
            }
            if (!printed.contains(opIdx)) {
                AssemblyTreeResolver.DBG.println("Operand " + opSym + " is hidden");
                continue;
            }
            AssemblyResolvedPatterns child = (AssemblyResolvedPatterns)this.children.get(opIdx);
            if (child.equivalentConstructState(subState = state.getSubState(opIdx))) continue;
            return false;
        }
        return true;
    }
}

