/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.model.impl;

import agent.gdb.manager.GdbInferior;
import agent.gdb.manager.GdbState;
import agent.gdb.manager.GdbThread;
import agent.gdb.manager.impl.cmd.GdbStateChangeRecord;
import agent.gdb.manager.reason.GdbBreakpointHitReason;
import agent.gdb.manager.reason.GdbEndSteppingRangeReason;
import agent.gdb.manager.reason.GdbReason;
import agent.gdb.manager.reason.GdbSignalReceivedReason;
import agent.gdb.model.impl.GdbModelImpl;
import agent.gdb.model.impl.GdbModelImplUtils;
import agent.gdb.model.impl.GdbModelSelectableObject;
import agent.gdb.model.impl.GdbModelTargetAttachable;
import agent.gdb.model.impl.GdbModelTargetBreakpointLocation;
import agent.gdb.model.impl.GdbModelTargetBreakpointLocationContainer;
import agent.gdb.model.impl.GdbModelTargetEnvironment;
import agent.gdb.model.impl.GdbModelTargetInferiorContainer;
import agent.gdb.model.impl.GdbModelTargetModuleContainer;
import agent.gdb.model.impl.GdbModelTargetProcessMemory;
import agent.gdb.model.impl.GdbModelTargetThread;
import agent.gdb.model.impl.GdbModelTargetThreadContainer;
import ghidra.async.AsyncFence;
import ghidra.dbg.agent.AbstractDebuggerObjectModel;
import ghidra.dbg.agent.DefaultTargetObject;
import ghidra.dbg.target.TargetAggregate;
import ghidra.dbg.target.TargetAttachable;
import ghidra.dbg.target.TargetAttacher;
import ghidra.dbg.target.TargetDeletable;
import ghidra.dbg.target.TargetDetachable;
import ghidra.dbg.target.TargetEventScope;
import ghidra.dbg.target.TargetExecutionStateful;
import ghidra.dbg.target.TargetInterruptible;
import ghidra.dbg.target.TargetKillable;
import ghidra.dbg.target.TargetLauncher;
import ghidra.dbg.target.TargetMethod;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetProcess;
import ghidra.dbg.target.TargetResumable;
import ghidra.dbg.target.TargetSteppable;
import ghidra.dbg.target.TargetThread;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.dbg.util.PathUtils;
import ghidra.lifecycle.Internal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

@TargetObjectSchemaInfo(name="Inferior", elements={@TargetElementType(type=Void.class)}, attributes={@TargetAttributeType(type=Void.class)})
public class GdbModelTargetInferior
extends DefaultTargetObject<TargetObject, GdbModelTargetInferiorContainer>
implements TargetProcess,
TargetAggregate,
TargetExecutionStateful,
TargetAttacher,
TargetDeletable,
TargetDetachable,
TargetKillable,
TargetLauncher,
TargetResumable,
TargetSteppable,
TargetInterruptible,
GdbModelSelectableObject {
    public static final String EXIT_CODE_ATTRIBUTE_NAME = "_exit_code";
    public static final TargetMethod.ParameterDescription<Boolean> PARAMETER_STARTI = TargetMethod.ParameterDescription.create(Boolean.class, (String)"starti", (boolean)false, (Object)false, (String)"Break on first instruction (use starti)", (String)"true to use starti, false to use start. Requires GDB 8.1 or later.");
    public static final TargetMethod.TargetParameterMap PARAMETERS = TargetMethod.makeParameters((TargetMethod.ParameterDescription[])new TargetMethod.ParameterDescription[]{TargetLauncher.TargetCmdLineLauncher.PARAMETER_CMDLINE_ARGS, PARAMETER_STARTI});
    protected static final TargetAttacher.TargetAttachKindSet SUPPORTED_KINDS = TargetAttacher.TargetAttachKindSet.of((TargetAttacher.TargetAttachKind[])new TargetAttacher.TargetAttachKind[]{TargetAttacher.TargetAttachKind.BY_OBJECT_REF, TargetAttacher.TargetAttachKind.BY_ID});
    protected final GdbModelImpl impl;
    protected final GdbInferior inferior;
    protected String display;
    protected TargetExecutionStateful.TargetExecutionState state;
    protected TargetExecutionStateful.TargetExecutionState realState;
    protected final GdbModelTargetEnvironment environment;
    protected final GdbModelTargetProcessMemory memory;
    protected final GdbModelTargetModuleContainer modules;
    protected final GdbModelTargetThreadContainer threads;
    protected final GdbModelTargetBreakpointLocationContainer breakpoints;
    protected Long exitCode;
    private Integer base = 10;

    protected static String indexInferior(int inferiorId) {
        return PathUtils.makeIndex((int)inferiorId);
    }

    protected static String indexInferior(GdbInferior inferior) {
        return GdbModelTargetInferior.indexInferior(inferior.getId());
    }

    protected static String keyInferior(GdbInferior inferior) {
        return PathUtils.makeKey((String)GdbModelTargetInferior.indexInferior(inferior));
    }

    public GdbModelTargetInferior(GdbModelTargetInferiorContainer inferiors, GdbInferior inferior) {
        super((AbstractDebuggerObjectModel)inferiors.impl, (TargetObject)inferiors, GdbModelTargetInferior.keyInferior(inferior), "Inferior");
        this.impl = inferiors.impl;
        this.inferior = inferior;
        this.impl.addModelObject(inferior, this);
        this.impl.addModelObject(inferior.getId(), this);
        this.environment = new GdbModelTargetEnvironment(this);
        this.memory = new GdbModelTargetProcessMemory(this);
        this.modules = new GdbModelTargetModuleContainer(this);
        this.threads = new GdbModelTargetThreadContainer(this);
        this.breakpoints = new GdbModelTargetBreakpointLocationContainer(this);
        this.state = this.realState = inferior.getPid() == null ? TargetExecutionStateful.TargetExecutionState.INACTIVE : TargetExecutionStateful.TargetExecutionState.ALIVE;
        this.changeAttributes(List.of(), List.of(this.environment, this.memory, this.modules, this.threads, this.breakpoints), Map.of("_state", this.state, "_display", this.updateDisplay(), "_parameters", PARAMETERS, "_supported_attach_kinds", SUPPORTED_KINDS, "_supported_step_kinds", GdbModelTargetThread.SUPPORTED_KINDS), "Initialized");
    }

    protected TargetMethod.TargetParameterMap computeParams() {
        return TargetMethod.makeParameters((TargetMethod.ParameterDescription[])new TargetMethod.ParameterDescription[]{TargetLauncher.TargetCmdLineLauncher.PARAMETER_CMDLINE_ARGS, PARAMETER_STARTI});
    }

    public TargetMethod.TargetParameterMap getParameters() {
        return PARAMETERS;
    }

    @TargetAttributeType(name="Environment", required=true, fixed=true)
    public GdbModelTargetEnvironment getEnvironment() {
        return this.environment;
    }

    @TargetAttributeType(name="Memory", required=true, fixed=true)
    public GdbModelTargetProcessMemory getMemory() {
        return this.memory;
    }

    @TargetAttributeType(name="Modules", required=true, fixed=true)
    public GdbModelTargetModuleContainer getModules() {
        return this.modules;
    }

    @TargetAttributeType(name="Threads", required=true, fixed=true)
    public GdbModelTargetThreadContainer getThreads() {
        return this.threads;
    }

    @TargetAttributeType(name="Breakpoints", required=true, fixed=true)
    public GdbModelTargetBreakpointLocationContainer getBreakpoints() {
        return this.breakpoints;
    }

    public CompletableFuture<Void> launch(Map<String, ?> args) {
        List cmdLineArgs = TargetLauncher.CmdLineParser.tokenize((String)((String)TargetLauncher.TargetCmdLineLauncher.PARAMETER_CMDLINE_ARGS.get(args)));
        Boolean useStarti = (Boolean)PARAMETER_STARTI.get(args);
        return this.impl.gateFuture((CompletableFuture)GdbModelImplUtils.launch(this.inferior, cmdLineArgs, useStarti, () -> this.environment.refreshInternal()).thenApply(__ -> null));
    }

    public CompletableFuture<Void> resume() {
        return this.impl.gateFuture(this.inferior.cont());
    }

    public CompletableFuture<Void> step(TargetSteppable.TargetStepKind kind) {
        switch (kind) {
            case SKIP: 
            case EXTENDED: {
                throw new UnsupportedOperationException(kind.name());
            }
        }
        return this.model.gateFuture(this.inferior.step(GdbModelTargetThread.convertToGdb(kind)));
    }

    public CompletableFuture<Void> kill() {
        return this.model.gateFuture(this.inferior.kill());
    }

    public CompletableFuture<Void> interrupt() {
        return this.impl.session.interrupt();
    }

    public CompletableFuture<Void> attach(TargetAttachable attachable) {
        GdbModelTargetAttachable mine = (GdbModelTargetAttachable)this.impl.assertMine(GdbModelTargetAttachable.class, (TargetObject)attachable);
        return this.attach(mine.pid);
    }

    public CompletableFuture<Void> attach(long pid) {
        return this.model.gateFuture(this.inferior.attach(pid)).thenApply(__ -> null);
    }

    public CompletableFuture<Void> detach() {
        return this.model.gateFuture(this.inferior.detach());
    }

    public CompletableFuture<Void> delete() {
        return this.model.gateFuture(this.inferior.remove());
    }

    protected CompletableFuture<Void> inferiorStarted(Long pid) {
        this.broadcast().event(this.parent, null, TargetEventScope.TargetEventType.PROCESS_CREATED, "Inferior " + this.inferior.getId() + " started " + this.inferior.getExecutable() + " pid=" + pid, List.of(this));
        AsyncFence fence = new AsyncFence();
        fence.include(this.memory.refreshInternal());
        fence.include(this.modules.refreshInternal());
        fence.include(this.threads.refreshInternal());
        fence.include(this.environment.refreshInternal());
        fence.include(this.impl.gdb.listInferiors());
        return fence.ready().thenAccept(__ -> {
            Long p = pid;
            if (p == null) {
                p = this.inferior.getPid();
            }
            if (p == null) {
                Map.Entry[] entryArray = new Map.Entry[2];
                this.state = this.realState;
                entryArray[0] = Map.entry("_state", this.state);
                entryArray[1] = Map.entry("_display", this.updateDisplay());
                this.changeAttributes(List.of(), Map.ofEntries(entryArray), "Refresh on initial break");
            } else {
                if (!this.realState.isAlive()) {
                    this.realState = TargetExecutionStateful.TargetExecutionState.ALIVE;
                }
                Map.Entry[] entryArray = new Map.Entry[3];
                this.state = this.realState;
                entryArray[0] = Map.entry("_state", this.state);
                entryArray[1] = Map.entry("_pid", p);
                entryArray[2] = Map.entry("_display", this.updateDisplay());
                this.changeAttributes(List.of(), Map.ofEntries(entryArray), "Refresh on initial break");
            }
        });
    }

    protected void inferiorExited(Long exitCode) {
        this.exitCode = exitCode;
        if (exitCode != null) {
            this.state = this.realState = TargetExecutionStateful.TargetExecutionState.TERMINATED;
            this.changeAttributes(List.of(), Map.of("_state", this.realState, EXIT_CODE_ATTRIBUTE_NAME, exitCode, "_display", this.updateDisplay()), "Exited");
        } else {
            this.state = this.realState = TargetExecutionStateful.TargetExecutionState.TERMINATED;
            this.changeAttributes(List.of(), Map.of("_state", this.realState, "_display", this.updateDisplay()), "Exited");
        }
    }

    protected void gatherThreads(List<? super GdbModelTargetThread> into, Collection<? extends GdbThread> from) {
        for (GdbThread gdbThread : from) {
            GdbModelTargetThread p = this.threads.getTargetThread(gdbThread);
            if (p == null) continue;
            into.add(p);
        }
    }

    protected void emitEvent(GdbStateChangeRecord sco, GdbModelTargetThread targetEventThread) {
        GdbReason reason = sco.getReason();
        if (reason instanceof GdbBreakpointHitReason) {
            GdbBreakpointHitReason bpHit = (GdbBreakpointHitReason)reason;
            ArrayList<GdbModelTargetBreakpointLocation> params = new ArrayList<GdbModelTargetBreakpointLocation>();
            GdbModelTargetBreakpointLocation loc = this.threads.breakpointHit(bpHit);
            if (loc != null) {
                params.add(loc);
            }
            this.gatherThreads(params, sco.getAffectedThreads());
            this.broadcast().event((TargetObject)this.impl.session, (TargetThread)targetEventThread, TargetEventScope.TargetEventType.BREAKPOINT_HIT, bpHit.desc(), params);
        } else if (reason instanceof GdbEndSteppingRangeReason) {
            ArrayList params = new ArrayList();
            this.gatherThreads(params, sco.getAffectedThreads());
            this.broadcast().event((TargetObject)this.impl.session, (TargetThread)targetEventThread, TargetEventScope.TargetEventType.STEP_COMPLETED, reason.desc(), params);
        } else if (reason instanceof GdbSignalReceivedReason) {
            GdbSignalReceivedReason signal = (GdbSignalReceivedReason)reason;
            ArrayList<String> params = new ArrayList<String>();
            params.add(signal.getSignalName());
            this.gatherThreads(params, sco.getAffectedThreads());
            this.broadcast().event((TargetObject)this.impl.session, (TargetThread)targetEventThread, TargetEventScope.TargetEventType.SIGNAL, reason.desc(), params);
        } else {
            ArrayList params = new ArrayList();
            this.gatherThreads(params, sco.getAffectedThreads());
            this.broadcast().event((TargetObject)this.impl.session, (TargetThread)targetEventThread, TargetEventScope.TargetEventType.STOPPED, reason.desc(), params);
        }
    }

    protected void inferiorRunning(GdbReason reason) {
        this.realState = TargetExecutionStateful.TargetExecutionState.RUNNING;
        if (!this.state.isAlive()) {
            return;
        }
        this.state = this.realState;
        this.changeAttributes(List.of(), Map.of("_state", this.state), reason.desc());
    }

    protected void inferiorStopped(GdbReason reason) {
        this.realState = TargetExecutionStateful.TargetExecutionState.STOPPED;
        if (!this.state.isAlive()) {
            return;
        }
        this.state = this.realState;
        this.changeAttributes(List.of(), Map.of("_state", this.state), reason.desc());
    }

    protected void updateDisplayAttribute() {
        this.changeAttributes(List.of(), Map.of("_display", this.updateDisplay()), "Display changed");
    }

    protected String updateDisplay() {
        if (this.inferior.getPid() == null) {
            this.display = String.format("%d - <null>", this.inferior.getId());
            return this.display;
        }
        Object descriptor = this.inferior.getDescriptor();
        String[] split = ((String)descriptor).split(" ");
        if (this.base == 16) {
            descriptor = split[0] + " 0x" + Long.toHexString(Long.decode(split[1]));
        }
        this.display = String.format("%d - %s - %s", this.inferior.getId(), descriptor, this.inferior.getExecutable());
        return this.display;
    }

    public String getDisplay() {
        return this.display;
    }

    public TargetExecutionStateful.TargetExecutionState getExecutionState() {
        return this.state;
    }

    protected void invalidateMemoryAndRegisterCaches() {
        this.memory.invalidateMemoryCaches();
        this.threads.invalidateRegisterCaches();
    }

    @Override
    @Internal
    public CompletableFuture<Void> setActive() {
        return this.impl.gateFuture(this.inferior.setActive(false));
    }

    @TargetAttributeType(name="_exit_code")
    public Long getExitCode() {
        return this.exitCode;
    }

    public CompletableFuture<Void> stateChanged(GdbStateChangeRecord sco) {
        GdbModelTargetThread targetEventThread = null;
        GdbThread gdbEventThread = sco.getEventThread();
        if (gdbEventThread != null && gdbEventThread.getInferior() == this.inferior) {
            targetEventThread = this.threads.getTargetThread(gdbEventThread);
        }
        if (sco.getState() == GdbState.RUNNING) {
            this.inferiorRunning(sco.getReason());
            ArrayList params = new ArrayList();
            this.gatherThreads(params, sco.getAffectedThreads());
            if (targetEventThread == null && !params.isEmpty()) {
                targetEventThread = this.threads.getTargetThread(sco.getAffectedThreads().iterator().next());
            }
            if (targetEventThread != null) {
                this.broadcast().event((TargetObject)this.impl.session, (TargetThread)targetEventThread, TargetEventScope.TargetEventType.RUNNING, "Running", params);
                this.invalidateMemoryAndRegisterCaches();
            }
        }
        if (sco.getState() != GdbState.STOPPED) {
            return this.threads.stateChanged(sco);
        }
        if (targetEventThread != null) {
            this.emitEvent(sco, targetEventThread);
        }
        AsyncFence fence = new AsyncFence();
        fence.include(this.threads.stateChanged(sco));
        this.inferiorStopped(sco.getReason());
        fence.include(this.memory.stateChanged(sco));
        return fence.ready();
    }

    public void addBreakpointLocation(GdbModelTargetBreakpointLocation loc) {
        this.breakpoints.addBreakpointLocation(loc);
    }

    public void removeBreakpointLocation(GdbModelTargetBreakpointLocation loc) {
        this.breakpoints.removeBreakpointLocation(loc);
    }

    public void setBase(Object value) {
        this.base = (Integer)value;
        this.updateDisplayAttribute();
    }
}

