/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.yaffs2;

import ghidra.file.formats.yaffs2.YAFFS2Buffer;
import ghidra.file.formats.yaffs2.YAFFS2Entry;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;

public class YAFFS2InputStream
implements Closeable {
    private int dataBufferSize = 2048;
    private static int recordSize = 2112;
    private boolean hasHitEOF;
    private long entrySize;
    long fileEntryOffset;
    protected final YAFFS2Buffer buffer;
    private YAFFS2Entry currEntry;

    public YAFFS2InputStream(InputStream is) {
        this(is, recordSize);
    }

    public YAFFS2InputStream(InputStream is, int recordSize) {
        this.buffer = new YAFFS2Buffer(is, recordSize);
        this.hasHitEOF = false;
        this.fileEntryOffset = 0L;
    }

    public YAFFS2Entry getNextHeaderEntry() throws IOException {
        long numToSkip;
        long skipped;
        if (this.hasHitEOF) {
            return null;
        }
        if (this.currEntry != null && this.currEntry.isFile() && (skipped = this.buffer.skip(numToSkip = (long)recordSize * (this.currEntry.getSize() / (long)this.dataBufferSize) + (long)recordSize)) < 0L) {
            throw new RuntimeException("failed to skip current entry's data section");
        }
        byte[] headerBuf = this.getRecord();
        if (this.hasHitEOF) {
            this.currEntry = null;
            return null;
        }
        this.currEntry = new YAFFS2Entry(headerBuf);
        this.currEntry.setFileOffset(this.fileEntryOffset);
        this.entrySize = (long)recordSize * (this.currEntry.getSize() / (long)this.dataBufferSize) + (long)recordSize;
        if (this.currEntry.isFile()) {
            this.entrySize += (long)recordSize;
        }
        this.fileEntryOffset += this.entrySize;
        return this.currEntry;
    }

    public byte[] getEntryData(long offset, long length) throws IOException {
        byte[] dataBuf;
        long numberOfBuffers = length / (long)this.dataBufferSize;
        long remainder = length % (long)this.dataBufferSize;
        long numberToRead = (long)recordSize * numberOfBuffers + remainder;
        int indx = 0;
        byte[] contents = new byte[(int)numberToRead];
        this.entrySize = offset + (long)recordSize;
        long skipped = this.buffer.skip(offset + (long)recordSize);
        if (skipped < 0L) {
            throw new RuntimeException("failed to skip to the data section");
        }
        while (numberOfBuffers > 0L) {
            dataBuf = this.getRecord();
            System.arraycopy(dataBuf, 0, contents, indx, this.dataBufferSize);
            --numberOfBuffers;
            indx += this.dataBufferSize;
        }
        if (remainder > 0L) {
            dataBuf = this.getRecord();
            System.arraycopy(dataBuf, 0, contents, indx, (int)remainder);
        }
        return contents;
    }

    private byte[] getRecord() throws IOException {
        if (this.hasHitEOF) {
            return null;
        }
        byte[] headerBuf = this.buffer.readRecord();
        if (headerBuf == null) {
            this.hasHitEOF = true;
        } else if (this.buffer.isEOFRecord(headerBuf)) {
            this.hasHitEOF = true;
        }
        return this.hasHitEOF ? null : headerBuf;
    }

    @Override
    public void close() throws IOException {
        this.buffer.close();
    }
}

