/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.manager.cmd;

import agent.dbgeng.dbgeng.DebugControl;
import agent.dbgeng.dbgeng.DebugProcessId;
import agent.dbgeng.dbgeng.DebugProcessRecord;
import agent.dbgeng.manager.DbgEvent;
import agent.dbgeng.manager.DbgProcess;
import agent.dbgeng.manager.cmd.AbstractDbgCommand;
import agent.dbgeng.manager.cmd.DbgPendingCommand;
import agent.dbgeng.manager.evt.AbstractDbgCompletedCommandEvent;
import agent.dbgeng.manager.evt.DbgConsoleOutputEvent;
import agent.dbgeng.manager.impl.DbgManagerImpl;
import agent.dbgeng.manager.impl.DbgProcessImpl;
import ghidra.util.Msg;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DbgListOSProcessesCommand
extends AbstractDbgCommand<Map<DebugProcessId, DbgProcess>> {
    private List<DebugProcessId> updatedProcessIds = new ArrayList<DebugProcessId>();

    public DbgListOSProcessesCommand(DbgManagerImpl manager) {
        super(manager);
    }

    @Override
    public boolean handle(DbgEvent<?> evt, DbgPendingCommand<?> pending) {
        if (evt instanceof AbstractDbgCompletedCommandEvent && pending.getCommand().equals(this)) {
            return true;
        }
        if (evt instanceof DbgConsoleOutputEvent) {
            pending.steal(evt);
        }
        return false;
    }

    @Override
    public Map<DebugProcessId, DbgProcess> complete(DbgPendingCommand<?> pending) {
        StringBuilder builder = new StringBuilder();
        for (DbgConsoleOutputEvent out : pending.findAllOf(DbgConsoleOutputEvent.class)) {
            builder.append(out.getOutput());
        }
        this.parse(builder.toString());
        Msg.warn((Object)this, (Object)"Completed OS process list");
        return this.manager.getKnownProcesses();
    }

    private void parse(String result) {
        String[] lines = result.split("\n");
        Long offset = null;
        for (int i = 0; i < lines.length; ++i) {
            String[] fields;
            String line = lines[i];
            if (line.contains("PROCESS")) {
                offset = null;
                fields = line.trim().split("\\s+");
                if (fields.length > 1 && fields[0].equals("PROCESS")) {
                    BigInteger val = new BigInteger(fields[1], 16);
                    offset = val.longValue();
                }
            }
            if (!line.contains("Cid:") || (fields = line.trim().split("\\s+")).length <= 3 || !fields[2].equals("Cid:")) continue;
            Long pid = Long.parseLong(fields[3], 16);
            DbgProcessImpl mirror = this.manager.getProcessComputeIfAbsent(new DebugProcessRecord(pid), pid, false);
            if (offset == null) continue;
            mirror.setOffset(offset);
            this.updatedProcessIds.add(mirror.getId());
        }
    }

    @Override
    public void invoke() {
        Msg.warn((Object)this, (Object)"Retrieving OS process list");
        DebugControl control = this.manager.getControl();
        control.execute("!process 0 0");
    }
}

