/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.jna.dbgeng;

import agent.dbgeng.dbgeng.DbgEng;
import agent.dbgeng.jna.dbgeng.Kernel32Extra;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Tlhelp32;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import ghidra.comm.util.BitmaskSet;
import ghidra.comm.util.BitmaskUniverse;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;

public class ToolhelpUtil {
    public static Snapshot createSnapshot(BitmaskSet<SnapshotFlags> flags, int processId) {
        WinDef.DWORD dwPID;
        WinDef.DWORD dwFlags = new WinDef.DWORD(flags.getBitmask());
        WinNT.HANDLE hSnap = Kernel32.INSTANCE.CreateToolhelp32Snapshot(dwFlags, dwPID = new WinDef.DWORD((long)processId));
        if (hSnap == null) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        return new Snapshot(hSnap);
    }

    public static class Snapshot {
        private final DbgEng.OpaqueCleanable cleanable;
        private final WinNT.HANDLE handle;

        private Snapshot(WinNT.HANDLE handle) {
            this.cleanable = DbgEng.releaseWhenPhantom((Object)this, handle);
            this.handle = handle;
        }

        protected <T> List<T> getItems(Supplier<T> newStruct, BiFunction<WinNT.HANDLE, T, Boolean> first, BiFunction<WinNT.HANDLE, T, Boolean> next) {
            ArrayList<T> items = new ArrayList<T>();
            T entry = newStruct.get();
            boolean has = first.apply(this.handle, (WinNT.HANDLE)entry);
            while (has) {
                items.add(entry);
                entry = newStruct.get();
                has = next.apply(this.handle, (WinNT.HANDLE)entry);
            }
            int lastError = Kernel32.INSTANCE.GetLastError();
            if (lastError != 0 && lastError != 18) {
                throw new Win32Exception(lastError);
            }
            return items;
        }

        public List<Kernel32Extra.PROCESSENTRY32W> getProcesses() {
            return this.getItems(Kernel32Extra.PROCESSENTRY32W::new, Kernel32Extra.INSTANCE::Process32FirstW, Kernel32Extra.INSTANCE::Process32NextW);
        }

        public List<Kernel32Extra.THREADENTRY32> getThreads() {
            return this.getItems(Kernel32Extra.THREADENTRY32::new, Kernel32Extra.INSTANCE::Thread32First, Kernel32Extra.INSTANCE::Thread32Next);
        }
    }

    public static enum SnapshotFlags implements BitmaskUniverse
    {
        HEAPLIST(Tlhelp32.TH32CS_SNAPHEAPLIST),
        PROCESS(Tlhelp32.TH32CS_SNAPPROCESS),
        THREAD(Tlhelp32.TH32CS_SNAPTHREAD),
        MODULE(Tlhelp32.TH32CS_SNAPMODULE),
        MODULE32(Tlhelp32.TH32CS_SNAPMODULE32),
        ALL(Tlhelp32.TH32CS_SNAPALL),
        INHERIT(Tlhelp32.TH32CS_INHERIT);

        int mask;

        private SnapshotFlags(WinDef.DWORD mask) {
            this.mask = mask.intValue();
        }

        public long getMask() {
            return this.mask;
        }
    }
}

