/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.actions;

import docking.action.ToolBarData;
import docking.menu.ActionState;
import docking.menu.MultiStateDockingAction;
import docking.widgets.EventTrigger;
import generic.theme.GIcon;
import ghidra.feature.vt.gui.actions.TableSelectionTrackingState;
import ghidra.feature.vt.gui.plugin.VTPlugin;
import ghidra.feature.vt.gui.provider.matchtable.VTMatchTableProvider;
import ghidra.util.HelpLocation;
import javax.swing.Icon;

public class MatchTableSelectionAction
extends MultiStateDockingAction<TableSelectionTrackingState> {
    private static final String MENU_GROUP = "ZZ_VT_SETTINGS";
    public static final String NAME = "Table Selection Mode";
    private final VTMatchTableProvider matchTableProvider;

    public MatchTableSelectionAction(VTMatchTableProvider matchTableProvider) {
        super(NAME, VTPlugin.OWNER);
        this.matchTableProvider = matchTableProvider;
        this.setToolBarData(new ToolBarData(null, MENU_GROUP));
        this.setDescription("Adjust the Apply Mark-up Settings for Applying Matches");
        this.setEnabled(true);
        HelpLocation helpLocation = new HelpLocation("VersionTrackingPlugin", "Match_Table_Selection");
        this.setHelpLocation(helpLocation);
        GIcon noSelectionTrackingIcon = new GIcon("icon.version.tracking.match.table.selection.track.none");
        GIcon trackMatchSelectionIcon = new GIcon("icon.version.tracking.match.table.selection.track.match");
        GIcon trackRowIndexSelectionIcon = new GIcon("icon.version.tracking.match.table.selection.track.row");
        ActionState trackSelectedIndexActionState = new ActionState("Track Selected Index", (Icon)trackRowIndexSelectionIcon, (Object)TableSelectionTrackingState.MAINTAIN_SELECTED_ROW_INDEX);
        trackSelectedIndexActionState.setHelpLocation(helpLocation);
        ActionState trackMatchSelectionActionState = new ActionState("Track Selected Match", (Icon)trackMatchSelectionIcon, (Object)TableSelectionTrackingState.MAINTAIN_SELECTED_ROW_VALUE);
        trackMatchSelectionActionState.setHelpLocation(helpLocation);
        ActionState noSelectionTrackingActionState = new ActionState("No Selection Tracking", (Icon)noSelectionTrackingIcon, (Object)TableSelectionTrackingState.NO_SELECTION_TRACKING);
        noSelectionTrackingActionState.setHelpLocation(helpLocation);
        this.addActionState(trackSelectedIndexActionState);
        this.addActionState(trackMatchSelectionActionState);
        this.addActionState(noSelectionTrackingActionState);
        this.setCurrentActionState(trackSelectedIndexActionState);
    }

    public void actionStateChanged(ActionState<TableSelectionTrackingState> newActionState, EventTrigger trigger) {
        this.matchTableProvider.setTableSelectionMode((TableSelectionTrackingState)((Object)newActionState.getUserData()));
    }
}

