/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec;

import ghidra.pcode.exec.ConcretionError;
import ghidra.pcode.exec.PcodeArithmetic;
import ghidra.pcode.exec.ValueLocation;
import ghidra.pcode.utils.Utils;
import ghidra.program.model.lang.Endian;
import java.math.BigInteger;

public enum LocationPcodeArithmetic implements PcodeArithmetic<ValueLocation>
{
    BIG_ENDIAN(Endian.BIG),
    LITTLE_ENDIAN(Endian.LITTLE);

    private final Endian endian;

    public static LocationPcodeArithmetic forEndian(boolean bigEndian) {
        return bigEndian ? BIG_ENDIAN : LITTLE_ENDIAN;
    }

    private LocationPcodeArithmetic(Endian endian) {
        this.endian = endian;
    }

    @Override
    public Endian getEndian() {
        return this.endian;
    }

    @Override
    public ValueLocation unaryOp(int opcode, int sizeout, int sizein1, ValueLocation in1) {
        switch (opcode) {
            case 1: 
            case 17: 
            case 18: {
                return in1;
            }
        }
        return null;
    }

    @Override
    public ValueLocation binaryOp(int opcode, int sizeout, int sizein1, ValueLocation in1, int sizein2, ValueLocation in2) {
        switch (opcode) {
            case 29: {
                BigInteger amount;
                BigInteger bigInteger = amount = in2 == null ? null : in2.getConst();
                if (in2 == null) {
                    return null;
                }
                return in1.shiftLeft(amount.intValue());
            }
            case 28: {
                return in1 == null || in2 == null ? null : in1.intOr(in2);
            }
        }
        return null;
    }

    @Override
    public ValueLocation modBeforeStore(int sizeout, int sizeinAddress, ValueLocation inAddress, int sizeinValue, ValueLocation inValue) {
        return inValue;
    }

    @Override
    public ValueLocation modAfterLoad(int sizeout, int sizeinAddress, ValueLocation inAddress, int sizeinValue, ValueLocation inValue) {
        return inValue;
    }

    @Override
    public ValueLocation fromConst(byte[] value) {
        return ValueLocation.fromConst(Utils.bytesToLong((byte[])value, (int)value.length, (boolean)this.endian.isBigEndian()), value.length);
    }

    @Override
    public ValueLocation fromConst(BigInteger value, int size, boolean isContextreg) {
        return ValueLocation.fromConst(value.longValueExact(), size);
    }

    @Override
    public ValueLocation fromConst(BigInteger value, int size) {
        return ValueLocation.fromConst(value.longValueExact(), size);
    }

    @Override
    public ValueLocation fromConst(long value, int size) {
        return ValueLocation.fromConst(value, size);
    }

    @Override
    public byte[] toConcrete(ValueLocation value, PcodeArithmetic.Purpose purpose) {
        throw new ConcretionError("Cannot make 'location' concrete", purpose);
    }

    @Override
    public long sizeOf(ValueLocation value) {
        return value == null ? 0L : (long)value.size();
    }
}

