/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.indexedscrollpane;

import docking.widgets.SideKickVerticalScrollbar;
import docking.widgets.indexedscrollpane.DefaultViewToIndexMapper;
import docking.widgets.indexedscrollpane.IndexScrollListener;
import docking.widgets.indexedscrollpane.IndexedScrollable;
import docking.widgets.indexedscrollpane.PreMappedViewToIndexMapper;
import docking.widgets.indexedscrollpane.UniformViewToIndexMapper;
import docking.widgets.indexedscrollpane.ViewToIndexMapper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.math.BigInteger;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;

public class IndexedScrollPane
extends JPanel
implements IndexScrollListener {
    private JScrollPane scrollPane;
    private ViewToIndexMapper indexMapper;
    private JViewport viewport;
    private Dimension visibleSize = new Dimension(0, 0);
    private int verticalOffset;
    private boolean programaticallyAdjustingScrollbar;
    private IndexedScrollable scrollable;
    private final JComponent comp;
    private ScrollView viewComponent;
    private boolean useViewSizeAsPreferredSize;
    private boolean neverScroll;

    public IndexedScrollPane(JComponent comp) {
        this.comp = comp;
        if (!(comp instanceof IndexedScrollable)) {
            throw new IllegalArgumentException("component must implement IndexedScrollable interface.");
        }
        this.scrollable = (IndexedScrollable)((Object)comp);
        this.scrollable.addIndexScrollListener(this);
        this.setLayout(new BorderLayout());
        this.viewComponent = new ScrollView(comp);
        this.scrollPane = new JScrollPane(this.viewComponent);
        this.add(this.scrollPane);
        this.viewport = this.scrollPane.getViewport();
        this.viewport.setBackground(comp.getBackground());
        this.viewport.addChangeListener(e -> this.viewportStateChanged());
        this.viewport.setScrollMode(0);
        this.indexMapper = this.createIndexMapper();
    }

    public void setNeverScroll(boolean b) {
        this.neverScroll = true;
        this.scrollPane.setVerticalScrollBarPolicy(21);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.useViewSizeAsPreferredSize = b;
    }

    private ViewToIndexMapper createIndexMapper() {
        int layoutHeight;
        BigInteger totalScrollHeight;
        if (this.neverScroll) {
            return new PreMappedViewToIndexMapper(this.scrollable);
        }
        BigInteger numIndexes = this.scrollable.getIndexCount();
        if (numIndexes.equals(BigInteger.ZERO)) {
            return new UniformViewToIndexMapper(this.scrollable);
        }
        if (this.scrollable.isUniformIndex() && (totalScrollHeight = numIndexes.multiply(BigInteger.valueOf(layoutHeight = this.scrollable.getHeight(BigInteger.ZERO)))).compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) < 0) {
            return new UniformViewToIndexMapper(this.scrollable);
        }
        if (numIndexes.compareTo(BigInteger.valueOf(1000L)) < 0) {
            return new PreMappedViewToIndexMapper(this.scrollable);
        }
        return new DefaultViewToIndexMapper(this.scrollable, this.viewport.getExtentSize().height);
    }

    public Dimension getViewSize() {
        return new Dimension(this.comp.getPreferredSize().width, this.indexMapper.getViewHeight());
    }

    public void viewportStateChanged() {
        Dimension extentSize = this.viewport.getExtentSize();
        if (!extentSize.equals(this.visibleSize)) {
            this.visibleSize = new Dimension(extentSize);
            this.indexMapper.setVisibleViewHeight(extentSize.height);
            this.comp.invalidate();
            this.repaint();
        }
        Point viewPosition = this.viewport.getViewPosition();
        if (this.verticalOffset != viewPosition.y) {
            this.verticalOffset = viewPosition.y;
            this.comp.setLocation(0, this.verticalOffset);
            if (!this.programaticallyAdjustingScrollbar) {
                this.scrollable.showIndex(this.indexMapper.getIndex(this.verticalOffset), this.indexMapper.getVerticalOffset(this.verticalOffset));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void indexRangeChanged(BigInteger startIndex, BigInteger endIndex, int yStart, int yEnd) {
        this.programaticallyAdjustingScrollbar = true;
        try {
            int scrollValue = this.indexMapper.getScrollValue(startIndex, endIndex, yStart, yEnd);
            Point p = this.viewport.getViewPosition();
            if (p.y != scrollValue) {
                this.viewport.setViewPosition(new Point(p.x, scrollValue));
            }
        }
        finally {
            this.programaticallyAdjustingScrollbar = false;
        }
    }

    @Override
    public void indexModelChanged() {
        this.indexMapper = this.createIndexMapper();
        this.viewport.doLayout();
    }

    @Override
    public void indexModelDataChanged(BigInteger start, BigInteger end) {
        this.indexMapper.indexModelDataChanged(start, end);
        this.comp.invalidate();
        this.viewport.doLayout();
    }

    public JScrollBar getHorizontalScrollBar() {
        return this.scrollPane.getHorizontalScrollBar();
    }

    public void setColumnHeader(JViewport header) {
        this.scrollPane.setColumnHeader(header);
    }

    public void setColumnHeaderComp(JComponent comp) {
        this.scrollPane.setColumnHeaderView(comp);
        Point viewPosition = this.viewport.getViewPosition();
        this.viewport.setViewPosition(new Point(0, viewPosition.y));
        this.viewport.setViewPosition(viewPosition);
    }

    public JViewport getColumnHeader() {
        return this.scrollPane.getColumnHeader();
    }

    public JScrollBar getVerticalScrollBar() {
        return this.scrollPane.getVerticalScrollBar();
    }

    public Rectangle getViewportBorderBounds() {
        return this.scrollPane.getViewportBorderBounds();
    }

    public void setScrollbarSideKickComponent(JComponent component) {
        this.scrollPane.setVerticalScrollBarPolicy(20);
        if (component == null) {
            this.scrollPane.setVerticalScrollBar(new JScrollBar());
        } else {
            this.scrollPane.setVerticalScrollBarPolicy(22);
            this.scrollPane.setVerticalScrollBar(new SideKickVerticalScrollbar(component, this.scrollPane.getViewport()));
        }
    }

    public void setWheelScrollingEnabled(boolean enabled) {
        this.scrollPane.setWheelScrollingEnabled(enabled);
    }

    class ScrollView
    extends JPanel
    implements Scrollable {
        ScrollView(JComponent component) {
            this.setLayout(new ScrollViewLayout());
            this.add(component);
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            int preferredHeight = IndexedScrollPane.this.useViewSizeAsPreferredSize ? IndexedScrollPane.this.indexMapper.getViewHeight() : 500;
            int viewWidth = IndexedScrollPane.this.comp.getPreferredSize().width;
            return new Dimension(viewWidth, preferredHeight);
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            if (orientation == 0) {
                return 10;
            }
            this.scrollPage(direction);
            return 0;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }

        @Override
        public void setSize(Dimension d) {
            super.setSize(d);
        }

        @Override
        protected void paintComponent(Graphics g) {
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return false;
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            if (orientation == 0) {
                return 10;
            }
            this.scrollLine(direction);
            return 0;
        }

        private void scrollPage(int direction) {
            SwingUtilities.invokeLater(() -> {
                if (direction < 0) {
                    IndexedScrollPane.this.scrollable.scrollPageUp();
                } else {
                    IndexedScrollPane.this.scrollable.scrollPageDown();
                }
            });
        }

        private void scrollLine(int direction) {
            SwingUtilities.invokeLater(() -> {
                if (direction < 0) {
                    IndexedScrollPane.this.scrollable.scrollLineUp();
                } else {
                    IndexedScrollPane.this.scrollable.scrollLineDown();
                }
            });
        }
    }

    class ScrollViewLayout
    implements LayoutManager {
        ScrollViewLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void layoutContainer(Container parent) {
            IndexedScrollPane.this.comp.setBounds(0, IndexedScrollPane.this.verticalOffset, parent.getSize().width, IndexedScrollPane.this.visibleSize.height);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Dimension compPreferredSize = IndexedScrollPane.this.comp.getPreferredSize();
            int height = Math.max(IndexedScrollPane.this.indexMapper.getViewHeight(), IndexedScrollPane.this.visibleSize.height);
            int viewWidth = compPreferredSize.width;
            return new Dimension(viewWidth, height);
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }
    }
}

