/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.filechooser;

import generic.theme.GIcon;
import ghidra.util.filechooser.GhidraFileChooserModel;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import javax.swing.filechooser.FileSystemView;
import resources.Icons;
import utility.function.Callback;

public class LocalFileChooserModel
implements GhidraFileChooserModel {
    private static final Icon PROBLEM_FILE_ICON = Icons.WARNING_ICON;
    private static final Icon PENDING_ROOT_ICON = new GIcon("icon.drive");
    private static final FileSystemRootInfo FS_ROOT_INFO = new FileSystemRootInfo();
    private static final FileSystemView FS_VIEW = FileSystemView.getFileSystemView();
    private Map<File, Icon> fileIconMap = new HashMap<File, Icon>();
    private Callback callback;

    public char getSeparator() {
        return File.separatorChar;
    }

    public void setModelUpdateCallback(Callback callback) {
        this.callback = callback;
    }

    public File getHomeDirectory() {
        return new File(System.getProperty("user.home"));
    }

    public File getDesktopDirectory() {
        String userHomeProp = System.getProperty("user.home");
        if (userHomeProp == null) {
            return null;
        }
        File home = new File(userHomeProp);
        File desktop = new File(home, "Desktop");
        return desktop.isDirectory() ? desktop : null;
    }

    public List<File> getRoots(boolean forceUpdate) {
        if (FS_ROOT_INFO.isEmpty() || forceUpdate) {
            FS_ROOT_INFO.updateRootInfo(this.callback);
        }
        return FS_ROOT_INFO.getRoots();
    }

    public List<File> getListing(File directory, FileFilter filter) {
        this.fileIconMap = new HashMap<File, Icon>();
        if (directory == null) {
            return List.of();
        }
        File[] files = directory.listFiles(filter);
        return files == null ? List.of() : List.of(files);
    }

    public Icon getIcon(File file) {
        if (FS_ROOT_INFO.isRoot(file)) {
            return FS_ROOT_INFO.getRootIcon(file);
        }
        Icon result = file != null && file.exists() ? this.fileIconMap.computeIfAbsent(file, this::getSystemIcon) : null;
        return result != null ? result : PROBLEM_FILE_ICON;
    }

    private Icon getSystemIcon(File file) {
        try {
            return FS_VIEW.getSystemIcon(file);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getDescription(File file) {
        if (FS_ROOT_INFO.isRoot(file)) {
            return FS_ROOT_INFO.getRootDescriptionString(file);
        }
        return FS_VIEW.getSystemTypeDescription(file);
    }

    public boolean createDirectory(File directory, String name) {
        File newDir = new File(directory, name);
        return newDir.mkdir();
    }

    public boolean isDirectory(File file) {
        return file != null && (FS_ROOT_INFO.isRoot(file) || file.isDirectory());
    }

    public boolean isAbsolute(File file) {
        if (file != null) {
            return file.isAbsolute();
        }
        return false;
    }

    public boolean renameFile(File src, File dest) {
        if (FS_ROOT_INFO.isRoot(src)) {
            return false;
        }
        return src.renameTo(dest);
    }

    private static class FileSystemRootInfo {
        private Map<File, String> descriptionMap = new ConcurrentHashMap<File, String>();
        private Map<File, Icon> iconMap = new ConcurrentHashMap<File, Icon>();
        private List<File> roots = List.of();
        private AtomicBoolean updatePending = new AtomicBoolean();

        private FileSystemRootInfo() {
        }

        synchronized boolean isEmpty() {
            return this.roots.isEmpty();
        }

        synchronized boolean isRoot(File f) {
            for (File root : this.roots) {
                if (!root.equals(f)) continue;
                return true;
            }
            return false;
        }

        synchronized List<File> getRoots() {
            return new ArrayList<File>(this.roots);
        }

        Icon getRootIcon(File root) {
            return this.iconMap.get(root);
        }

        String getRootDescriptionString(File root) {
            return this.descriptionMap.get(root);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void updateRootInfo(Callback callback) {
            if (!this.updatePending.compareAndSet(false, true)) return;
            File[] localRoots = this.listRoots();
            File[] fileArray = this;
            synchronized (this) {
                this.roots = List.of(localRoots);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                for (File root : localRoots) {
                    this.descriptionMap.put(root, this.getInitialRootDescriptionString(root));
                    this.iconMap.put(root, PENDING_ROOT_ICON);
                }
                Thread updateThread = new Thread(() -> this.asyncUpdateRootInfo(localRoots, Callback.dummyIfNull((Callback)callback)));
                updateThread.setName("GhidraFileChooser File System Updater");
                updateThread.start();
                return;
            }
        }

        private File[] listRoots() {
            File[] tmpRoots = File.listRoots();
            return tmpRoots != null ? tmpRoots : new File[]{};
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void asyncUpdateRootInfo(File[] localRoots, Callback callback) {
            try {
                for (File root : localRoots) {
                    String fastRootDescriptionString = this.getFastRootDescriptionString(root);
                    if (fastRootDescriptionString == null) continue;
                    this.descriptionMap.put(root, fastRootDescriptionString);
                    callback.call();
                }
                for (File root : localRoots) {
                    Icon rootIcon;
                    String slowRootDescriptionString = this.getSlowRootDescriptionString(root);
                    if (slowRootDescriptionString != null) {
                        this.descriptionMap.put(root, slowRootDescriptionString);
                        callback.call();
                    }
                    if ((rootIcon = FS_VIEW.getSystemIcon(root)) == null) {
                        rootIcon = PROBLEM_FILE_ICON;
                    }
                    this.iconMap.put(root, rootIcon);
                    callback.call();
                }
            }
            finally {
                this.updatePending.set(false);
            }
        }

        private String getInitialRootDescriptionString(File root) {
            return String.format("Unknown (%s)", this.formatRootPathForDisplay(root));
        }

        private String getFastRootDescriptionString(File root) {
            try {
                String fsvSTD = FS_VIEW.getSystemTypeDescription(root);
                return String.format("%s (%s)", fsvSTD, this.formatRootPathForDisplay(root));
            }
            catch (Exception exception) {
                return null;
            }
        }

        private String formatRootPathForDisplay(File root) {
            String s = root.getPath();
            return s.length() > 1 && s.endsWith("\\") ? s.substring(0, s.length() - 1) : s;
        }

        private String getSlowRootDescriptionString(File root) {
            if ("/".equals(root.getPath())) {
                return "File system root (/)";
            }
            if (FS_VIEW.isFloppyDrive(root)) {
                return String.format("Floppy (%s)", this.formatRootPathForDisplay(root));
            }
            String fsvSTD = null;
            try {
                fsvSTD = FS_VIEW.getSystemTypeDescription(root);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (fsvSTD == null || fsvSTD.toLowerCase().indexOf("removable") != -1) {
                return String.format("Removable Disk (%s)", this.formatRootPathForDisplay(root));
            }
            return FS_VIEW.getSystemDisplayName(root);
        }
    }
}

