/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.model.impl;

import SWIG.SBProcess;
import SWIG.SBStream;
import SWIG.SBThread;
import SWIG.StateType;
import SWIG.StopReason;
import agent.lldb.lldb.DebugClient;
import agent.lldb.manager.LldbCause;
import agent.lldb.manager.LldbReason;
import agent.lldb.manager.cmd.LldbAttachCommand;
import agent.lldb.manager.cmd.LldbContinueCommand;
import agent.lldb.manager.cmd.LldbDestroyCommand;
import agent.lldb.manager.cmd.LldbDetachCommand;
import agent.lldb.manager.cmd.LldbKillCommand;
import agent.lldb.manager.cmd.LldbLaunchProcessCommand;
import agent.lldb.manager.cmd.LldbStepCommand;
import agent.lldb.manager.impl.LldbManagerImpl;
import agent.lldb.model.iface1.LldbModelTargetFocusScope;
import agent.lldb.model.iface2.LldbModelTargetBreakpointLocation;
import agent.lldb.model.iface2.LldbModelTargetProcess;
import agent.lldb.model.iface2.LldbModelTargetProcessContainer;
import agent.lldb.model.iface2.LldbModelTargetThreadContainer;
import agent.lldb.model.impl.LldbModelTargetBreakpointLocationContainerImpl;
import agent.lldb.model.impl.LldbModelTargetMemoryContainerImpl;
import agent.lldb.model.impl.LldbModelTargetObjectImpl;
import agent.lldb.model.impl.LldbModelTargetThreadContainerImpl;
import agent.lldb.model.impl.LldbModelTargetThreadImpl;
import ghidra.async.AsyncUtils;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.target.TargetAttachable;
import ghidra.dbg.target.TargetAttacher;
import ghidra.dbg.target.TargetEventScope;
import ghidra.dbg.target.TargetExecutionStateful;
import ghidra.dbg.target.TargetFocusScope;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetSteppable;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.dbg.util.PathUtils;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

@TargetObjectSchemaInfo(name="Process", attributeResync=TargetObjectSchema.ResyncMode.ALWAYS, elements={@TargetElementType(type=Void.class)}, attributes={@TargetAttributeType(name="Memory", type=LldbModelTargetMemoryContainerImpl.class, required=true, fixed=true), @TargetAttributeType(name="Threads", type=LldbModelTargetThreadContainerImpl.class, required=true, fixed=true), @TargetAttributeType(name="Breakpoints", type=LldbModelTargetBreakpointLocationContainerImpl.class, required=true, fixed=true), @TargetAttributeType(name="_exit_code", type=String.class), @TargetAttributeType(type=Void.class)})
public class LldbModelTargetProcessImpl
extends LldbModelTargetObjectImpl
implements LldbModelTargetProcess {
    public static final String PID_ATTRIBUTE_NAME = "_pid";
    public static final String EXIT_CODE_ATTRIBUTE_NAME = "_exit_code";
    public static final TargetAttacher.TargetAttachKindSet SUPPORTED_KINDS = TargetAttacher.TargetAttachKindSet.of((TargetAttacher.TargetAttachKind[])new TargetAttacher.TargetAttachKind[]{TargetAttacher.TargetAttachKind.BY_OBJECT_REF, TargetAttacher.TargetAttachKind.BY_ID});
    protected final LldbModelTargetMemoryContainerImpl memory;
    protected final LldbModelTargetThreadContainerImpl threads;
    protected final LldbModelTargetBreakpointLocationContainerImpl breakpoints;
    private Integer base = 16;

    protected static String indexProcess(SBProcess process) {
        return DebugClient.getId(process);
    }

    protected static String keyProcess(SBProcess process) {
        return PathUtils.makeKey((String)LldbModelTargetProcessImpl.indexProcess(process));
    }

    public LldbModelTargetProcessImpl(LldbModelTargetProcessContainer processes, SBProcess process) {
        super(processes.getModel(), (TargetObject)processes, LldbModelTargetProcessImpl.keyProcess(process), process, "Process");
        this.getModel().addModelObject(process, (TargetObject)this);
        this.getManager().getClient().addBroadcaster(process);
        this.memory = new LldbModelTargetMemoryContainerImpl(this);
        this.threads = new LldbModelTargetThreadContainerImpl(this);
        this.breakpoints = new LldbModelTargetBreakpointLocationContainerImpl(this);
        TargetExecutionStateful.TargetExecutionState state = DebugClient.convertState(process.GetState());
        this.accessible = false;
        this.changeAttributes(List.of(), List.of(this.memory, this.threads, this.breakpoints), Map.of("_accessible", false, "_display", this.getDisplay(), "_parameters", PARAMETERS, "_state", state, "_supported_attach_kinds", SUPPORTED_KINDS, "_supported_step_kinds", LldbModelTargetThreadImpl.SUPPORTED_KINDS), "Initialized");
        this.setExecutionState(state, "Initialized");
        this.getManager().addEventsListener(this);
    }

    @Override
    public void setModelObject(Object modelObject) {
        super.setModelObject(modelObject);
        this.getModel().addModelObject(modelObject, (TargetObject)this);
    }

    @Override
    public String getDescription(int level) {
        SBStream stream = new SBStream();
        SBProcess process = (SBProcess)this.getModelObject();
        process.GetDescription(stream);
        return stream.GetData();
    }

    public String getDisplay() {
        Object pidstr = DebugClient.getId(this.getProcess());
        pidstr = this.base == 16 ? "0x" + (String)pidstr : Long.toString(Long.parseLong((String)pidstr, 16));
        return "[" + (String)pidstr + "]";
    }

    @Override
    public void processSelected(SBProcess eventProcess, LldbCause cause) {
        if (eventProcess.GetProcessID().equals(this.getProcess().GetProcessID())) {
            ((LldbModelTargetFocusScope)this.searchForSuitable(TargetFocusScope.class)).setFocus(this);
        }
    }

    @Override
    public void threadStateChanged(SBThread thread, StateType state, LldbCause cause, LldbReason reason) {
        TargetExecutionStateful.TargetExecutionState targetState = DebugClient.convertState(state);
        this.setExecutionState(targetState, "ThreadStateChanged");
        if (state.equals(StateType.eStateStopped)) {
            this.threads.requestElements(DebuggerObjectModel.RefreshBehavior.REFRESH_ALWAYS);
            StopReason stopReason = this.getManager().getCurrentThread().GetStopReason();
            if (!stopReason.equals(StopReason.eStopReasonPlanComplete)) {
                this.memory.requestElements(DebuggerObjectModel.RefreshBehavior.REFRESH_ALWAYS);
            }
        }
    }

    @Override
    public CompletableFuture<Void> launch(List<String> args) {
        this.model.gateFuture(this.getManager().execute(new LldbLaunchProcessCommand(this.getManager(), this.getProcess().GetProcessInfo().GetName(), args)));
        return AsyncUtils.NIL;
    }

    @Override
    public CompletableFuture<Void> resume() {
        return this.model.gateFuture(this.getManager().execute(new LldbContinueCommand(this.getManager(), this.getProcess())));
    }

    @Override
    public CompletableFuture<Void> kill() {
        return this.model.gateFuture(this.getManager().execute(new LldbKillCommand(this.getManager())));
    }

    @Override
    public CompletableFuture<Void> destroy() {
        return this.model.gateFuture(this.getManager().execute(new LldbDestroyCommand(this.getManager())));
    }

    @Override
    public CompletableFuture<Void> attach(TargetAttachable attachable) {
        this.getModel().assertMine(TargetObject.class, (TargetObject)attachable);
        SBProcess proc = (SBProcess)this.getModelObject();
        long pid = proc.GetProcessID().longValue();
        return this.model.gateFuture((CompletableFuture)this.getManager().execute(new LldbAttachCommand(this.getManager(), Long.toString(pid))).thenApply(__ -> null));
    }

    @Override
    public CompletableFuture<Void> attach(long pid) {
        return this.model.gateFuture((CompletableFuture)this.getManager().execute(new LldbAttachCommand(this.getManager(), Long.toString(pid))).thenApply(__ -> null));
    }

    @Override
    public CompletableFuture<Void> detach() {
        return this.model.gateFuture(this.getManager().execute(new LldbDetachCommand(this.getManager(), this.getProcess())));
    }

    @Override
    public CompletableFuture<Void> delete() {
        return AsyncUtils.NIL;
    }

    public CompletableFuture<Void> step(TargetSteppable.TargetStepKind kind) {
        LldbManagerImpl manager = this.getManager();
        return this.getManager().execute(new LldbStepCommand(manager, null, kind, null));
    }

    public CompletableFuture<Void> step(Map<String, ?> args) {
        LldbManagerImpl manager = this.getManager();
        return this.getManager().execute(new LldbStepCommand(manager, null, null, args));
    }

    @Override
    public void processStarted(SBProcess proc) {
        if (proc != null) {
            this.changeAttributes(List.of(), List.of(), Map.of(PID_ATTRIBUTE_NAME, this.getProcess().GetProcessID().longValue(), "_display", this.getDisplay(), "_state", TargetExecutionStateful.TargetExecutionState.STOPPED), "Started");
        }
        this.setExecutionState(TargetExecutionStateful.TargetExecutionState.STOPPED, "Started");
    }

    @Override
    public void processExited(SBProcess proc, LldbCause cause) {
        if (proc.GetProcessID().equals(this.getProcess().GetProcessID())) {
            String exitDesc = proc.GetExitDescription();
            if (exitDesc == null) {
                exitDesc = "NONE";
            }
            this.changeAttributes(List.of(), List.of(), Map.of("_state", TargetExecutionStateful.TargetExecutionState.TERMINATED, EXIT_CODE_ATTRIBUTE_NAME, exitDesc), "Exited");
            this.broadcast().event((TargetObject)this.getProxy(), null, TargetEventScope.TargetEventType.PROCESS_EXITED, "Process " + DebugClient.getId(this.getProcess()) + " exited code=" + exitDesc, List.of(this.getProxy()));
        }
    }

    @Override
    public CompletableFuture<Void> setActive() {
        return this.getManager().setActiveProcess(this.getProcess());
    }

    @Override
    public LldbModelTargetThreadContainer getThreads() {
        return this.threads;
    }

    @Override
    public SBProcess getProcess() {
        return (SBProcess)this.getModelObject();
    }

    @Override
    public boolean isAccessible() {
        return this.accessible;
    }

    public void setBase(Object value) {
        this.base = (Integer)value;
        this.changeAttributes(List.of(), List.of(), Map.of("_display", this.getDisplay()), "Started");
    }

    public void addBreakpointLocation(LldbModelTargetBreakpointLocation loc) {
        this.breakpoints.addBreakpointLocation(loc);
    }

    public void removeBreakpointLocation(LldbModelTargetBreakpointLocation loc) {
        this.breakpoints.removeBreakpointLocation(loc);
    }
}

