/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.model.impl;

import agent.lldb.lldb.DebugClient;
import agent.lldb.manager.LldbManager;
import agent.lldb.manager.impl.LldbManagerImpl;
import agent.lldb.model.AbstractLldbModel;
import agent.lldb.model.iface2.LldbModelTargetProcess;
import agent.lldb.model.iface2.LldbModelTargetSession;
import agent.lldb.model.impl.LldbModelTargetMemoryContainerImpl;
import agent.lldb.model.impl.LldbModelTargetRootImpl;
import ghidra.async.AsyncUtils;
import ghidra.dbg.DebuggerModelClosedReason;
import ghidra.dbg.DebuggerModelListener;
import ghidra.dbg.DebuggerObjectModelWithMemory;
import ghidra.dbg.error.DebuggerModelTerminatingException;
import ghidra.dbg.target.TargetMemory;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.AnnotatedSchemaContext;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.DefaultAddressFactory;
import ghidra.program.model.address.GenericAddressSpace;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class LldbModelImpl
extends AbstractLldbModel
implements DebuggerObjectModelWithMemory {
    protected static final String SPACE_NAME = "ram";
    protected static final AnnotatedSchemaContext SCHEMA_CTX = new AnnotatedSchemaContext();
    protected static final TargetObjectSchema ROOT_SCHEMA = SCHEMA_CTX.getSchemaForClass(LldbModelTargetRootImpl.class);
    protected final AddressSpace space = new GenericAddressSpace("ram", 64, 1, 0);
    protected final AddressFactory addressFactory = new DefaultAddressFactory(new AddressSpace[]{this.space});
    protected LldbManager manager;
    protected final LldbModelTargetRootImpl root;
    protected LldbModelTargetSession session;
    protected final CompletableFuture<LldbModelTargetRootImpl> completedRoot;
    protected Map<Object, TargetObject> objectMap = new HashMap<Object, TargetObject>();

    public LldbModelImpl() {
        this.manager = LldbManager.newInstance();
        this.root = new LldbModelTargetRootImpl(this, ROOT_SCHEMA);
        this.completedRoot = CompletableFuture.completedFuture(this.root);
        this.addModelRoot(this.root);
    }

    public String getBrief() {
        return "LLDB@" + Integer.toHexString(System.identityHashCode((Object)this));
    }

    public AddressSpace getAddressSpace(String name) {
        if (!SPACE_NAME.equals(name)) {
            return null;
        }
        return this.space;
    }

    @Override
    public AddressFactory getAddressFactory() {
        return this.addressFactory;
    }

    @Override
    public CompletableFuture<Void> startLLDB(String[] args) {
        return this.manager.start(args).thenApplyAsync(__ -> null, (Executor)this.clientExecutor);
    }

    @Override
    public boolean isRunning() {
        return this.manager.isRunning();
    }

    @Override
    public void terminate() throws IOException {
        ((DebuggerModelListener)this.listeners.fire).modelClosed(DebuggerModelClosedReason.NORMAL);
        this.root.invalidateSubtree((TargetObject)this.root, "LLDB is terminating");
        this.manager.terminate();
    }

    public TargetObjectSchema getRootSchema() {
        return this.root.getSchema();
    }

    public CompletableFuture<? extends TargetObject> fetchModelRoot() {
        return this.completedRoot;
    }

    @Override
    public LldbManagerImpl getManager() {
        return (LldbManagerImpl)this.manager;
    }

    public CompletableFuture<Void> close() {
        try {
            this.terminate();
            return super.close();
        }
        catch (RejectedExecutionException e) {
            this.reportError((Object)this, "Model is already closing", e);
            return AsyncUtils.NIL;
        }
        catch (Throwable t) {
            return CompletableFuture.failedFuture(t);
        }
    }

    @Override
    public LldbModelTargetSession getSession() {
        return this.session;
    }

    public TargetMemory getMemory(TargetObject target, Address address, int length) {
        if (target instanceof LldbModelTargetProcess) {
            LldbModelTargetProcess process = (LldbModelTargetProcess)target;
            return new LldbModelTargetMemoryContainerImpl(process);
        }
        return null;
    }

    @Override
    public void addModelObject(Object object, TargetObject targetObject) {
        if (object == null) {
            return;
        }
        this.objectMap.put(DebugClient.getModelKey(object), targetObject);
    }

    @Override
    public TargetObject getModelObject(Object object) {
        if (object == null) {
            return null;
        }
        return this.objectMap.get(DebugClient.getModelKey(object));
    }

    public void deleteModelObject(Object object) {
        if (object == null) {
            return;
        }
        this.objectMap.remove(DebugClient.getModelKey(object));
    }

    public <T> CompletableFuture<T> gateFuture(CompletableFuture<T> future) {
        return super.gateFuture(future).exceptionally(ex -> {
            for (Throwable cause = ex; cause != null; cause = cause.getCause()) {
                if (!(cause instanceof RejectedExecutionException)) continue;
                throw new DebuggerModelTerminatingException("LLDB is terminating", ex);
            }
            return ExceptionUtils.rethrow((Throwable)ex);
        });
    }
}

