/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;

public class MultiAddressIterator {
    AddressIterator[] iters;
    Address[] addrs;
    boolean forward;

    public MultiAddressIterator(AddressIterator[] iters) {
        this.iters = iters;
        this.addrs = new Address[iters.length];
        this.forward = true;
    }

    public MultiAddressIterator(AddressIterator[] iters, boolean forward) {
        this.iters = iters;
        this.addrs = new Address[iters.length];
        this.forward = forward;
    }

    public boolean hasNext() {
        for (int i = 0; i < this.iters.length; ++i) {
            if (this.addrs[i] == null && (this.iters[i] == null || !this.iters[i].hasNext())) continue;
            return true;
        }
        return false;
    }

    public Address next() {
        int i;
        for (int i2 = 0; i2 < this.iters.length; ++i2) {
            if (this.addrs[i2] != null || this.iters[i2] == null || !this.iters[i2].hasNext()) continue;
            this.addrs[i2] = this.iters[i2].next();
        }
        Address addrNext = null;
        boolean[] next = new boolean[this.iters.length];
        for (i = 0; i < this.iters.length; ++i) {
            if (this.addrs[i] == null) continue;
            if (addrNext == null) {
                addrNext = this.addrs[i];
                next[i] = true;
                continue;
            }
            int result = addrNext.compareTo((Object)this.addrs[i]);
            if (result == 0) {
                next[i] = true;
                continue;
            }
            if ((!this.forward || result <= 0) && (this.forward || result >= 0)) continue;
            addrNext = this.addrs[i];
            for (int n = 0; n < i; ++n) {
                next[n] = false;
            }
            next[i] = true;
        }
        for (i = 0; i < this.iters.length; ++i) {
            if (!next[i]) continue;
            this.addrs[i] = null;
        }
        return addrNext;
    }

    public Address[] nextAddresses() {
        for (int i = 0; i < this.iters.length; ++i) {
            if (this.addrs[i] != null || !this.iters[i].hasNext()) continue;
            this.addrs[i] = this.iters[i].next();
        }
        Address addrNext = null;
        boolean[] next = new boolean[this.iters.length];
        for (int i = 0; i < this.iters.length; ++i) {
            if (this.addrs[i] == null) continue;
            if (addrNext == null) {
                addrNext = this.addrs[i];
                next[i] = true;
                continue;
            }
            int result = addrNext.compareTo((Object)this.addrs[i]);
            if (result == 0) {
                next[i] = true;
                continue;
            }
            if ((!this.forward || result <= 0) && (this.forward || result >= 0)) continue;
            addrNext = this.addrs[i];
            for (int n = 0; n < i; ++n) {
                next[n] = false;
            }
            next[i] = true;
        }
        Address[] nextAddr = new Address[this.iters.length];
        for (int i = 0; i < this.iters.length; ++i) {
            if (!next[i]) continue;
            nextAddr[i] = this.addrs[i];
            this.addrs[i] = null;
        }
        return nextAddr;
    }
}

