/*
 * Decompiled with CFR 0.152.
 */
package ghidra.plugins.fsbrowser;

import docking.ComponentProvider;
import docking.DefaultActionContext;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.GFileSystemProgramProvider;
import ghidra.plugins.fsbrowser.FSBDirNode;
import ghidra.plugins.fsbrowser.FSBFileNode;
import ghidra.plugins.fsbrowser.FSBNode;
import ghidra.plugins.fsbrowser.FSBRootNode;
import ghidra.plugins.fsbrowser.FileSystemBrowserComponentProvider;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.TreePath;

public class FSBActionContext
extends DefaultActionContext {
    private GTree gTree;

    public FSBActionContext(FileSystemBrowserComponentProvider provider, FSBNode[] selectedNodes, MouseEvent event, GTree gTree) {
        super((ComponentProvider)provider, (Object)selectedNodes, (Component)gTree);
        this.gTree = gTree;
    }

    public boolean notBusy() {
        return !this.gTree.isBusy();
    }

    public boolean isBusy() {
        return this.gTree.isBusy();
    }

    public GTree getTree() {
        return this.gTree;
    }

    public boolean hasSelectedNodes() {
        FSBNode[] selectedNodes = (FSBNode[])this.getContextObject();
        return selectedNodes.length > 0;
    }

    public List<FSBNode> getSelectedNodes() {
        return List.of((FSBNode[])this.getContextObject());
    }

    public FSRL getFSRL(boolean dirsOk) {
        boolean isDir;
        FSBNode[] selectedNodes = (FSBNode[])this.getContextObject();
        if (selectedNodes.length != 1) {
            return null;
        }
        FSBNode node = selectedNodes[0];
        FSRL fsrl = node.getFSRL();
        if (!dirsOk && node instanceof FSBRootNode && this.fsrlHasContainer(fsrl.getFS())) {
            return fsrl.getFS().getContainer();
        }
        boolean bl = isDir = node instanceof FSBDirNode || node instanceof FSBRootNode;
        if (isDir && !dirsOk) {
            return null;
        }
        return fsrl;
    }

    private boolean fsrlHasContainer(FSRLRoot fsFSRL) {
        return fsFSRL.hasContainer() && !fsFSRL.getProtocol().equals("file");
    }

    public boolean isSelectedAllDirs() {
        FSBNode[] selectedNodes;
        for (FSBNode node : selectedNodes = (FSBNode[])this.getContextObject()) {
            boolean isDir;
            boolean bl = isDir = node instanceof FSBDirNode || node instanceof FSBRootNode;
            if (isDir) continue;
            return false;
        }
        return true;
    }

    public FSBNode getSelectedNode() {
        FSBNode[] selectedNodes = (FSBNode[])this.getContextObject();
        return selectedNodes.length == 1 ? selectedNodes[0] : null;
    }

    public FSBRootNode getRootOfSelectedNode() {
        return this.getRootOfNode((GTreeNode)this.getSelectedNode());
    }

    private FSBRootNode getRootOfNode(GTreeNode tmp) {
        while (tmp != null && !(tmp instanceof FSBRootNode)) {
            tmp = tmp.getParent();
        }
        return tmp instanceof FSBRootNode ? (FSBRootNode)tmp : null;
    }

    public int getSelectedCount() {
        FSBNode[] selectedNodes = (FSBNode[])this.getContextObject();
        return selectedNodes.length;
    }

    private List<FSRL> getFSRLsFromNodes(FSBNode[] nodes, boolean dirsOk) {
        ArrayList<FSRL> fsrls = new ArrayList<FSRL>();
        for (FSBNode node : nodes) {
            FSRL fsrl = node.getFSRL();
            if (!node.isLeaf() && !dirsOk) {
                boolean canConvertToContainerNode;
                boolean bl = canConvertToContainerNode = node instanceof FSBRootNode && fsrl.getFS().hasContainer();
                if (!canConvertToContainerNode) continue;
                fsrl = fsrl.getFS().getContainer();
            }
            fsrls.add(fsrl);
        }
        return fsrls;
    }

    public List<FSRL> getFSRLs(boolean dirsOk) {
        FSBNode[] selectedNodes = (FSBNode[])this.getContextObject();
        return this.getFSRLsFromNodes(selectedNodes, dirsOk);
    }

    public List<FSRL> getFileFSRLs() {
        return this.getFSRLs(false);
    }

    public FSRL getFileFSRL() {
        return this.getFSRL(false);
    }

    public String getFormattedTreePath() {
        FSBNode[] selectedNodes = (FSBNode[])this.getContextObject();
        if (selectedNodes.length != 1) {
            return null;
        }
        TreePath treePath = selectedNodes[0].getTreePath();
        StringBuilder path = new StringBuilder();
        for (Object pathElement : treePath.getPath()) {
            if (!(pathElement instanceof FSBNode)) continue;
            FSBNode node = (FSBNode)((Object)pathElement);
            FSRL fsrl = node.getFSRL();
            if (path.length() != 0) {
                path.append("/");
            }
            String s = fsrl instanceof FSRLRoot ? (fsrl.getFS().hasContainer() ? fsrl.getFS().getContainer().getName() : "/") : fsrl.getName();
            path.append(s);
        }
        return path.toString();
    }

    public FSRL getLoadableFSRL() {
        FSBRootNode rootNode;
        GFileSystem fs;
        FSBNode node = this.getSelectedNode();
        if (node == null) {
            return null;
        }
        FSRL fsrl = node.getFSRL();
        if ((node instanceof FSBDirNode || node instanceof FSBRootNode) && (fs = (rootNode = this.getRootOfSelectedNode()).getFSRef().getFilesystem()) instanceof GFileSystemProgramProvider) {
            try {
                GFile gfile = fs.lookup(node.getFSRL().getPath());
                if (gfile != null && ((GFileSystemProgramProvider)((Object)fs)).canProvideProgram(gfile)) {
                    return fsrl;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (node instanceof FSBRootNode && fsrl.getFS().hasContainer()) {
            return fsrl.getFS().getContainer();
        }
        return node instanceof FSBFileNode ? fsrl : null;
    }

    public List<FSRL> getLoadableFSRLs() {
        FSBNode[] selectedNodes = (FSBNode[])this.getContextObject();
        ArrayList<FSRL> fsrls = new ArrayList<FSRL>();
        for (FSBNode node : selectedNodes) {
            FSRL fsrl = node.getFSRL();
            FSRL validated = this.vaildateFsrl(fsrl, node);
            if (validated != null) {
                fsrls.add(validated);
                continue;
            }
            if (node instanceof FSBRootNode && fsrl.getFS().hasContainer()) {
                fsrls.add(fsrl.getFS().getContainer());
                continue;
            }
            if (!(node instanceof FSBFileNode)) continue;
            fsrls.add(fsrl);
        }
        return fsrls;
    }

    private FSRL vaildateFsrl(FSRL fsrl, FSBNode node) {
        FSBRootNode rootNode;
        GFileSystem fs;
        if ((node instanceof FSBDirNode || node instanceof FSBRootNode) && (fs = (rootNode = this.getRootOfNode((GTreeNode)node)).getFSRef().getFilesystem()) instanceof GFileSystemProgramProvider) {
            try {
                GFile gfile = fs.lookup(node.getFSRL().getPath());
                if (gfile != null && ((GFileSystemProgramProvider)((Object)fs)).canProvideProgram(gfile)) {
                    return fsrl;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }
}

