/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import docking.widgets.fieldpanel.field.AttributedString;
import docking.widgets.fieldpanel.field.ClippingTextField;
import docking.widgets.fieldpanel.field.CompositeAttributedString;
import docking.widgets.fieldpanel.field.CompositeFieldElement;
import docking.widgets.fieldpanel.field.CompositeVerticalLayoutTextField;
import docking.widgets.fieldpanel.field.FieldElement;
import docking.widgets.fieldpanel.field.FlowLayoutTextField;
import docking.widgets.fieldpanel.field.StrutFieldElement;
import docking.widgets.fieldpanel.field.TextField;
import docking.widgets.fieldpanel.field.TextFieldElement;
import docking.widgets.fieldpanel.support.FieldHighlightFactory;
import docking.widgets.fieldpanel.support.FieldLocation;
import docking.widgets.fieldpanel.support.RowColLocation;
import generic.theme.GColor;
import generic.theme.GThemeDefaults;
import ghidra.app.util.ListingHighlightProvider;
import ghidra.app.util.XReferenceUtils;
import ghidra.app.util.viewer.field.BrowserCodeUnitFormat;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.ListingColors;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.app.util.viewer.field.ListingFieldHighlightFactoryAdapter;
import ghidra.app.util.viewer.field.ListingTextField;
import ghidra.app.util.viewer.field.NamespacePropertyEditor;
import ghidra.app.util.viewer.field.NamespaceWrappedOption;
import ghidra.app.util.viewer.format.FieldFormatModel;
import ghidra.app.util.viewer.proxy.ProxyObj;
import ghidra.framework.options.CustomOption;
import ghidra.framework.options.OptionType;
import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.DataRefType;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ThunkReference;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.XRefFieldLocation;
import ghidra.util.HelpLocation;
import ghidra.util.exception.AssertException;
import java.awt.Color;
import java.awt.FontMetrics;
import java.beans.PropertyEditor;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import javax.swing.event.ChangeListener;
import util.CollectionUtils;

public class XRefFieldFactory
extends FieldFactory {
    static final String MORE_XREFS_STRING = "[more]";
    public static final String FIELD_NAME = "XRef";
    private static final String DELIMITER = ", ";
    private static final int MAX_XREFS = 20;
    protected SORT_CHOICE sortChoice = SORT_CHOICE.Address;
    private static final String GROUP_TITLE = "XREFs Field";
    private static final String DELIMITER_KEY = "XREFs Field.Delimiter";
    static final String MAX_XREFS_KEY = "XREFs Field.Maximum Number of XREFs to Display";
    private static final String DISPLAY_BLOCK_NAME_KEY = "XREFs Field.Display Local Block";
    private static final String SORT_OPTION_KEY = "XREFs Field.Sort References by";
    private static final String DISPLAY_REFERENCE_TYPE_KEY = "XREFs Field.Display Reference Type";
    private static final String NAMESPACE_OPTIONS_KEY = "XREFs Field.Display Namespace";
    static final String GROUP_BY_FUNCTION_KEY = "XREFs Field.Group by Function";
    private PropertyEditor namespaceOptionsEditor = new NamespacePropertyEditor();
    protected String delim = ", ";
    protected boolean displayBlockName;
    protected boolean groupByFunction;
    protected int maxXRefs = 20;
    protected boolean displayRefType = true;
    protected Comparator<Reference> typeComparator;
    protected boolean displayLocalNamespace;
    protected boolean displayNonLocalNamespace;
    protected boolean useLocalPrefixOverride;
    protected String localPrefixText;
    private BrowserCodeUnitFormat codeUnitFormat;
    private ChangeListener codeUnitFormatListener = e -> this.model.update();

    public XRefFieldFactory() {
        this(FIELD_NAME);
    }

    protected XRefFieldFactory(String name) {
        super(name);
    }

    public XRefFieldFactory(FieldFormatModel model, ListingHighlightProvider hlProvider, Options displayOptions, ToolOptions fieldOptions) {
        this(FIELD_NAME, model, hlProvider, displayOptions, fieldOptions);
    }

    protected XRefFieldFactory(String name, FieldFormatModel model, ListingHighlightProvider hlProvider, Options displayOptions, ToolOptions fieldOptions) {
        super(name, model, hlProvider, displayOptions, (Options)fieldOptions);
        HelpLocation hl = new HelpLocation("CodeBrowserPlugin", "XREFs_Field");
        fieldOptions.registerOption(DELIMITER_KEY, (Object)DELIMITER, hl, "Delimiter string used for separating multiple xrefs.");
        fieldOptions.registerOption(DISPLAY_BLOCK_NAME_KEY, (Object)false, hl, "Prepends xref addresses with the name of the memory block containing the xref address.");
        fieldOptions.registerOption(MAX_XREFS_KEY, (Object)20, hl, "Sets the maximum number of xrefs to display.");
        fieldOptions.registerOption(DISPLAY_REFERENCE_TYPE_KEY, (Object)true, hl, "Appends xref type.");
        fieldOptions.registerOption(SORT_OPTION_KEY, (Object)SORT_CHOICE.Address, hl, "How to sort the xrefs");
        fieldOptions.registerOption(GROUP_BY_FUNCTION_KEY, (Object)false, hl, "True signals to group all xrefs by the containing calling function.");
        this.typeComparator = (r1, r2) -> {
            if (r1.getReferenceType().toString().equals(r2.getReferenceType().toString())) {
                return r1.compareTo(r2);
            }
            return r1.getReferenceType().toString().compareTo(r2.getReferenceType().toString());
        };
        this.delim = fieldOptions.getString(DELIMITER_KEY, DELIMITER);
        this.displayBlockName = fieldOptions.getBoolean(DISPLAY_BLOCK_NAME_KEY, false);
        this.maxXRefs = fieldOptions.getInt(MAX_XREFS_KEY, 20);
        this.sortChoice = (SORT_CHOICE)fieldOptions.getEnum(SORT_OPTION_KEY, (Enum)SORT_CHOICE.Address);
        this.displayRefType = fieldOptions.getBoolean(DISPLAY_REFERENCE_TYPE_KEY, true);
        this.groupByFunction = fieldOptions.getBoolean(GROUP_BY_FUNCTION_KEY, false);
        fieldOptions.getOptions(GROUP_TITLE).setOptionsHelpLocation(hl);
        this.setupNamespaceOptions((Options)fieldOptions);
        this.codeUnitFormat = new BrowserCodeUnitFormat(fieldOptions, true);
        this.codeUnitFormat.addChangeListener(this.codeUnitFormatListener);
    }

    private void setupNamespaceOptions(Options fieldOptions) {
        fieldOptions.registerOption(NAMESPACE_OPTIONS_KEY, OptionType.CUSTOM_TYPE, (Object)new NamespaceWrappedOption(), null, "Adjusts the XREFs Field namespace display", this.namespaceOptionsEditor);
        CustomOption customOption = fieldOptions.getCustomOption(NAMESPACE_OPTIONS_KEY, null);
        fieldOptions.getOptions(NAMESPACE_OPTIONS_KEY).setOptionsHelpLocation(new HelpLocation("CodeBrowserPlugin", "XREFs_Field"));
        if (!(customOption instanceof NamespaceWrappedOption)) {
            throw new AssertException("Someone set an option for XREFs Field.Display Namespace that is not the expected ghidra.app.util.viewer.field.NamespaceWrappedOption type.");
        }
        NamespaceWrappedOption namespaceOption = (NamespaceWrappedOption)customOption;
        this.displayLocalNamespace = namespaceOption.isShowLocalNamespace();
        this.displayNonLocalNamespace = namespaceOption.isShowNonLocalNamespace();
        this.useLocalPrefixOverride = namespaceOption.isUseLocalPrefixOverride();
        this.localPrefixText = namespaceOption.getLocalPrefixText();
    }

    @Override
    public void fieldOptionsChanged(Options options, String optionName, Object oldValue, Object newValue) {
        super.fieldOptionsChanged(options, optionName, oldValue, newValue);
        if (optionName.equals(DELIMITER_KEY)) {
            this.delim = (String)newValue;
            this.model.update();
        } else if (optionName.equals(DISPLAY_BLOCK_NAME_KEY)) {
            this.displayBlockName = (Boolean)newValue;
            this.model.update();
        } else if (optionName.equals(DISPLAY_REFERENCE_TYPE_KEY)) {
            this.displayRefType = (Boolean)newValue;
            this.model.update();
        } else if (optionName.equals(MAX_XREFS_KEY)) {
            this.setMaxSize((Integer)newValue, options);
            this.model.update();
        } else if (optionName.equals(SORT_OPTION_KEY)) {
            this.sortChoice = (SORT_CHOICE)((Object)newValue);
            this.model.update();
        } else if (optionName.equals(NAMESPACE_OPTIONS_KEY)) {
            this.setupNamespaceOptions(options);
            this.model.update();
        } else if (optionName.equals(GROUP_BY_FUNCTION_KEY)) {
            this.groupByFunction = (Boolean)newValue;
            this.model.update();
        }
    }

    private void setMaxSize(int n, Options options) {
        if (n < 1) {
            n = 1;
            options.setInt(MAX_XREFS_KEY, 1);
        }
        this.maxXRefs = n;
    }

    @Override
    public ListingField getField(ProxyObj<?> proxy, int varWidth) {
        Object obj = proxy.getObject();
        if (!this.enabled) {
            return null;
        }
        if (!(obj instanceof CodeUnit)) {
            return null;
        }
        CodeUnit cu = (CodeUnit)obj;
        List<Reference> xrefs = XReferenceUtils.getXReferences(cu, this.maxXRefs + 1);
        int maxOffcuts = Math.max(0, this.maxXRefs - xrefs.size());
        List<Reference> offcuts = XReferenceUtils.getOffcutXReferences(cu, maxOffcuts);
        if (this.sortChoice == SORT_CHOICE.Address) {
            xrefs.sort(null);
            offcuts.sort(null);
        } else {
            xrefs.sort(this.typeComparator);
            offcuts.sort(this.typeComparator);
        }
        if (this.groupByFunction) {
            return this.getFieldByFunction(proxy, varWidth, xrefs, offcuts);
        }
        return this.getFieldByAddress(proxy, varWidth, xrefs, offcuts);
    }

    private ListingField getFieldByFunction(ProxyObj<?> proxy, int varWidth, List<Reference> xrefs, List<Reference> offcuts) {
        int totalXrefs = xrefs.size() + offcuts.size();
        if (totalXrefs == 0) {
            return null;
        }
        boolean tooMany = totalXrefs > this.maxXRefs;
        Object obj = proxy.getObject();
        CodeUnit cu = (CodeUnit)obj;
        Program program = cu.getProgram();
        FontMetrics metrics = this.getMetrics();
        FunctionManager functionManager = program.getFunctionManager();
        ArrayList<Reference> noFunction = new ArrayList<Reference>();
        TreeMap<Function, List<Reference>> xrefsByFunction = new TreeMap<Function, List<Reference>>((f1, f2) -> f1.getEntryPoint().compareTo((Object)f2.getEntryPoint()));
        for (Reference ref : CollectionUtils.asIterable((Iterable[])new Iterable[]{xrefs, offcuts})) {
            Function function = functionManager.getFunctionContaining(ref.getFromAddress());
            if (function == null) {
                noFunction.add(ref);
                continue;
            }
            xrefsByFunction.computeIfAbsent(function, r -> new ArrayList()).add(ref);
        }
        HashSet<Reference> offcutSet = new HashSet<Reference>(offcuts);
        Predicate<Reference> isOffcut = r -> offcutSet.contains(r);
        ListingFieldHighlightFactoryAdapter hlFactory = new ListingFieldHighlightFactoryAdapter(this.hlProvider);
        Function currentFunction = functionManager.getFunctionContaining(cu.getMinAddress());
        List<TextField> functionRows = this.createXrefRowsByFunction(program, currentFunction, xrefsByFunction, isOffcut, varWidth, hlFactory);
        int maxLines = this.maxXRefs;
        int availableLines = maxLines - functionRows.size();
        if (tooMany) {
            availableLines = Math.max(1, availableLines--);
        }
        int dataRow = totalXrefs - noFunction.size();
        TextField noFunctionXrefsField = this.createWrappingXrefRow(program, dataRow, noFunction, currentFunction, isOffcut, availableLines, hlFactory);
        ArrayList<Object> allFields = new ArrayList<Object>();
        allFields.addAll(functionRows);
        if (noFunctionXrefsField != null) {
            allFields.add(noFunctionXrefsField);
        }
        int newStartX = this.startX + varWidth;
        if (tooMany) {
            int lastRow = allFields.size() - 1;
            AttributedString as = new AttributedString(MORE_XREFS_STRING, (Color)ListingColors.XrefColors.DEFAULT, metrics);
            TextFieldElement moreElement = new TextFieldElement(as, lastRow, 0);
            ClippingTextField ctf = new ClippingTextField(newStartX, this.width, (FieldElement)moreElement, (FieldHighlightFactory)hlFactory);
            allFields.add(ctf);
        }
        CompositeVerticalLayoutTextField compositefield = new CompositeVerticalLayoutTextField(allFields, newStartX, this.width, this.maxXRefs, (FieldHighlightFactory)hlFactory);
        XrefListingField listingField = new XrefListingField(this, proxy, (TextField)compositefield, hlFactory);
        return listingField;
    }

    private List<TextField> createXrefRowsByFunction(Program program, Function currentFunction, TreeMap<Function, List<Reference>> xrefsByFunction, Predicate<Reference> isOffcut, int varWidth, FieldHighlightFactory hlFactory) {
        FontMetrics metrics = this.getMetrics();
        AttributedString delimiter = new AttributedString(this.delim, (Color)GThemeDefaults.Colors.FOREGROUND, metrics);
        int row = 0;
        ArrayList<CompositeFieldElement> elements = new ArrayList<CompositeFieldElement>();
        Set<Map.Entry<Function, List<Reference>>> entries = xrefsByFunction.entrySet();
        for (Map.Entry<Function, List<Reference>> entry : entries) {
            List<Reference> refs = entry.getValue();
            Function function = entry.getKey();
            String functionName = function.getName();
            int refCount = refs.size();
            Object sizeText = ": ";
            if (refCount > 1) {
                sizeText = "[" + refs.size() + "]: ";
            }
            String text = functionName + (String)sizeText;
            AttributedString nameString = new AttributedString(text, (Color)ListingColors.XrefColors.DEFAULT, metrics);
            ArrayList<XrefFieldElement> rowElements = new ArrayList<XrefFieldElement>();
            Reference firstRef = refs.get(0);
            XrefAttributedString xrefString = new XrefAttributedString(firstRef, nameString);
            rowElements.add(new XrefFieldElement(xrefString, row, 0));
            int n = Math.min(10, refs.size());
            for (int i = 0; i < n; ++i) {
                boolean isLast = i == n - 1;
                Reference ref = refs.get(i);
                String prefix = this.getMergedPrefix(program, ref, currentFunction, function);
                XrefFieldElement element = this.createFunctionElement(program, prefix, ref, row, isLast ? null : delimiter, isOffcut.test(ref));
                rowElements.add(element);
            }
            elements.add(new CompositeFieldElement(rowElements));
            ++row;
        }
        int newStartX = this.startX + varWidth;
        ArrayList<TextField> textFields = new ArrayList<TextField>();
        for (FieldElement fieldElement : elements) {
            textFields.add((TextField)new ClippingTextField(newStartX, this.width, fieldElement, hlFactory));
        }
        return textFields;
    }

    private TextField createWrappingXrefRow(Program program, int startRow, List<Reference> xrefs, Function currentFunction, Predicate<Reference> isOffcut, int availableLines, FieldHighlightFactory hlFactory) {
        FontMetrics metrics = this.getMetrics();
        AttributedString delimiter = new AttributedString(this.delim, (Color)GThemeDefaults.Colors.FOREGROUND, metrics);
        int row = startRow;
        ArrayList<XrefFieldElement> elements = new ArrayList<XrefFieldElement>();
        for (Reference ref : xrefs) {
            String prefix = this.getPrefix(program, ref, currentFunction, null);
            XrefFieldElement element = this.createReferenceElement(program, prefix, ref, row, delimiter, isOffcut.test(ref));
            elements.add(element);
            ++row;
        }
        if (!elements.isEmpty()) {
            List<FieldElement> fieldElements = this.toFieldElements(elements, false);
            return new FlowLayoutTextField(fieldElements, this.startX, this.width, availableLines, hlFactory);
        }
        return null;
    }

    private ListingField getFieldByAddress(ProxyObj<?> proxy, int varWidth, List<Reference> xrefs, List<Reference> offcuts) {
        int count;
        int totalXrefs = xrefs.size() + offcuts.size();
        if (totalXrefs == 0) {
            return null;
        }
        Object obj = proxy.getObject();
        CodeUnit cu = (CodeUnit)obj;
        Program program = cu.getProgram();
        FontMetrics metrics = this.getMetrics();
        AttributedString delimiter = new AttributedString(this.delim, (Color)GThemeDefaults.Colors.FOREGROUND, metrics);
        HashSet<Reference> offcutSet = new HashSet<Reference>(offcuts);
        Predicate<Reference> isOffcut = r -> offcutSet.contains(r);
        boolean tooMany = totalXrefs > this.maxXRefs;
        ArrayList<XrefFieldElement> elements = new ArrayList<XrefFieldElement>();
        FunctionManager functionManager = program.getFunctionManager();
        Function currentFunction = functionManager.getFunctionContaining(cu.getMinAddress());
        int n = tooMany ? this.maxXRefs : totalXrefs;
        for (count = 0; count < xrefs.size() && count < n; ++count) {
            Reference ref = xrefs.get(count);
            String prefix = this.getPrefix(program, ref, currentFunction);
            elements.add(this.createReferenceElement(program, prefix, ref, count, delimiter, isOffcut.test(ref)));
        }
        for (int i = 0; i < offcuts.size() && count < n; ++i, ++count) {
            Reference ref = offcuts.get(i);
            String prefix = this.getPrefix(program, ref, currentFunction);
            elements.add(this.createReferenceElement(program, prefix, ref, count, delimiter, isOffcut.test(ref)));
        }
        if (!tooMany) {
            XrefFieldElement lastElement = (XrefFieldElement)((Object)elements.get(elements.size() - 1));
            lastElement.hideDelimiter();
        }
        List<FieldElement> fieldElements = this.toFieldElements(elements, tooMany);
        return this.createPackedTextField(proxy, varWidth, fieldElements);
    }

    private XrefListingField createPackedTextField(ProxyObj<?> proxy, int varWidth, List<FieldElement> list) {
        int n = list.size();
        ListingFieldHighlightFactoryAdapter hlFactory = new ListingFieldHighlightFactoryAdapter(this.hlProvider);
        FlowLayoutTextField field = new FlowLayoutTextField(list, this.startX + varWidth, this.width, n, (FieldHighlightFactory)hlFactory);
        XrefListingField listingField = new XrefListingField(this, proxy, (TextField)field, hlFactory);
        return listingField;
    }

    private List<FieldElement> toFieldElements(List<XrefFieldElement> list, boolean showEllipses) {
        ArrayList<XrefFieldElement> fieldElements = new ArrayList<XrefFieldElement>(list);
        if (showEllipses) {
            int lastRow = list.size() - 1;
            AttributedString as = new AttributedString(MORE_XREFS_STRING, (Color)ListingColors.XrefColors.DEFAULT, this.getMetrics());
            fieldElements.add((XrefFieldElement)new TextFieldElement(as, lastRow, 0));
        }
        return fieldElements;
    }

    private XrefFieldElement createFunctionElement(Program program, String prefix, Reference ref, int row, AttributedString delimiter, boolean isOffcut) {
        FontMetrics metrics = this.getMetrics();
        String addressString = ref.getFromAddress().toString(prefix);
        GColor refColor = isOffcut ? ListingColors.XrefColors.OFFCUT : ListingColors.XrefColors.DEFAULT;
        AttributedString addressPart = new AttributedString(addressString, (Color)refColor, metrics);
        if (this.displayRefType) {
            addressPart = this.createRefTypeAttributedString(ref, addressPart);
        }
        XrefAttributedString xrefString = new XrefAttributedString(ref, addressPart, delimiter);
        if (delimiter == null) {
            xrefString.hideDelimiter();
        }
        return new XrefFieldElement(xrefString, row, 0);
    }

    private XrefFieldElement createReferenceElement(Program program, String prefix, Reference ref, int row, AttributedString delimiter, boolean isOffcut) {
        FontMetrics metrics = this.getMetrics();
        String addressString = ref.getFromAddress().toString(prefix);
        GColor refColor = isOffcut ? ListingColors.XrefColors.OFFCUT : ListingColors.XrefColors.DEFAULT;
        AttributedString as = new AttributedString(addressString, (Color)refColor, metrics);
        if (this.displayRefType) {
            as = this.createRefTypeAttributedString(ref, as);
        }
        XrefAttributedString xrefString = new XrefAttributedString(ref, as, delimiter);
        return new XrefFieldElement(xrefString, row, 0);
    }

    protected AttributedString createRefTypeAttributedString(Reference reference, AttributedString referenceString) {
        AttributedString fullReferenceString = referenceString;
        if (reference.getReferenceType().isRead() && reference.getReferenceType().isWrite()) {
            AttributedString typeString = new AttributedString("(R", (Color)ListingColors.XrefColors.READ, this.getMetrics());
            fullReferenceString = new CompositeAttributedString(new AttributedString[]{fullReferenceString, typeString});
            typeString = new AttributedString("W)", (Color)ListingColors.XrefColors.WRITE, this.getMetrics());
            return new CompositeAttributedString(new AttributedString[]{fullReferenceString, typeString});
        }
        GColor displayColor = ListingColors.XrefColors.DEFAULT;
        if (reference.getReferenceType().isRead() || reference.getReferenceType().isIndirect()) {
            displayColor = ListingColors.XrefColors.READ;
        } else if (reference.getReferenceType().isWrite()) {
            displayColor = ListingColors.XrefColors.WRITE;
        } else if (reference.getReferenceType().isData()) {
            displayColor = ListingColors.XrefColors.OTHER;
        }
        AttributedString typeString = new AttributedString(this.getRefTypeDisplayString(reference), (Color)displayColor, this.getMetrics());
        return new CompositeAttributedString(new AttributedString[]{fullReferenceString, typeString});
    }

    protected String getPrefix(Program program, Reference reference, Function currentFunction) {
        Address fromAddress = reference.getFromAddress();
        Function fromFunction = program.getListing().getFunctionContaining(fromAddress);
        return this.getPrefix(program, reference, currentFunction, fromFunction);
    }

    private String getMergedPrefix(Program program, Reference reference, Function currentFunction, Function fromFunction) {
        Object prefix = "";
        Address fromAddress = reference.getFromAddress();
        if (this.displayBlockName) {
            prefix = this.getBlockName(program, fromAddress) + ":";
        }
        if (!this.displayLocalNamespace && !this.displayNonLocalNamespace) {
            return prefix;
        }
        boolean isLocal = Objects.equals(currentFunction, fromFunction);
        if (isLocal && this.useLocalPrefixOverride) {
            return (String)prefix + this.localPrefixText;
        }
        return prefix;
    }

    private String getPrefix(Program program, Reference reference, Function currentFunction, Function fromFunction) {
        Object prefix = "";
        Address fromAddress = reference.getFromAddress();
        if (this.displayBlockName) {
            prefix = this.getBlockName(program, fromAddress) + ":";
        }
        if (!this.displayLocalNamespace && !this.displayNonLocalNamespace) {
            return prefix;
        }
        if (fromFunction == null) {
            return prefix;
        }
        boolean isLocal = fromFunction.equals(currentFunction);
        if (!isLocal) {
            if (this.displayNonLocalNamespace) {
                return (String)prefix + fromFunction.getName() + ":";
            }
            return prefix;
        }
        if (!this.displayLocalNamespace) {
            return prefix;
        }
        if (this.useLocalPrefixOverride) {
            return (String)prefix + this.localPrefixText;
        }
        return (String)prefix + currentFunction.getName() + ":";
    }

    private String getRefTypeDisplayString(Reference reference) {
        RefType refType = reference.getReferenceType();
        if (reference instanceof ThunkReference) {
            return "(T)";
        }
        if (refType instanceof DataRefType) {
            if (refType.isRead() || refType.isIndirect()) {
                return "(R)";
            }
            if (refType.isWrite()) {
                return "(W)";
            }
            if (refType.isData()) {
                return "(*)";
            }
        }
        if (refType.isCall()) {
            return "(c)";
        }
        if (refType.isJump()) {
            return "(j)";
        }
        return "";
    }

    @Override
    public FieldLocation getFieldLocation(ListingField bf, BigInteger index, int fieldNum, ProgramLocation loc) {
        if (!(loc instanceof XRefFieldLocation)) {
            return null;
        }
        XRefFieldLocation xRefLoc = (XRefFieldLocation)loc;
        int xrefPos = xRefLoc.getCharOffset();
        int xrefIndex = xRefLoc.getIndex();
        if (!this.hasSamePath(bf, loc)) {
            return null;
        }
        return this.createFieldLocation(xrefPos, xrefIndex, (ListingTextField)bf, index, fieldNum);
    }

    protected FieldLocation createFieldLocation(int xrefPos, int xrefIndex, ListingTextField field, BigInteger index, int fieldNum) {
        RowColLocation loc = field.dataToScreenLocation(xrefIndex, xrefPos);
        return new FieldLocation(index, fieldNum, loc.row(), loc.col());
    }

    @Override
    public ProgramLocation getProgramLocation(int row, int col, ListingField listingField) {
        FieldElement baseElement;
        Object obj = listingField.getProxy().getObject();
        if (obj == null || !(obj instanceof CodeUnit)) {
            return null;
        }
        if (!(listingField instanceof XrefListingField)) {
            return null;
        }
        CodeUnit cu = (CodeUnit)obj;
        int[] cpath = null;
        if (cu instanceof Data) {
            cpath = ((Data)cu).getComponentPath();
        }
        XrefListingField field = (XrefListingField)listingField;
        FieldElement element = field.getFieldElement(row, col);
        RowColLocation loc = field.screenToDataLocation(row, col);
        if (element instanceof XrefFieldElement) {
            XrefFieldElement xrefElement = (XrefFieldElement)element;
            return this.getXRefLocation(xrefElement, cu, cpath, loc, row);
        }
        if (element instanceof StrutFieldElement && (baseElement = ((StrutFieldElement)element).getBaseType()) instanceof XrefFieldElement) {
            XrefFieldElement xrefElement = (XrefFieldElement)baseElement;
            return this.getXRefLocation(xrefElement, cu, cpath, loc, row);
        }
        String text = element.getText();
        if (MORE_XREFS_STRING.equals(text)) {
            return new XRefFieldLocation(cu.getProgram(), cu.getMinAddress(), cpath, null, row, loc.col());
        }
        return null;
    }

    private XRefFieldLocation getXRefLocation(XrefFieldElement xrefElement, CodeUnit cu, int[] cpath, RowColLocation loc, int row) {
        Reference xref = xrefElement.getXref();
        Address refAddr = xref.getFromAddress();
        return new XRefFieldLocation(cu.getProgram(), cu.getMinAddress(), cpath, refAddr, row, loc.col());
    }

    protected String getBlockName(Program pgm, Address addr) {
        Memory mem = pgm.getMemory();
        MemoryBlock block = mem.getBlock(addr);
        if (block != null) {
            return block.getName();
        }
        return "";
    }

    protected Address getXRefLocation(Object obj) {
        if (obj == null || !(obj instanceof CodeUnit)) {
            return null;
        }
        return ((CodeUnit)obj).getMinAddress();
    }

    protected Program getProgram(Object obj) {
        if (obj == null || !(obj instanceof CodeUnit)) {
            return null;
        }
        return ((CodeUnit)obj).getProgram();
    }

    @Override
    public boolean acceptsType(int category, Class<?> proxyObjectClass) {
        if (!CodeUnit.class.isAssignableFrom(proxyObjectClass)) {
            return false;
        }
        return category == 4 || category == 5;
    }

    @Override
    public FieldFactory newInstance(FieldFormatModel formatModel, ListingHighlightProvider provider, ToolOptions toolOptions, ToolOptions fieldOptions) {
        return new XRefFieldFactory(formatModel, provider, (Options)toolOptions, fieldOptions);
    }

    public static enum SORT_CHOICE {
        Address,
        Type;

    }

    private class XrefListingField
    extends ListingTextField {
        XrefListingField(XRefFieldFactory factory, ProxyObj<?> proxy, TextField field, ListingFieldHighlightFactoryAdapter hlFactory) {
            super(factory, proxy, field, hlFactory);
        }
    }

    private class XrefAttributedString
    extends CompositeAttributedString {
        private AttributedString content;
        private AttributedString delimiter;
        private Reference xref;

        public XrefAttributedString(Reference xref, AttributedString content) {
            super(new AttributedString[]{content});
            this.content = content;
            this.xref = xref;
        }

        public XrefAttributedString(Reference xref, AttributedString content, AttributedString delimiter) {
            super(new AttributedString[]{content, delimiter});
            this.content = content;
            this.delimiter = delimiter;
            this.xref = xref;
        }

        void hideDelimiter() {
            AttributedString spaces;
            AttributedString source = this.delimiter;
            if (source == null) {
                source = this.content;
            }
            int length = this.delimiter == null ? 1 : this.delimiter.length();
            char[] charSpaces = new char[length];
            Arrays.fill(charSpaces, ' ');
            this.attributedStrings[this.attributedStrings.length - 1] = spaces = new AttributedString(new String(charSpaces), source.getColor(0), source.getFontMetrics(0));
        }

        Reference getXref() {
            return this.xref;
        }
    }

    private class XrefFieldElement
    extends TextFieldElement {
        private XrefAttributedString xrefString;

        public XrefFieldElement(XrefAttributedString xrefString, int row, int column) {
            super((AttributedString)xrefString, row, column);
            this.xrefString = xrefString;
        }

        void hideDelimiter() {
            this.xrefString.hideDelimiter();
        }

        Reference getXref() {
            return this.xrefString.getXref();
        }
    }
}

