/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.swift.types;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.swift.types.TargetTypeContextDescriptor;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public final class TargetStructDescriptor
extends TargetTypeContextDescriptor {
    private int numFields;
    private int fieldOffsetVectorOffset;

    public TargetStructDescriptor(BinaryReader reader) throws IOException {
        super(reader);
        this.numFields = reader.readNextInt();
        this.fieldOffsetVectorOffset = reader.readNextInt();
    }

    public int getNumFields() {
        return this.numFields;
    }

    public int getFieldOffsetVectorOffset() {
        return this.fieldOffsetVectorOffset;
    }

    @Override
    public String getStructureName() {
        return TargetStructDescriptor.class.getSimpleName();
    }

    @Override
    public String getDescription() {
        return "struct descriptor";
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(this.getStructureName(), 0);
        struct.add(super.toDataType(), super.getStructureName(), "");
        struct.add(DWORD, "NumFields", "The number of stored properties in the struct. If there is a field offset vector, this is its length.");
        struct.add(DWORD, "FieldOffsetVectorOffset", "The offset of the field offset vector for this struct's stored properties in its metadata, if any. 0 means there is no field offset vector.");
        struct.setCategoryPath(new CategoryPath("/Swift"));
        return struct;
    }
}

