/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.swift.types;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.swift.SwiftStructure;
import ghidra.app.util.bin.format.swift.SwiftUtils;
import ghidra.app.util.bin.format.swift.types.FieldRecord;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class FieldDescriptor
implements SwiftStructure {
    public static final int SIZE = 16;
    private String mangledTypeName;
    private int superclass;
    private int kind;
    private int fieldRecordSize;
    private int numFields;
    private List<FieldRecord> fieldRecords = new ArrayList<FieldRecord>();

    public FieldDescriptor(BinaryReader reader) throws IOException {
        this.mangledTypeName = reader.readNext(SwiftUtils::relativeString);
        this.superclass = reader.readNextInt();
        this.kind = reader.readNextUnsignedShort();
        this.fieldRecordSize = reader.readNextUnsignedShort();
        this.numFields = reader.readNextInt();
        for (int i = 0; i < this.numFields; ++i) {
            this.fieldRecords.add(new FieldRecord(reader));
        }
    }

    public String getMangledTypeName() {
        return this.mangledTypeName;
    }

    public int getSuperclass() {
        return this.superclass;
    }

    public int getKind() {
        return this.kind;
    }

    public int getFieldRecordSize() {
        return this.fieldRecordSize;
    }

    public int getNumFields() {
        return this.numFields;
    }

    public List<FieldRecord> getFieldRecords() {
        return this.fieldRecords;
    }

    @Override
    public String getStructureName() {
        return FieldDescriptor.class.getSimpleName();
    }

    @Override
    public String getDescription() {
        return "field descriptor";
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(this.getStructureName(), 0);
        struct.add((DataType)SwiftUtils.PTR_STRING, "MangledTypeName", "");
        struct.add((DataType)SwiftUtils.PTR_RELATIVE, "Superclass", "");
        struct.add(WORD, "Kind", "");
        struct.add(WORD, "FieldRecordSize", "");
        struct.add(DWORD, "NumFields", "");
        struct.setCategoryPath(new CategoryPath("/Swift"));
        return struct;
    }
}

