/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.dyld;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheSlideFixup;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheSlideInfoCommon;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DyldCacheSlideInfo1
extends DyldCacheSlideInfoCommon {
    private int tocOffset;
    private int tocCount;
    private int entriesOffset;
    private int entriesCount;
    private int entriesSize;
    private short[] toc;
    private byte[][] bits;

    public DyldCacheSlideInfo1(BinaryReader reader, long mappingAddress, long mappingSize, long mappingFileOffset) throws IOException {
        super(reader, mappingAddress, mappingSize, mappingFileOffset);
        long startIndex = reader.getPointerIndex() - 4L;
        this.tocOffset = reader.readNextInt();
        this.tocCount = reader.readNextInt();
        this.entriesOffset = reader.readNextInt();
        this.entriesCount = reader.readNextInt();
        this.entriesSize = reader.readNextInt();
        reader.setPointerIndex(startIndex + (long)this.tocOffset);
        this.toc = reader.readNextShortArray(this.tocCount);
        reader.setPointerIndex(startIndex + (long)this.entriesOffset);
        this.bits = new byte[this.entriesCount][];
        for (int i = 0; i < this.entriesCount; ++i) {
            this.bits[i] = reader.readNextByteArray(this.entriesSize);
        }
    }

    public int getTocOffset() {
        return this.tocOffset;
    }

    public int getTocCount() {
        return this.tocCount;
    }

    public int getEntriesOffset() {
        return this.entriesOffset;
    }

    public int getEntriesCount() {
        return this.entriesCount;
    }

    public int getEntriesSize() {
        return this.entriesSize;
    }

    public short[] getToc() {
        return this.toc;
    }

    public byte[][] getEntries() {
        return this.bits;
    }

    @Override
    public List<DyldCacheSlideFixup> getSlideFixups(BinaryReader reader, int pointerSize, MessageLog log, TaskMonitor monitor) throws IOException, CancelledException {
        ArrayList<DyldCacheSlideFixup> fixups = new ArrayList<DyldCacheSlideFixup>(1024);
        monitor.initialize((long)this.tocCount, "Getting DYLD Cache V1 slide fixups...");
        for (int tocIndex = 0; tocIndex < this.tocCount; ++tocIndex) {
            monitor.increment();
            int entryIndex = Short.toUnsignedInt(this.toc[tocIndex]);
            if (entryIndex >= this.entriesCount) {
                log.appendMsg("Entry too big! [" + tocIndex + "] " + entryIndex + " " + this.entriesCount + " " + this.bits.length);
                continue;
            }
            byte[] entry = this.bits[entryIndex];
            long segmentOffset = 4096L * (long)tocIndex;
            for (int pageEntriesIndex = 0; pageEntriesIndex < 128; ++pageEntriesIndex) {
                monitor.checkCancelled();
                long prtEntryBitmap = Byte.toUnsignedLong(entry[pageEntriesIndex]);
                if (prtEntryBitmap == 0L) continue;
                for (int bitMapIndex = 0; bitMapIndex < 8; ++bitMapIndex) {
                    if ((prtEntryBitmap & 1L << bitMapIndex) == 0L) continue;
                    long pageOffset = pageEntriesIndex * 8 * 4 + bitMapIndex * 4;
                    long value = reader.readLong(segmentOffset + pageOffset);
                    fixups.add(new DyldCacheSlideFixup(segmentOffset + pageOffset, value, 8));
                }
            }
        }
        return fixups;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("dyld_cache_slide_info", 0);
        struct.add(DWORD, "version", "");
        struct.add(DWORD, "toc_offset", "");
        struct.add(DWORD, "toc_count", "");
        struct.add(DWORD, "entries_offset", "");
        struct.add(DWORD, "entries_count", "");
        struct.add(DWORD, "entries_size", "");
        if (this.tocOffset > 24) {
            struct.add((DataType)new ArrayDataType(BYTE, this.tocOffset - 24, -1), "align", "");
        }
        struct.add((DataType)new ArrayDataType(WORD, this.tocCount, -1), "toc", "");
        if (this.entriesOffset > this.tocOffset + this.tocCount * 2) {
            struct.add((DataType)new ArrayDataType(BYTE, this.entriesOffset - (this.tocOffset + this.tocCount * 2), -1), "align", "");
        }
        struct.add((DataType)new ArrayDataType((DataType)new ArrayDataType(BYTE, this.entriesSize, -1), this.entriesCount, -1), "entries", "");
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }
}

