/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.dyld;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.macho.dyld.DyldArchitecture;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheAccelerateInfo;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheImage;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheImageInfo;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheImageTextInfo;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheLocalSymbolsInfo;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheMappingAndSlideInfo;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheMappingInfo;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheSlideInfoCommon;
import ghidra.app.util.bin.format.macho.dyld.DyldSubcacheEntry;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.Pointer64DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.NumericUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DyldCacheHeader
implements StructConverter {
    private byte[] magic;
    private int mappingOffset;
    private int mappingCount;
    private int imagesOffsetOld;
    private int imagesCountOld;
    private long dyldBaseAddress;
    private long codeSignatureOffset;
    private long codeSignatureSize;
    private long slideInfoOffset;
    private long slideInfoSize;
    private long localSymbolsOffset;
    private long localSymbolsSize;
    private byte[] uuid;
    private long cacheType;
    private int branchPoolsOffset;
    private int branchPoolsCount;
    private long accelerateInfoAddr_dyldInCacheMH;
    private long accelerateInfoSize_dyldInCacheEntry;
    private long imagesTextOffset;
    private long imagesTextCount;
    private long patchInfoAddr;
    private long patchInfoSize;
    private long otherImageGroupAddrUnused;
    private long otherImageGroupSizeUnused;
    private long progClosuresAddr;
    private long progClosuresSize;
    private long progClosuresTrieAddr;
    private long progClosuresTrieSize;
    private int platform;
    private int dyld_info;
    private int formatVersion;
    private boolean dylibsExpectedOnDisk;
    private boolean simulator;
    private boolean locallyBuiltCache;
    private boolean builtFromChainedFixups;
    private int padding;
    private long sharedRegionStart;
    private long sharedRegionSize;
    private long maxSlide;
    private long dylibsImageArrayAddr;
    private long dylibsImageArraySize;
    private long dylibsTrieAddr;
    private long dylibsTrieSize;
    private long otherImageArrayAddr;
    private long otherImageArraySize;
    private long otherTrieAddr;
    private long otherTrieSize;
    private int mappingWithSlideOffset;
    private int mappingWithSlideCount;
    private long dylibsPBLStateArrayAddrUnused;
    private long dylibsPBLSetAddr;
    private long programsPBLSetPoolAddr;
    private long programsPBLSetPoolSize;
    private long programTrieAddr;
    private int programTrieSize;
    private int osVersion;
    private int altPlatform;
    private int altOsVersion;
    private long swiftOptsOffset;
    private long swiftOptsSize;
    private int subCacheArrayOffset;
    private Integer subCacheArrayCount;
    private byte[] symbolFileUUID;
    private long rosettaReadOnlyAddr;
    private long rosettaReadOnlySize;
    private long rosettaReadWriteAddr;
    private long rosettaReadWriteSize;
    private int imagesOffset;
    private int imagesCount;
    private Integer cacheSubType;
    private long objcOptsOffset;
    private long objcOptsSize;
    private long cacheAtlasOffset;
    private long cacheAtlasSize;
    private long dynamicDataOffset;
    private long dynamicDataMaxSize;
    private int headerSize;
    private BinaryReader reader;
    private long baseAddress;
    private List<DyldCacheMappingInfo> mappingInfoList;
    private List<DyldCacheImageInfo> imageInfoList;
    private List<DyldCacheSlideInfoCommon> slideInfoList;
    private DyldCacheLocalSymbolsInfo localSymbolsInfo;
    private List<Long> branchPoolList;
    private DyldCacheAccelerateInfo accelerateInfo;
    private List<DyldCacheImageTextInfo> imageTextInfoList;
    private List<DyldSubcacheEntry> subcacheEntryList;
    private DyldArchitecture architecture;
    private List<DyldCacheMappingAndSlideInfo> cacheMappingAndSlideInfoList;
    private MemoryBlock fileBlock;

    public DyldCacheHeader(BinaryReader reader) throws IOException {
        this.reader = reader;
        long startIndex = reader.getPointerIndex();
        this.magic = reader.readNextByteArray(16);
        this.mappingOffset = reader.readNextInt();
        this.mappingCount = reader.readNextInt();
        this.imagesOffsetOld = reader.readNextInt();
        this.imagesCountOld = reader.readNextInt();
        this.dyldBaseAddress = reader.readNextLong();
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.codeSignatureOffset = reader.readNextLong();
            this.codeSignatureSize = reader.readNextLong();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.slideInfoOffset = reader.readNextLong();
            this.slideInfoSize = reader.readNextLong();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.localSymbolsOffset = reader.readNextLong();
            this.localSymbolsSize = reader.readNextLong();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.uuid = reader.readNextByteArray(16);
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.cacheType = reader.readNextLong();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.branchPoolsOffset = reader.readNextInt();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.branchPoolsCount = reader.readNextInt();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.accelerateInfoAddr_dyldInCacheMH = reader.readNextLong();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.accelerateInfoSize_dyldInCacheEntry = reader.readNextLong();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.imagesTextOffset = reader.readNextLong();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.imagesTextCount = reader.readNextLong();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.patchInfoAddr = reader.readNextLong();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.patchInfoSize = reader.readNextLong();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.otherImageGroupAddrUnused = reader.readNextLong();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.otherImageGroupSizeUnused = reader.readNextLong();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.progClosuresAddr = reader.readNextLong();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.progClosuresSize = reader.readNextLong();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.progClosuresTrieAddr = reader.readNextLong();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.progClosuresTrieSize = reader.readNextLong();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.platform = reader.readNextInt();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.dyld_info = reader.readNextInt();
            this.formatVersion = this.dyld_info & 0xFF;
            this.dylibsExpectedOnDisk = (this.dyld_info >>> 8 & 1) == 1;
            this.simulator = (this.dyld_info >>> 9 & 1) == 1;
            this.locallyBuiltCache = (this.dyld_info >> 10 & 1) == 1;
            this.builtFromChainedFixups = (this.dyld_info >> 11 & 1) == 1;
            this.padding = this.dyld_info >> 12 & 0xFFFFF;
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.sharedRegionStart = reader.readNextLong();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.sharedRegionSize = reader.readNextLong();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.maxSlide = reader.readNextLong();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.dylibsImageArrayAddr = reader.readNextLong();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.dylibsImageArraySize = reader.readNextLong();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.dylibsTrieAddr = reader.readNextLong();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.dylibsTrieSize = reader.readNextLong();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.otherImageArrayAddr = reader.readNextLong();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.otherImageArraySize = reader.readNextLong();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.otherTrieAddr = reader.readNextLong();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.otherTrieSize = reader.readNextLong();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.mappingWithSlideOffset = reader.readNextInt();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.mappingWithSlideCount = reader.readNextInt();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.dylibsPBLStateArrayAddrUnused = reader.readNextLong();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.dylibsPBLSetAddr = reader.readNextLong();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.programsPBLSetPoolAddr = reader.readNextLong();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.programsPBLSetPoolSize = reader.readNextLong();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.programTrieAddr = reader.readNextLong();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.programTrieSize = reader.readNextInt();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.osVersion = reader.readNextInt();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.altPlatform = reader.readNextInt();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.altOsVersion = reader.readNextInt();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.swiftOptsOffset = reader.readNextLong();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.swiftOptsSize = reader.readNextLong();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.subCacheArrayOffset = reader.readNextInt();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.subCacheArrayCount = reader.readNextInt();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.symbolFileUUID = null;
            byte[] temp = reader.readNextByteArray(16);
            for (int i = 0; i < temp.length; ++i) {
                if (temp[i] == 0) continue;
                this.symbolFileUUID = temp;
                break;
            }
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.rosettaReadOnlyAddr = reader.readNextLong();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.rosettaReadOnlySize = reader.readNextLong();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.rosettaReadWriteAddr = reader.readNextLong();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.rosettaReadWriteSize = reader.readNextLong();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.imagesOffset = reader.readNextInt();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.imagesCount = reader.readNextInt();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.cacheSubType = reader.readNextInt();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.padding = reader.readNextInt();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.objcOptsOffset = reader.readNextLong();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.objcOptsSize = reader.readNextLong();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.cacheAtlasOffset = reader.readNextLong();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.cacheAtlasSize = reader.readNextLong();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.dynamicDataOffset = reader.readNextLong();
        }
        if (reader.getPointerIndex() < (long)this.mappingOffset) {
            this.dynamicDataMaxSize = reader.readNextLong();
        }
        this.headerSize = (int)(reader.getPointerIndex() - startIndex);
        this.baseAddress = reader.readLong(this.mappingOffset);
        this.architecture = DyldArchitecture.getArchitecture(new String(this.magic).trim());
        this.mappingInfoList = new ArrayList<DyldCacheMappingInfo>(this.mappingCount);
        this.cacheMappingAndSlideInfoList = new ArrayList<DyldCacheMappingAndSlideInfo>(this.mappingWithSlideCount);
        this.slideInfoList = new ArrayList<DyldCacheSlideInfoCommon>();
        this.imageInfoList = new ArrayList<DyldCacheImageInfo>(this.imagesCountOld);
        this.branchPoolList = new ArrayList<Long>(this.branchPoolsCount);
        this.imageTextInfoList = new ArrayList<DyldCacheImageTextInfo>();
        this.subcacheEntryList = new ArrayList<DyldSubcacheEntry>();
    }

    public void parseFromFile(boolean parseLocalSymbols, MessageLog log, TaskMonitor monitor) throws CancelledException {
        this.parseMappingInfo(log, monitor);
        this.parseImageInfo(log, monitor);
        this.parseLocalSymbolsInfo(parseLocalSymbols, log, monitor);
        this.parseBranchPools(log, monitor);
        this.parseImageTextInfo(log, monitor);
        this.parseSubcaches(log, monitor);
        this.parseCacheMappingSlideInfo(log, monitor);
        this.parseSlideInfos(log, monitor);
    }

    private void parseSlideInfos(MessageLog log, TaskMonitor monitor) throws CancelledException {
        if (!this.hasSlideInfo()) {
            return;
        }
        if (this.slideInfoOffset != 0L && this.mappingInfoList.size() > 1) {
            DyldCacheMappingInfo mappingInfo = this.mappingInfoList.get(1);
            DyldCacheSlideInfoCommon info = DyldCacheSlideInfoCommon.parseSlideInfo(this.reader, this.slideInfoOffset, mappingInfo.getAddress(), mappingInfo.getSize(), mappingInfo.getFileOffset(), log, monitor);
            if (info != null) {
                this.slideInfoList.add(info);
            }
        } else if (this.cacheMappingAndSlideInfoList.size() > 0) {
            for (DyldCacheMappingAndSlideInfo info : this.cacheMappingAndSlideInfoList) {
                if (info.getSlideInfoFileOffset() == 0L) continue;
                DyldCacheSlideInfoCommon slideInfo = DyldCacheSlideInfoCommon.parseSlideInfo(this.reader, info.getSlideInfoFileOffset(), info.getAddress(), info.getSize(), info.getFileOffset(), log, monitor);
                this.slideInfoList.add(slideInfo);
            }
        }
    }

    private void parseCacheMappingSlideInfo(MessageLog log, TaskMonitor monitor) throws CancelledException {
        monitor.setMessage("Parsing DYLD cache mapping and slide info...");
        monitor.initialize((long)this.mappingWithSlideCount);
        try {
            if (this.mappingWithSlideCount <= 0) {
                return;
            }
            this.reader.setPointerIndex(this.mappingWithSlideOffset);
            for (int i = 0; i < this.mappingWithSlideCount; ++i) {
                this.cacheMappingAndSlideInfoList.add(new DyldCacheMappingAndSlideInfo(this.reader));
                monitor.checkCancelled();
                monitor.incrementProgress(1L);
            }
        }
        catch (IOException e) {
            log.appendMsg(DyldCacheHeader.class.getSimpleName(), "Failed to parse dyld_cache_mapping_info.");
        }
    }

    public void parseFromMemory(Program program, AddressSpace space, MessageLog log, TaskMonitor monitor) throws CancelledException {
        this.parseAcceleratorInfo(program, space, log, monitor);
    }

    public void markup(Program program, boolean markupLocalSymbols, AddressSpace space, TaskMonitor monitor, MessageLog log) throws CancelledException {
        this.markupHeader(program, space, monitor, log);
        this.markupMappingInfo(program, space, monitor, log);
        this.markupImageInfo(program, space, monitor, log);
        this.markupLocalSymbolsInfo(markupLocalSymbols, program, space, monitor, log);
        this.markupCodeSignature(program, space, monitor, log);
        this.markupSlideInfo(program, space, monitor, log);
        this.markupBranchPools(program, space, monitor, log);
        this.markupAcceleratorInfo(program, space, monitor, log);
        this.markupImageTextInfo(program, space, monitor, log);
        this.markupSubcacheEntries(program, space, monitor, log);
        this.markupCacheMappingSlideInfo(program, space, log, monitor);
    }

    public long getBaseAddress() {
        return this.baseAddress;
    }

    public byte[] getMagic() {
        return this.magic;
    }

    public String getUUID() {
        return NumericUtilities.convertBytesToString((byte[])this.uuid);
    }

    public Long getEntryPoint() {
        if (!this.hasAccelerateInfo()) {
            return this.accelerateInfoSize_dyldInCacheEntry;
        }
        return null;
    }

    public List<DyldCacheMappingInfo> getMappingInfos() {
        return this.mappingInfoList;
    }

    public int getImagesOffset() {
        if (this.imagesOffset != 0) {
            return this.imagesOffset;
        }
        return this.imagesOffsetOld;
    }

    public int getImagesCount() {
        if (this.imagesOffset != 0) {
            return this.imagesCount;
        }
        return this.imagesCountOld;
    }

    public List<DyldCacheImage> getMappedImages() {
        ArrayList<DyldCacheImage> images = new ArrayList<DyldCacheImage>();
        block0: for (DyldCacheImage dyldCacheImage : this.imageInfoList) {
            for (DyldCacheMappingInfo mappingInfo : this.mappingInfoList) {
                if (!mappingInfo.contains(dyldCacheImage.getAddress())) continue;
                images.add(dyldCacheImage);
                continue block0;
            }
        }
        return images;
    }

    public List<DyldSubcacheEntry> getSubcacheEntries() {
        return this.subcacheEntryList;
    }

    public String getSymbolFileUUID() {
        return NumericUtilities.convertBytesToString((byte[])this.symbolFileUUID);
    }

    public List<DyldCacheMappingAndSlideInfo> getCacheMappingAndSlideInfos() {
        return this.cacheMappingAndSlideInfoList;
    }

    public DyldCacheLocalSymbolsInfo getLocalSymbolsInfo() {
        return this.localSymbolsInfo;
    }

    public List<DyldCacheSlideInfoCommon> getSlideInfos() {
        return this.slideInfoList;
    }

    public List<Long> getBranchPoolAddresses() {
        return this.branchPoolList;
    }

    public DyldArchitecture getArchitecture() {
        return this.architecture;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("dyld_cache_header", 0);
        this.addHeaderField(struct, (DataType)new ArrayDataType(ASCII, 16, 1), "magic", "e.g. \"dyld_v0    i386\"");
        this.addHeaderField(struct, DWORD, "mappingOffset", "file offset to first dyld_cache_mapping_info");
        this.addHeaderField(struct, DWORD, "mappingCount", "number of dyld_cache_mapping_info entries");
        this.addHeaderField(struct, DWORD, "imagesOffsetOld", "UNUSED: moved to imagesOffset to prevent older dsc_extarctors from crashing");
        this.addHeaderField(struct, DWORD, "imagesCountOld", "UNUSED: moved to imagesCount to prevent older dsc_extarctors from crashing");
        this.addHeaderField(struct, QWORD, "dyldBaseAddress", "base address of dyld when cache was built");
        this.addHeaderField(struct, QWORD, "codeSignatureOffset", "file offset of code signature blob");
        this.addHeaderField(struct, QWORD, "codeSignatureSize", "size of code signature blob (zero means to end of file)");
        this.addHeaderField(struct, QWORD, "slideInfoOffset", "file offset of kernel slid info");
        this.addHeaderField(struct, QWORD, "slideInfoSize", "size of kernel slid info");
        this.addHeaderField(struct, QWORD, "localSymbolsOffset", "file offset of where local symbols are stored");
        this.addHeaderField(struct, QWORD, "localSymbolsSize", "size of local symbols information");
        this.addHeaderField(struct, (DataType)new ArrayDataType(BYTE, 16, 1), "uuid", "unique value for each shared cache file");
        this.addHeaderField(struct, QWORD, "cacheType", "0 for development, 1 for production, 2 for multi-cache");
        this.addHeaderField(struct, DWORD, "branchPoolsOffset", "file offset to table of uint64_t pool addresses");
        this.addHeaderField(struct, DWORD, "branchPoolsCount", "number of uint64_t entries");
        if (this.hasAccelerateInfo()) {
            this.addHeaderField(struct, QWORD, "accelerateInfoAddr", "(unslid) address of optimization info");
            this.addHeaderField(struct, QWORD, "accelerateInfoSize", "size of optimization info");
        } else {
            this.addHeaderField(struct, QWORD, "dyldInCacheMH", "(unslid) address of mach_header of dyld in cache");
            this.addHeaderField(struct, QWORD, "dyldInCacheEntry", "(unslid) address of entry point (_dyld_start) of dyld in cache");
        }
        this.addHeaderField(struct, QWORD, "imagesTextOffset", "file offset to first dyld_cache_image_text_info");
        this.addHeaderField(struct, QWORD, "imagesTextCount", "number of dyld_cache_image_text_info entries");
        this.addHeaderField(struct, QWORD, "patchInfoAddr", "(unslid) address of dyld_cache_patch_info");
        this.addHeaderField(struct, QWORD, "patchInfoSize", "Size of all of the patch information pointed to via the dyld_cache_patch_info");
        this.addHeaderField(struct, QWORD, "otherImageGroupAddrUnused", "unused");
        this.addHeaderField(struct, QWORD, "otherImageGroupSizeUnused", "unused");
        this.addHeaderField(struct, QWORD, "progClosuresAddr", "(unslid) address of list of program launch closures");
        this.addHeaderField(struct, QWORD, "progClosuresSize", "size of list of program launch closures");
        this.addHeaderField(struct, QWORD, "progClosuresTrieAddr", "(unslid) address of trie of indexes into program launch closures");
        this.addHeaderField(struct, QWORD, "progClosuresTrieSize", "size of trie of indexes into program launch closures");
        this.addHeaderField(struct, DWORD, "platform", "platform number (macOS=1, etc)");
        this.addHeaderField(struct, DWORD, "dyld_info", "");
        this.addHeaderField(struct, QWORD, "sharedRegionStart", "base load address of cache if not slid");
        this.addHeaderField(struct, QWORD, "sharedRegionSize", "overall size of region cache can be mapped into");
        this.addHeaderField(struct, QWORD, "maxSlide", "runtime slide of cache can be between zero and this value");
        this.addHeaderField(struct, QWORD, "dylibsImageArrayAddr", "(unslid) address of ImageArray for dylibs in this cache");
        this.addHeaderField(struct, QWORD, "dylibsImageArraySize", "size of ImageArray for dylibs in this cache");
        this.addHeaderField(struct, QWORD, "dylibsTrieAddr", "(unslid) address of trie of indexes of all cached dylibs");
        this.addHeaderField(struct, QWORD, "dylibsTrieSize", "size of trie of cached dylib paths");
        this.addHeaderField(struct, QWORD, "otherImageArrayAddr", "(unslid) address of ImageArray for dylibs and bundles with dlopen closures");
        this.addHeaderField(struct, QWORD, "otherImageArraySize", "size of ImageArray for dylibs and bundles with dlopen closures");
        this.addHeaderField(struct, QWORD, "otherTrieAddr", "(unslid) address of trie of indexes of all dylibs and bundles with dlopen closures");
        this.addHeaderField(struct, QWORD, "otherTrieSize", "size of trie of dylibs and bundles with dlopen closures");
        this.addHeaderField(struct, DWORD, "mappingWithSlideOffset", "file offset to first dyld_cache_mapping_and_slide_info");
        this.addHeaderField(struct, DWORD, "mappingWithSlideCount", "number of dyld_cache_mapping_and_slide_info entries");
        this.addHeaderField(struct, QWORD, "dylibsPBLStateArrayAddrUnused", "unused");
        this.addHeaderField(struct, QWORD, "dylibsPBLSetAddr", "(unslid) address of PrebuiltLoaderSet of all cached dylibs");
        this.addHeaderField(struct, QWORD, "programsPBLSetPoolAddr", "(unslid) address of pool of PrebuiltLoaderSet for each program ");
        this.addHeaderField(struct, QWORD, "programsPBLSetPoolSize", "size of pool of PrebuiltLoaderSet for each program");
        this.addHeaderField(struct, QWORD, "programTrieAddr", "(unslid) address of trie mapping program path to PrebuiltLoaderSet");
        this.addHeaderField(struct, DWORD, "programTrieSize", "");
        this.addHeaderField(struct, DWORD, "osVersion", "OS Version of dylibs in this cache for the main platform");
        this.addHeaderField(struct, DWORD, "altPlatform", "e.g. iOSMac on macOS");
        this.addHeaderField(struct, DWORD, "altOsVersion", "e.g. 14.0 for iOSMac");
        this.addHeaderField(struct, QWORD, "swiftOptsOffset", "file offset to Swift optimizations header");
        this.addHeaderField(struct, QWORD, "swiftOptsOffset", "size of Swift optimizations header");
        this.addHeaderField(struct, DWORD, "subCacheArrayOffset", "file offset to first dyld_subcache_entry");
        this.addHeaderField(struct, DWORD, "subCacheArrayCount", "number of subcache entries");
        this.addHeaderField(struct, (DataType)new ArrayDataType(BYTE, 16, 1), "symbolFileUUID", "unique value for the shared cache file containing unmapped local symbols");
        this.addHeaderField(struct, QWORD, "rosettaReadOnlyAddr", "(unslid) address of the start of where Rosetta can add read-only/executable data");
        this.addHeaderField(struct, QWORD, "rosettaReadOnlySize", "maximum size of the Rosetta read-only/executable region");
        this.addHeaderField(struct, QWORD, "rosettaReadWriteAddr", "(unslid) address of the start of where Rosetta can add read-write data");
        this.addHeaderField(struct, QWORD, "rosettaReadWriteSize", "maximum size of the Rosetta read-write region");
        this.addHeaderField(struct, DWORD, "imagesOffset", "file offset to first dyld_cache_image_info");
        this.addHeaderField(struct, DWORD, "imagesCount", "number of dyld_cache_image_info entries");
        this.addHeaderField(struct, DWORD, "cacheSubType", "0 for development, 1 for production, when cacheType is multi-cache(2)");
        this.addHeaderField(struct, DWORD, "padding", "");
        this.addHeaderField(struct, QWORD, "objcOptsOffset", "VM offset from cache_header* to ObjC optimizations header");
        this.addHeaderField(struct, QWORD, "objcOptsSize", "size of ObjC optimizations header");
        this.addHeaderField(struct, QWORD, "cacheAtlasOffset", "VM offset from cache_header* to embedded cache atlas for process introspection");
        this.addHeaderField(struct, QWORD, "cacheAtlasSize", "size of embedded cache atlas");
        this.addHeaderField(struct, QWORD, "dynamicDataOffset", "VM offset from cache_header* to the location of dyld_cache_dynamic_data_header");
        this.addHeaderField(struct, QWORD, "dynamicDataMaxSize", "maximum size of space reserved from dynamic data");
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }

    private void addHeaderField(StructureDataType struct, DataType dt, String fieldname, String comment) {
        if (this.headerSize > struct.getLength()) {
            struct.add(dt, fieldname, comment);
        }
    }

    private void parseMappingInfo(MessageLog log, TaskMonitor monitor) throws CancelledException {
        monitor.setMessage("Parsing DYLD mapping info...");
        monitor.initialize((long)this.mappingCount);
        try {
            this.reader.setPointerIndex(this.mappingOffset);
            for (int i = 0; i < this.mappingCount; ++i) {
                this.mappingInfoList.add(new DyldCacheMappingInfo(this.reader));
                monitor.checkCancelled();
                monitor.incrementProgress(1L);
            }
        }
        catch (IOException e) {
            log.appendMsg(DyldCacheHeader.class.getSimpleName(), "Failed to parse dyld_cache_mapping_info.");
        }
    }

    private void parseImageInfo(MessageLog log, TaskMonitor monitor) throws CancelledException {
        int count;
        int offset = this.imagesOffset != 0 ? this.imagesOffset : this.imagesOffsetOld;
        int n = count = this.imagesOffset != 0 ? this.imagesCount : this.imagesCountOld;
        if (offset == 0) {
            return;
        }
        monitor.setMessage("Parsing DYLD image info...");
        monitor.initialize((long)count);
        try {
            this.reader.setPointerIndex(offset);
            for (int i = 0; i < count; ++i) {
                this.imageInfoList.add(new DyldCacheImageInfo(this.reader));
                monitor.checkCancelled();
                monitor.incrementProgress(1L);
            }
        }
        catch (IOException e) {
            log.appendMsg(DyldCacheHeader.class.getSimpleName(), "Failed to parse dyld_cache_image_info.");
        }
    }

    public void parseLocalSymbolsInfo(boolean shouldParse, MessageLog log, TaskMonitor monitor) throws CancelledException {
        if (!shouldParse || this.localSymbolsOffset == 0L) {
            return;
        }
        monitor.setMessage("Parsing DYLD local symbols info...");
        monitor.initialize(1L);
        try {
            this.reader.setPointerIndex(this.localSymbolsOffset);
            boolean use64bitOffsets = this.imagesOffsetOld == 0;
            this.localSymbolsInfo = new DyldCacheLocalSymbolsInfo(this.reader, this.architecture, use64bitOffsets);
            this.localSymbolsInfo.parse(log, monitor);
            monitor.incrementProgress(1L);
        }
        catch (IOException e) {
            log.appendMsg(DyldCacheHeader.class.getSimpleName(), "Failed to parse dyld_cache_local_symbols_info.");
        }
    }

    private void parseBranchPools(MessageLog log, TaskMonitor monitor) throws CancelledException {
        if (this.branchPoolsOffset == 0) {
            return;
        }
        monitor.setMessage("Parsing DYLD branch pool addresses...");
        monitor.initialize((long)this.branchPoolsCount);
        try {
            this.reader.setPointerIndex(this.branchPoolsOffset);
            for (int i = 0; i < this.branchPoolsCount; ++i) {
                this.branchPoolList.add(this.reader.readNextLong());
                monitor.checkCancelled();
                monitor.incrementProgress(1L);
            }
        }
        catch (IOException e) {
            log.appendMsg(DyldCacheHeader.class.getSimpleName(), "Failed to parse pool addresses.");
        }
    }

    private void parseImageTextInfo(MessageLog log, TaskMonitor monitor) throws CancelledException {
        if (this.imagesTextOffset == 0L) {
            return;
        }
        monitor.setMessage("Parsing DYLD image text info...");
        monitor.initialize(this.imagesTextCount);
        try {
            this.reader.setPointerIndex(this.imagesTextOffset);
            int i = 0;
            while ((long)i < this.imagesTextCount) {
                this.imageTextInfoList.add(new DyldCacheImageTextInfo(this.reader));
                monitor.checkCancelled();
                monitor.incrementProgress(1L);
                ++i;
            }
        }
        catch (IOException e) {
            log.appendMsg(DyldCacheHeader.class.getSimpleName(), "Failed to parse dyld_cache_image_text_info.");
        }
    }

    private void parseSubcaches(MessageLog log, TaskMonitor monitor) throws CancelledException {
        if (this.subCacheArrayOffset == 0) {
            return;
        }
        monitor.setMessage("Parsing DYLD subcaches...");
        monitor.initialize((long)this.subCacheArrayCount.intValue());
        try {
            this.reader.setPointerIndex(this.subCacheArrayOffset);
            for (int i = 0; i < this.subCacheArrayCount; ++i) {
                this.subcacheEntryList.add(new DyldSubcacheEntry(this.reader));
                monitor.checkCancelled();
                monitor.incrementProgress(1L);
            }
        }
        catch (IOException e) {
            log.appendMsg(DyldCacheHeader.class.getSimpleName(), "Failed to parse dyld_subcache_entry.");
        }
    }

    private void parseAcceleratorInfo(Program program, AddressSpace space, MessageLog log, TaskMonitor monitor) throws CancelledException {
        if (!this.hasAccelerateInfo() || this.accelerateInfoAddr_dyldInCacheMH == 0L) {
            return;
        }
        monitor.setMessage("Parsing DYLD accelerateor info...");
        monitor.initialize(this.imagesTextCount);
        Address addr = space.getAddress(this.accelerateInfoAddr_dyldInCacheMH);
        try (MemoryByteProvider bytes = new MemoryByteProvider(program.getMemory(), addr);){
            BinaryReader memoryReader = new BinaryReader(bytes, !program.getLanguage().isBigEndian());
            this.accelerateInfo = new DyldCacheAccelerateInfo(memoryReader);
            this.accelerateInfo.parse(program, addr, log, monitor);
            monitor.incrementProgress(1L);
        }
        catch (IOException e) {
            log.appendMsg(DyldCacheHeader.class.getSimpleName(), "Failed to parse dyld_cache_accelerator_info.");
        }
    }

    private void markupHeader(Program program, AddressSpace space, TaskMonitor monitor, MessageLog log) throws CancelledException {
        monitor.setMessage("Marking up DYLD header...");
        monitor.initialize(1L);
        try {
            DataUtilities.createData((Program)program, (Address)space.getAddress(this.getBaseAddress()), (DataType)this.toDataType(), (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
            monitor.incrementProgress(1L);
        }
        catch (CodeUnitInsertionException | DuplicateNameException | IOException e) {
            log.appendMsg(DyldCacheHeader.class.getSimpleName(), "Failed to markup dyld_cache_header.");
        }
    }

    private void markupMappingInfo(Program program, AddressSpace space, TaskMonitor monitor, MessageLog log) throws CancelledException {
        monitor.setMessage("Marking up DYLD mapping info...");
        monitor.initialize((long)this.mappingInfoList.size());
        try {
            Address addr = this.fileOffsetToAddr(this.mappingOffset, program, space);
            for (DyldCacheMappingInfo mappingInfo : this.mappingInfoList) {
                Data d = DataUtilities.createData((Program)program, (Address)addr, (DataType)mappingInfo.toDataType(), (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                addr = addr.add((long)d.getLength());
                monitor.checkCancelled();
                monitor.incrementProgress(1L);
            }
        }
        catch (CodeUnitInsertionException | DuplicateNameException | IOException e) {
            log.appendMsg(DyldCacheHeader.class.getSimpleName(), "Failed to markup dyld_cache_mapping_info.");
        }
    }

    private void markupCacheMappingSlideInfo(Program program, AddressSpace space, MessageLog log, TaskMonitor monitor) throws CancelledException {
        monitor.setMessage("Marking up DYLD cache mapping and slide info...");
        monitor.initialize((long)this.cacheMappingAndSlideInfoList.size());
        try {
            Address addr = this.fileOffsetToAddr(this.mappingWithSlideOffset, program, space);
            for (DyldCacheMappingAndSlideInfo mappingInfo : this.cacheMappingAndSlideInfoList) {
                Data d = DataUtilities.createData((Program)program, (Address)addr, (DataType)mappingInfo.toDataType(), (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                addr = addr.add((long)d.getLength());
                monitor.checkCancelled();
                monitor.incrementProgress(1L);
            }
        }
        catch (CodeUnitInsertionException | DuplicateNameException | IOException e) {
            log.appendMsg(DyldCacheHeader.class.getSimpleName(), "Failed to markup dyld_cache_mapping_info.");
        }
    }

    private void markupImageInfo(Program program, AddressSpace space, TaskMonitor monitor, MessageLog log) throws CancelledException {
        monitor.setMessage("Marking up DYLD image info...");
        monitor.initialize((long)this.imageInfoList.size());
        try {
            Address addr = this.fileOffsetToAddr(this.imagesOffset != 0 ? (long)this.imagesOffset : (long)this.imagesOffsetOld, program, space);
            for (DyldCacheImageInfo imageInfo : this.imageInfoList) {
                Data d = DataUtilities.createData((Program)program, (Address)addr, (DataType)imageInfo.toDataType(), (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                program.getListing().setComment(addr, 0, imageInfo.getPath());
                addr = addr.add((long)d.getLength());
                monitor.checkCancelled();
                monitor.incrementProgress(1L);
            }
        }
        catch (CodeUnitInsertionException | DuplicateNameException | IOException e) {
            log.appendMsg(DyldCacheHeader.class.getSimpleName(), "Failed to markup dyld_cache_image_info.");
        }
    }

    private void markupCodeSignature(Program program, AddressSpace space, TaskMonitor monitor, MessageLog log) throws CancelledException {
        monitor.setMessage("Marking up DYLD code signature...");
        monitor.initialize(1L);
        try {
            String size = "0x" + Long.toHexString(this.codeSignatureSize);
            program.getListing().setComment(this.fileOffsetToAddr(this.codeSignatureOffset, program, space), 3, "Code Signature (" + size + " bytes)");
            monitor.incrementProgress(1L);
        }
        catch (IllegalArgumentException e) {
            log.appendMsg(DyldCacheHeader.class.getSimpleName(), "Failed to markup code signature.");
        }
    }

    private void markupSlideInfo(Program program, AddressSpace space, TaskMonitor monitor, MessageLog log) throws CancelledException {
        monitor.setMessage("Marking up DYLD slide info...");
        monitor.initialize(1L);
        try {
            if (this.slideInfoList.size() > 0) {
                for (DyldCacheSlideInfoCommon info : this.slideInfoList) {
                    Address addr = this.fileOffsetToAddr(info.getSlideInfoOffset(), program, space);
                    DataUtilities.createData((Program)program, (Address)addr, (DataType)info.toDataType(), (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                }
            }
            monitor.incrementProgress(1L);
        }
        catch (CodeUnitInsertionException | DuplicateNameException | IOException e) {
            log.appendMsg(DyldCacheHeader.class.getSimpleName(), "Failed to markup dyld_cache_slide_info.");
        }
    }

    private void markupLocalSymbolsInfo(boolean shouldMarkup, Program program, AddressSpace space, TaskMonitor monitor, MessageLog log) throws CancelledException {
        if (!shouldMarkup) {
            return;
        }
        monitor.setMessage("Marking up DYLD local symbols info...");
        monitor.initialize(1L);
        try {
            if (this.localSymbolsInfo != null) {
                Address addr = this.fileOffsetToAddr(this.localSymbolsOffset, program, space);
                DataUtilities.createData((Program)program, (Address)addr, (DataType)this.localSymbolsInfo.toDataType(), (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                this.localSymbolsInfo.markup(program, addr, monitor, log);
            }
            monitor.incrementProgress(1L);
        }
        catch (CodeUnitInsertionException | DuplicateNameException | IOException e) {
            log.appendMsg(DyldCacheHeader.class.getSimpleName(), "Failed to markup dyld_cache_local_symbols_info.");
        }
    }

    private void markupBranchPools(Program program, AddressSpace space, TaskMonitor monitor, MessageLog log) throws CancelledException {
        monitor.setMessage("Marking up DYLD branch pool addresses...");
        monitor.initialize((long)this.branchPoolList.size());
        try {
            Address addr = this.fileOffsetToAddr(this.branchPoolsOffset, program, space);
            for (Long element : this.branchPoolList) {
                Data d = DataUtilities.createData((Program)program, (Address)addr, (DataType)Pointer64DataType.dataType, (int)Pointer64DataType.dataType.getLength(), (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                addr = addr.add((long)d.getLength());
                monitor.checkCancelled();
                monitor.incrementProgress(1L);
            }
        }
        catch (CodeUnitInsertionException e) {
            log.appendMsg(DyldCacheHeader.class.getSimpleName(), "Failed to markup branch pool addresses.");
        }
    }

    private void markupAcceleratorInfo(Program program, AddressSpace space, TaskMonitor monitor, MessageLog log) throws CancelledException {
        monitor.setMessage("Marking up DYLD accelerator info...");
        monitor.initialize(1L);
        try {
            if (this.hasAccelerateInfo() && this.accelerateInfo != null) {
                Address addr = space.getAddress(this.accelerateInfoAddr_dyldInCacheMH);
                DataUtilities.createData((Program)program, (Address)addr, (DataType)this.accelerateInfo.toDataType(), (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                this.accelerateInfo.markup(program, addr, monitor, log);
            }
            monitor.incrementProgress(1L);
        }
        catch (CodeUnitInsertionException | DuplicateNameException | IOException e) {
            log.appendMsg(DyldCacheHeader.class.getSimpleName(), "Failed to markup dyld_cache_accelerator_info.");
        }
    }

    private void markupImageTextInfo(Program program, AddressSpace space, TaskMonitor monitor, MessageLog log) throws CancelledException {
        monitor.setMessage("Marking up DYLD image text info...");
        monitor.initialize((long)this.imageTextInfoList.size());
        try {
            Address addr = this.fileOffsetToAddr(this.imagesTextOffset, program, space);
            for (DyldCacheImageTextInfo imageTextInfo : this.imageTextInfoList) {
                Data d = DataUtilities.createData((Program)program, (Address)addr, (DataType)imageTextInfo.toDataType(), (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                program.getListing().setComment(addr, 0, imageTextInfo.getPath());
                addr = addr.add((long)d.getLength());
                monitor.checkCancelled();
                monitor.incrementProgress(1L);
            }
        }
        catch (CodeUnitInsertionException | DuplicateNameException | IOException e) {
            log.appendMsg(DyldCacheHeader.class.getSimpleName(), "Failed to markup dyld_cache_image_text_info.");
        }
    }

    private void markupSubcacheEntries(Program program, AddressSpace space, TaskMonitor monitor, MessageLog log) throws CancelledException {
        monitor.setMessage("Marking up DYLD subcache entries...");
        monitor.initialize((long)this.subcacheEntryList.size());
        try {
            Address addr = this.fileOffsetToAddr(this.subCacheArrayOffset, program, space);
            for (DyldSubcacheEntry subcacheEntry : this.subcacheEntryList) {
                Data d = DataUtilities.createData((Program)program, (Address)addr, (DataType)subcacheEntry.toDataType(), (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                addr = addr.add((long)d.getLength());
                monitor.checkCancelled();
                monitor.incrementProgress(1L);
            }
        }
        catch (CodeUnitInsertionException | DuplicateNameException | IOException e) {
            log.appendMsg(DyldCacheHeader.class.getSimpleName(), "Failed to markup dyld_subcache_entry.");
        }
    }

    public void setFileBlock(MemoryBlock block) {
        this.fileBlock = block;
    }

    private Address fileOffsetToAddr(long offset, Program program, AddressSpace space) {
        for (DyldCacheMappingInfo mappingInfo : this.mappingInfoList) {
            if (offset < mappingInfo.getFileOffset() || offset >= mappingInfo.getFileOffset() + mappingInfo.getSize()) continue;
            return space.getAddress(mappingInfo.getAddress() + (offset - mappingInfo.getFileOffset()));
        }
        if (this.fileBlock != null) {
            AddressSpace fileSpace = this.fileBlock.getStart().getAddressSpace();
            try {
                return fileSpace.getAddress(offset);
            }
            catch (AddressOutOfBoundsException e) {
                return null;
            }
        }
        return null;
    }

    public boolean hasSlideInfo() {
        if (this.slideInfoSize != 0L) {
            return true;
        }
        for (DyldCacheMappingAndSlideInfo info : this.cacheMappingAndSlideInfoList) {
            if (info.getSlideInfoFileSize() == 0L) continue;
            return true;
        }
        return false;
    }

    public long unslidLoadAddress() {
        return this.mappingInfoList.get(0).getAddress();
    }

    public boolean isSubcache() {
        return this.subCacheArrayCount != null && this.subCacheArrayCount == 0 && this.symbolFileUUID == null;
    }

    public boolean hasAccelerateInfo() {
        return this.cacheSubType == null;
    }
}

