/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.commands.LoadCommandTypes;
import ghidra.app.util.bin.format.macho.commands.SegmentCommand;
import ghidra.app.util.importer.MessageLog;
import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.program.flatapi.FlatProgramAPI;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.EndianSettingsDefinition;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramFragment;
import ghidra.program.model.listing.ProgramModule;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public abstract class LoadCommand
implements StructConverter {
    private long startIndex;
    private int cmd;
    private int cmdsize;

    public LoadCommand(BinaryReader reader) throws IOException {
        this.startIndex = reader.getPointerIndex();
        this.cmd = reader.readNextInt();
        this.cmdsize = reader.readNextInt();
    }

    public long getStartIndex() {
        return this.startIndex;
    }

    public int getCommandType() {
        return this.cmd;
    }

    public int getCommandSize() {
        return this.cmdsize;
    }

    public abstract String getCommandName();

    public int getLinkerDataOffset() {
        return 0;
    }

    public int getLinkerDataSize() {
        return 0;
    }

    public void markup(Program program, MachHeader header, String source, TaskMonitor monitor, MessageLog log) throws CancelledException {
    }

    protected void markupPlateComment(Program program, Address address, String source, String additionalDescription) {
        if (address == null) {
            return;
        }
        String comment = this.getContextualName(source, additionalDescription);
        program.getListing().setComment(address, 3, comment);
    }

    protected String getContextualName(String source, String additionalDescription) {
        Object markupName = LoadCommandTypes.getLoadCommandName(this.getCommandType());
        if (additionalDescription != null && !additionalDescription.isBlank()) {
            markupName = (String)markupName + " (" + additionalDescription + ")";
        }
        if (source != null && !source.isBlank()) {
            markupName = (String)markupName + " - " + source;
        }
        return markupName;
    }

    protected Address fileOffsetToAddress(Program program, MachHeader header, int fileOffset, int size) {
        if (fileOffset != 0 && size != 0) {
            AddressSpace space = program.getAddressFactory().getDefaultAddressSpace();
            SegmentCommand segment = this.getContainingSegment(header, fileOffset);
            if (segment != null) {
                return space.getAddress(segment.getVMaddress() + ((long)fileOffset - segment.getFileOffset()));
            }
        }
        return null;
    }

    private SegmentCommand getContainingSegment(MachHeader header, long fileOffset) {
        for (SegmentCommand segment : header.getAllSegments()) {
            if (fileOffset < segment.getFileOffset() || fileOffset >= segment.getFileOffset() + segment.getFileSize()) continue;
            return segment;
        }
        return null;
    }

    public static void setEndian(Data data, boolean bigEndian) throws Exception {
        for (int i = 0; i < data.getNumComponents(); ++i) {
            int j;
            Data component = data.getComponent(i);
            SettingsDefinition[] settings = component.getDataType().getSettingsDefinitions();
            for (j = 0; j < settings.length; ++j) {
                SettingsDefinition settingsDefinition = settings[j];
                if (!(settingsDefinition instanceof EndianSettingsDefinition)) continue;
                EndianSettingsDefinition endianSetting = (EndianSettingsDefinition)settingsDefinition;
                endianSetting.setBigEndian((Settings)component, true);
            }
            for (j = 0; j < component.getNumComponents(); ++j) {
                LoadCommand.setEndian(component.getComponent(j), bigEndian);
            }
        }
    }

    public void markupRawBinary(MachHeader header, FlatProgramAPI api, Address baseAddress, ProgramModule parentModule, TaskMonitor monitor, MessageLog log) {
        this.updateMonitor(monitor);
        try {
            this.createFragment(api, baseAddress, parentModule);
            Address addr = baseAddress.getNewAddress(this.getStartIndex());
            api.createData(addr, this.toDataType());
            this.createPlateComment(api, addr);
        }
        catch (Exception e) {
            log.appendMsg("Unable to create " + this.getCommandName() + " - " + e.getMessage());
        }
    }

    protected final ProgramFragment createFragment(FlatProgramAPI api, Address baseAddress, ProgramModule module) throws Exception {
        Address start = baseAddress.getNewAddress(this.getStartIndex());
        return api.createFragment(module, LoadCommandTypes.getLoadCommandName(this.getCommandType()), start, this.getCommandSize());
    }

    protected final void createPlateComment(FlatProgramAPI api, Address addr) {
        api.setPlateComment(addr, LoadCommandTypes.getLoadCommandName(this.getCommandType()));
    }

    protected final void updateMonitor(TaskMonitor monitor) {
        monitor.setMessage("Processing " + this.getCommandName() + "...");
    }
}

