/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang.rtti.types;

import ghidra.app.util.bin.format.golang.GoFunctionMultiReturn;
import ghidra.app.util.bin.format.golang.rtti.GoSlice;
import ghidra.app.util.bin.format.golang.rtti.types.GoBaseType;
import ghidra.app.util.bin.format.golang.rtti.types.GoType;
import ghidra.app.util.bin.format.golang.structmapping.FieldMapping;
import ghidra.app.util.bin.format.golang.structmapping.Markup;
import ghidra.app.util.bin.format.golang.structmapping.MarkupSession;
import ghidra.app.util.bin.format.golang.structmapping.StructureMapping;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.FunctionDefinitionDataType;
import ghidra.program.model.data.ParameterDefinition;
import ghidra.program.model.data.ParameterDefinitionImpl;
import ghidra.program.model.data.VoidDataType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@StructureMapping(structureName="runtime.functype")
public class GoFuncType
extends GoType {
    @FieldMapping
    private int inCount;
    @FieldMapping
    private int outCount;

    public boolean isVarArg() {
        return (this.outCount & 0x8000) != 0;
    }

    public int getInCount() {
        return this.inCount;
    }

    public int getOutCount() {
        return this.outCount & Short.MAX_VALUE;
    }

    public int getParamCount() {
        return this.inCount + (this.outCount & Short.MAX_VALUE);
    }

    public List<Address> getParamTypeAddrs() throws IOException {
        GoSlice slice = this.getParamListSlice();
        long[] typeOffsets = slice.readUIntList(this.programContext.getPtrSize());
        return Arrays.stream(typeOffsets).mapToObj(this.programContext::getDataAddress).collect(Collectors.toList());
    }

    private GoSlice getParamListSlice() {
        int count = this.getParamCount();
        return new GoSlice(this.getOffsetEndOfFullType(), count, count, this.programContext);
    }

    @Markup
    public List<GoType> getParamTypes() throws IOException {
        return this.getParamTypeAddrs().stream().map(addr -> {
            try {
                return this.programContext.getGoType((Address)addr);
            }
            catch (IOException e) {
                return null;
            }
        }).collect(Collectors.toList());
    }

    @Override
    public void additionalMarkup(MarkupSession session) throws IOException {
        GoSlice slice = this.getParamListSlice();
        slice.markupArray(this.getStructureLabel() + "_paramlist", GoBaseType.class, true, session);
    }

    public String getFuncPrototypeString(String funcName) throws IOException {
        GoType paramType;
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("func");
        if (funcName != null && !funcName.isBlank()) {
            sb.append(" ").append(funcName);
        }
        sb.append("(");
        List<GoType> paramTypes = this.getParamTypes();
        List<GoType> inParamTypes = paramTypes.subList(0, this.inCount);
        List<GoType> outParamTypes = paramTypes.subList(this.inCount, paramTypes.size());
        for (i = 0; i < inParamTypes.size(); ++i) {
            paramType = inParamTypes.get(i);
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(paramType.getNameString());
        }
        sb.append(")");
        if (!outParamTypes.isEmpty()) {
            sb.append(" (");
            for (i = 0; i < outParamTypes.size(); ++i) {
                paramType = outParamTypes.get(i);
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(paramType.getNameString());
            }
            sb.append(")");
        }
        return sb.toString();
    }

    @Override
    public DataType recoverDataType() throws IOException {
        VoidDataType returnDT;
        String name = this.typ.getNameString();
        DataTypeManager dtm = this.programContext.getDTM();
        List<GoType> paramTypes = this.getParamTypes();
        List<GoType> inParamTypes = paramTypes.subList(0, this.inCount);
        List<GoType> outParamTypes = paramTypes.subList(this.inCount, paramTypes.size());
        ArrayList<ParameterDefinitionImpl> params = new ArrayList<ParameterDefinitionImpl>();
        for (int i = 0; i < inParamTypes.size(); ++i) {
            GoType paramType = inParamTypes.get(i);
            DataType paramDT = paramType.recoverDataType();
            params.add(new ParameterDefinitionImpl(null, paramDT, null));
        }
        if (outParamTypes.size() == 0) {
            returnDT = VoidDataType.dataType;
        } else if (outParamTypes.size() == 1) {
            returnDT = outParamTypes.get(0).recoverDataType();
        } else {
            List<DataType> paramDataTypes = this.recoverTypes(outParamTypes);
            GoFunctionMultiReturn multiReturn = new GoFunctionMultiReturn(this.programContext.getRecoveredTypesCp(), name, paramDataTypes, dtm, null);
            returnDT = multiReturn.getStruct();
        }
        FunctionDefinitionDataType funcDef = new FunctionDefinitionDataType(this.programContext.getRecoveredTypesCp(), name, dtm);
        funcDef.setArguments((ParameterDefinition[])params.toArray(ParameterDefinition[]::new));
        funcDef.setReturnType((DataType)returnDT);
        return dtm.getPointer((DataType)funcDef);
    }

    private List<DataType> recoverTypes(List<GoType> types) throws IOException {
        ArrayList<DataType> result = new ArrayList<DataType>();
        for (GoType type : types) {
            result.add(type.recoverDataType());
        }
        return result;
    }

    @Override
    public boolean discoverGoTypes(Set<Long> discoveredTypes) throws IOException {
        if (!super.discoverGoTypes(discoveredTypes)) {
            return false;
        }
        for (GoType paramType : this.getParamTypes()) {
            if (paramType == null) continue;
            paramType.discoverGoTypes(discoveredTypes);
        }
        return true;
    }

    @Override
    public String toString() {
        try {
            return this.getFuncPrototypeString(null);
        }
        catch (IOException e) {
            return super.toString();
        }
    }
}

