/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang.rtti;

import ghidra.app.util.bin.format.golang.rtti.GoModuledata;
import ghidra.app.util.bin.format.golang.rtti.GoRttiMapper;
import ghidra.app.util.bin.format.golang.structmapping.ContextField;
import ghidra.app.util.bin.format.golang.structmapping.EOLComment;
import ghidra.app.util.bin.format.golang.structmapping.FieldMapping;
import ghidra.app.util.bin.format.golang.structmapping.MarkupReference;
import ghidra.app.util.bin.format.golang.structmapping.MarkupSession;
import ghidra.app.util.bin.format.golang.structmapping.StructureContext;
import ghidra.app.util.bin.format.golang.structmapping.StructureMapping;
import ghidra.app.util.bin.format.golang.structmapping.StructureMarkup;
import ghidra.program.model.address.Address;
import ghidra.program.model.symbol.SymbolUtilities;
import java.io.IOException;

@StructureMapping(structureName="runtime._func")
public class GoFuncData
implements StructureMarkup<GoFuncData> {
    @ContextField
    private GoRttiMapper programContext;
    @ContextField
    private StructureContext<GoFuncData> context;
    @FieldMapping(optional=true, fieldName={"entryoff", "entryOff"})
    @EOLComment(value="description")
    @MarkupReference(value="funcAddress")
    private long entryoff;
    @FieldMapping(optional=true)
    @EOLComment(value="description")
    @MarkupReference(value="funcAddress")
    private long entry;
    @FieldMapping(fieldName={"nameoff", "nameOff"})
    @MarkupReference(value="nameAddress")
    private long nameoff;
    private Address funcAddress;

    public void setEntryoff(long entryoff) {
        this.entryoff = entryoff;
        GoModuledata moduledata = this.getModuledata();
        this.funcAddress = moduledata != null ? moduledata.getText().add(entryoff) : null;
    }

    public void setEntry(long entry) {
        this.entry = entry;
        this.funcAddress = this.context.getDataTypeMapper().getCodeAddress(entry);
    }

    public Address getFuncAddress() {
        return this.funcAddress;
    }

    public Address getNameAddress() {
        GoModuledata moduledata = this.getModuledata();
        return moduledata != null ? moduledata.getFuncnametab().getArrayAddress().add(this.nameoff) : null;
    }

    public String getName() throws IOException {
        GoModuledata moduledata = this.getModuledata();
        return moduledata != null ? this.programContext.getReader(moduledata.getFuncnametab().getArrayOffset() + this.nameoff).readNextUtf8String() : null;
    }

    public String getDescription() throws IOException {
        return this.getName() + "@" + this.getFuncAddress();
    }

    public boolean isInline() {
        return this.entryoff == -1L || this.entryoff == 0xFFFFFFFFL;
    }

    private GoModuledata getModuledata() {
        return this.programContext.findContainingModuleByFuncData(this.context.getStructureStart());
    }

    @Override
    public StructureContext<GoFuncData> getStructureContext() {
        return this.context;
    }

    @Override
    public String getStructureName() throws IOException {
        return this.getName();
    }

    @Override
    public void additionalMarkup(MarkupSession session) throws IOException {
        Address addr = this.getFuncAddress();
        String name = SymbolUtilities.replaceInvalidChars((String)this.getName(), (boolean)true);
        session.createFunctionIfMissing(name, addr);
    }
}

