/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.relocation;

import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfLoadHelper;
import ghidra.app.util.bin.format.elf.ElfRelocation;
import ghidra.app.util.bin.format.elf.ElfRelocationTable;
import ghidra.app.util.bin.format.elf.ElfSymbol;
import ghidra.app.util.bin.format.elf.ElfSymbolTable;
import ghidra.app.util.bin.format.elf.extend.ElfLoadAdapter;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationHandler;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationHandlerFactory;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramFragment;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.reloc.RelocationResult;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.NotEmptyException;
import ghidra.util.exception.NotFoundException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ElfRelocationContext {
    protected final ElfRelocationHandler handler;
    protected final ElfLoadHelper loadHelper;
    protected final Map<ElfSymbol, Address> symbolMap;
    protected final Program program;
    protected ElfRelocationTable relocationTable;
    protected ElfSymbolTable symbolTable;
    private ElfSymbol nullSymbol;

    protected ElfRelocationContext(ElfRelocationHandler handler, ElfLoadHelper loadHelper, Map<ElfSymbol, Address> symbolMap) {
        this.handler = handler;
        this.loadHelper = loadHelper;
        this.symbolMap = symbolMap;
        this.program = loadHelper.getProgram();
    }

    public void startRelocationTableProcessing(ElfRelocationTable relocTable) {
        this.relocationTable = relocTable;
        this.symbolTable = relocTable.getAssociatedSymbolTable();
        if (this.symbolTable == null) {
            this.nullSymbol = new ElfSymbol();
        }
    }

    public void endRelocationTableProcessing() {
        this.relocationTable = null;
    }

    public final RelocationResult processRelocation(ElfRelocation relocation, Address relocationAddress) {
        if (this.handler == null) {
            this.handleNoHandlerError(relocation, relocationAddress);
            return RelocationResult.FAILURE;
        }
        int symbolIndex = relocation.getSymbolIndex();
        ElfSymbol sym = this.getSymbol(symbolIndex);
        if (sym == null) {
            ElfRelocationHandler.markAsUnhandled(this.program, relocationAddress, relocation.getType(), symbolIndex, "index " + symbolIndex, this.getLog());
            return RelocationResult.FAILURE;
        }
        if (sym.isTLS()) {
            this.handleUnsupportedTLSRelocation(relocation, relocationAddress, sym);
            return RelocationResult.FAILURE;
        }
        try {
            return this.handler.relocate(this, relocation, relocationAddress);
        }
        catch (MemoryAccessException | NotFoundException e) {
            this.loadHelper.log(e);
            ElfRelocationHandler.markAsUnhandled(this.program, relocationAddress, relocation.getType(), symbolIndex, sym.getNameAsString(), this.getLog());
            return RelocationResult.FAILURE;
        }
    }

    public long getRelrRelocationType() {
        return this.handler != null ? (long)this.handler.getRelrRelocationType() : 0L;
    }

    private void handleUnsupportedTLSRelocation(ElfRelocation relocation, Address relocationAddress, ElfSymbol sym) {
        ElfRelocationHandler.markAsError(this.program, relocationAddress, relocation.getType(), sym.getNameAsString(), "TLS symbol relocation not yet supported", this.getLog());
    }

    private void handleNoHandlerError(ElfRelocation relocation, Address relocationAddress) {
        String symName = this.getSymbolName(relocation.getSymbolIndex());
        Object nameMsg = "";
        if (!StringUtils.isBlank((CharSequence)symName)) {
            nameMsg = " to: " + symName;
        }
        this.program.getBookmarkManager().setBookmark(relocationAddress, "Error", "Relocation", "No handler to process ELF Relocation" + (String)nameMsg);
        this.loadHelper.log("WARNING: At " + relocationAddress + " no handler to process ELF Relocation" + (String)nameMsg);
    }

    public static ElfRelocationContext getRelocationContext(ElfLoadHelper loadHelper, Map<ElfSymbol, Address> symbolMap) {
        ElfHeader elf = loadHelper.getElfHeader();
        ElfRelocationContext context = null;
        ElfRelocationHandler handler = ElfRelocationHandlerFactory.getHandler(elf);
        if (handler != null) {
            context = handler.createRelocationContext(loadHelper, symbolMap);
        }
        if (context == null) {
            context = new ElfRelocationContext(handler, loadHelper, symbolMap);
        }
        return context;
    }

    public final boolean hasRelocationHandler() {
        return this.handler != null;
    }

    public long getImageBaseWordAdjustmentOffset() {
        return this.loadHelper.getImageBaseWordAdjustmentOffset();
    }

    public boolean extractAddend() {
        return !this.relocationTable.hasAddendRelocations();
    }

    public final Program getProgram() {
        return this.program;
    }

    public final boolean isBigEndian() {
        return this.program.getMemory().isBigEndian();
    }

    public final ElfHeader getElfHeader() {
        return this.loadHelper.getElfHeader();
    }

    public final ElfLoadHelper getLoadHelper() {
        return this.loadHelper;
    }

    public final ElfLoadAdapter getLoadAdapter() {
        return this.getElfHeader().getLoadAdapter();
    }

    public final MessageLog getLog() {
        return this.loadHelper.getLog();
    }

    public final ElfSymbol getSymbol(int symbolIndex) {
        if (this.symbolTable == null) {
            return symbolIndex == 0 ? this.nullSymbol : null;
        }
        return this.symbolTable.getSymbol(symbolIndex);
    }

    public final String getSymbolName(int symbolIndex) {
        return this.symbolTable != null ? this.symbolTable.getSymbolName(symbolIndex) : null;
    }

    public Address getSymbolAddress(ElfSymbol symbol) {
        return symbol != null ? this.symbolMap.get(symbol) : null;
    }

    public long getSymbolValue(ElfSymbol symbol) {
        Address symAddr = symbol != null ? this.symbolMap.get(symbol) : null;
        return symAddr != null ? symAddr.getAddressableWordOffset() : 0L;
    }

    public long getGOTValue() throws NotFoundException {
        Long gotValue = this.loadHelper.getGOTValue();
        if (gotValue == null) {
            throw new NotFoundException("Failed to identify _GLOBAL_OFFSET_TABLE_");
        }
        return gotValue;
    }

    public void dispose() {
        Listing listing = this.program.getListing();
        try {
            String extendedBlockName = "EXTERNAL.ext";
            ProgramFragment extendedFragment = listing.getFragment("Program Tree", extendedBlockName);
            if (extendedFragment != null) {
                ProgramFragment externalFragment = listing.getFragment("Program Tree", "EXTERNAL");
                if (externalFragment == null) {
                    extendedFragment.setName("EXTERNAL");
                } else {
                    externalFragment.move(extendedFragment.getMinAddress(), extendedFragment.getMaxAddress());
                    externalFragment.getParents()[0].removeChild(extendedBlockName);
                }
            }
        }
        catch (DuplicateNameException | NotEmptyException | NotFoundException e) {
            this.loadHelper.log("Failed to reconcile extended EXTERNAL block fragment");
        }
    }

    public Address getRelocationAddress(Address baseAddress, long relocOffset) {
        return baseAddress.addWrap(relocOffset);
    }
}

