/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf4.encoding;

import java.util.HashMap;
import java.util.Map;

public enum DWARFChildren {
    DW_CHILDREN_no(0),
    DW_CHILDREN_yes(1);

    private final int value;
    private static final Map<Integer, DWARFChildren> valueMap;

    private DWARFChildren(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static DWARFChildren find(Number key) {
        DWARFChildren access = valueMap.get(key.intValue());
        if (access != null) {
            return access;
        }
        throw new IllegalArgumentException("Invalid Integer value: " + key.toString());
    }

    static {
        valueMap = new HashMap<Integer, DWARFChildren>();
        for (DWARFChildren access : DWARFChildren.values()) {
            valueMap.put(access.getValue(), access);
        }
    }
}

