/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.services;

public class AnalysisPriority {
    public static final AnalysisPriority FORMAT_ANALYSIS = AnalysisPriority.getInitial("FORMAT");
    public static final AnalysisPriority BLOCK_ANALYSIS = FORMAT_ANALYSIS.getNext("BLOCK");
    public static final AnalysisPriority DISASSEMBLY = BLOCK_ANALYSIS.getNext("DISASSEMBLY");
    public static final AnalysisPriority CODE_ANALYSIS = DISASSEMBLY.getNext("CODE");
    public static final AnalysisPriority FUNCTION_ANALYSIS = CODE_ANALYSIS.getNext("FUNCTION");
    public static final AnalysisPriority REFERENCE_ANALYSIS = FUNCTION_ANALYSIS.getNext("REFERENCE");
    public static final AnalysisPriority DATA_ANALYSIS = REFERENCE_ANALYSIS.getNext("DATA");
    public static final AnalysisPriority FUNCTION_ID_ANALYSIS = DATA_ANALYSIS.getNext("FUNCTION ID");
    public static final AnalysisPriority DATA_TYPE_PROPOGATION = FUNCTION_ID_ANALYSIS.getNext("DATA TYPE PROPOGATION");
    public static final AnalysisPriority LOW_PRIORITY = new AnalysisPriority("LOW", 10000);
    public static final AnalysisPriority HIGHEST_PRIORITY = new AnalysisPriority("HIGH", 1);
    private int priority;
    private String name;

    public AnalysisPriority(int priority) {
        this(null, priority);
    }

    public AnalysisPriority(String name, int priority) {
        this.name = name;
        this.priority = priority;
    }

    public int priority() {
        return this.priority;
    }

    public AnalysisPriority before() {
        return new AnalysisPriority(this.name + "-", this.priority - 1);
    }

    public AnalysisPriority after() {
        return new AnalysisPriority(this.name + "+", this.priority + 1);
    }

    public static AnalysisPriority getInitial(String name) {
        return new AnalysisPriority(name, 100);
    }

    public AnalysisPriority getNext(String nextName) {
        return new AnalysisPriority(nextName, this.priority + 100);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.name != null) {
            buf.append("[").append(this.name).append("]  ");
        }
        buf.append(this.priority);
        return buf.toString();
    }
}

