/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.searchmem.mask;

import java.util.Arrays;

class MaskValue {
    private byte[] mask;
    private byte[] value;
    private String textRepresentation;

    public MaskValue(byte[] mask, byte[] value) {
        this.mask = mask;
        this.value = value;
    }

    public MaskValue(byte[] mask, byte[] value, String textRepresentation) {
        this.mask = mask;
        this.value = value;
        this.textRepresentation = textRepresentation;
    }

    public String toString() {
        String rep = this.textRepresentation == null ? "" : this.textRepresentation;
        return this.getClass().getSimpleName() + " - " + rep + " [mask=" + Arrays.toString(this.mask) + ", value=" + Arrays.toString(this.value) + "]";
    }

    public void orMask(byte[] other) {
        if (this.mask == null) {
            return;
        }
        this.mask = this.byteArrayOr(this.mask, other);
    }

    public void orValue(byte[] other) {
        if (this.value == null) {
            return;
        }
        this.value = this.byteArrayOr(this.value, other);
    }

    private byte[] byteArrayOr(byte[] arr1, byte[] arr2) {
        byte[] result = new byte[arr1.length];
        if (arr1.length != arr2.length) {
            return null;
        }
        for (int x = 0; x < arr1.length; ++x) {
            result[x] = (byte)(arr1[x] | arr2[x]);
        }
        return result;
    }

    public void setMask(byte[] mask) {
        this.mask = mask;
    }

    public void setValue(byte[] value) {
        this.value = value;
    }

    public byte[] getValue() {
        return this.value;
    }

    public byte[] getMask() {
        return this.mask;
    }
}

