/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.misc;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.Tool;
import docking.action.builder.ActionBuilder;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Miscellaneous", shortDescription="Provides generic actions for increasing/decreasing fonts.", description="This plugin provides actions for increasing fonts used by component providers. ComponentProviders can either override the \"changeFontSize()\" method or register atheme font id that can be automatically adjusted.")
public class FontAdjustPlugin
extends Plugin {
    public FontAdjustPlugin(PluginTool tool) {
        super(tool);
        ((ActionBuilder)((ActionBuilder)new ActionBuilder("Increment Font", "tool").keyBinding("ctrl EQUALS")).onAction(this::incrementFont)).buildAndInstall((Tool)tool);
        ((ActionBuilder)((ActionBuilder)new ActionBuilder("Decrement Font", "tool").keyBinding("ctrl MINUS")).onAction(this::decrementFont)).buildAndInstall((Tool)tool);
        ((ActionBuilder)((ActionBuilder)new ActionBuilder("Reset Font", "tool").keyBinding("ctrl 0")).onAction(this::resetFontSize)).buildAndInstall((Tool)tool);
    }

    private void incrementFont(ActionContext context) {
        ComponentProvider provider = context.getComponentProvider();
        if (provider != null) {
            provider.adjustFontSize(true);
        }
    }

    private void decrementFont(ActionContext context) {
        ComponentProvider provider = context.getComponentProvider();
        if (provider != null) {
            provider.adjustFontSize(false);
        }
    }

    private void resetFontSize(ActionContext context) {
        ComponentProvider provider = context.getComponentProvider();
        if (provider != null) {
            provider.resetFontSize();
        }
    }
}

