/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.rmi.trace;

import ghidra.app.plugin.core.debug.event.TraceActivatedPluginEvent;
import ghidra.app.plugin.core.debug.event.TraceClosedPluginEvent;
import ghidra.app.plugin.core.debug.service.rmi.trace.TraceRmiAcceptor;
import ghidra.app.plugin.core.debug.service.rmi.trace.TraceRmiHandler;
import ghidra.app.plugin.core.debug.service.rmi.trace.TraceRmiServer;
import ghidra.app.services.TraceRmiService;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.util.task.ConsoleTaskMonitor;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;

@PluginInfo(shortDescription="Connect to back-end debuggers via Trace RMI", description="Provides an alternative for connecting to back-end debuggers. The DebuggerModel has\nbecome a bit onerous to implement. Despite its apparent flexibility, the recorder at\nthe front-end imposes many restrictions, and getting it to work turns into a lot of\nguess work and frustration. Trace RMI should offer a more direct means of recording a\ntrace from a back-end.\n", category="Debugger", packageName="Debugger", status=PluginStatus.RELEASED, eventsConsumed={TraceActivatedPluginEvent.class, TraceClosedPluginEvent.class}, servicesProvided={TraceRmiService.class})
public class TraceRmiPlugin
extends Plugin
implements TraceRmiService {
    private static final int DEFAULT_PORT = 15432;
    private final TaskMonitor monitor = new ConsoleTaskMonitor();
    private SocketAddress serverAddress = new InetSocketAddress("0.0.0.0", 15432);
    private TraceRmiServer server;

    public TraceRmiPlugin(PluginTool tool) {
        super(tool);
    }

    public TaskMonitor getTaskMonitor() {
        return this.monitor;
    }

    @Override
    public SocketAddress getServerAddress() {
        if (this.server != null) {
            return this.server.getAddress();
        }
        return this.serverAddress;
    }

    @Override
    public void setServerAddress(SocketAddress serverAddress) {
        if (this.server != null) {
            throw new IllegalStateException("Cannot change server address while it is started");
        }
        this.serverAddress = serverAddress;
    }

    @Override
    public void startServer() throws IOException {
        if (this.server != null) {
            throw new IllegalStateException("Server is already started");
        }
        this.server = new TraceRmiServer(this, this.serverAddress);
        this.server.start();
    }

    @Override
    public void stopServer() {
        if (this.server != null) {
            this.server.close();
        }
        this.server = null;
    }

    @Override
    public boolean isServerStarted() {
        return this.server != null;
    }

    @Override
    public TraceRmiHandler connect(SocketAddress address) throws IOException {
        Socket socket = new Socket();
        socket.connect(address);
        return new TraceRmiHandler(this, socket);
    }

    @Override
    public TraceRmiAcceptor acceptOne(SocketAddress address) throws IOException {
        TraceRmiAcceptor acceptor = new TraceRmiAcceptor(this, address);
        acceptor.start();
        return acceptor;
    }
}

