/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractModifierMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractPointerMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.DummyMsType;
import ghidra.app.util.pdb.pdbapplicator.ClassTypeUtils;
import ghidra.app.util.pdb.pdbapplicator.CompositeTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.DefaultPdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.ModifierTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.MsTypeApplier;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypePath;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.Undefined;
import ghidra.util.exception.CancelledException;
import java.math.BigInteger;

public class PointerTypeApplier
extends MsTypeApplier {
    private String memberComment = null;

    public PointerTypeApplier(DefaultPdbApplicator applicator, AbstractPointerMsType msType) throws IllegalArgumentException {
        super(applicator, msType);
    }

    String getPointerCommentField() {
        return this.memberComment;
    }

    @Override
    BigInteger getSize() {
        return ((AbstractPointerMsType)this.msType).getSize();
    }

    @Override
    void apply() throws PdbException, CancelledException {
        this.dataType = this.msType instanceof DummyMsType ? new PointerDataType(this.applicator.getDataTypeManager()) : this.applyAbstractPointerMsType((AbstractPointerMsType)this.msType);
    }

    @Override
    void resolve() {
    }

    MsTypeApplier getUnmodifiedUnderlyingTypeApplier() {
        MsTypeApplier thisUnderlyingTypeApplier = this.applicator.getTypeApplier(((AbstractPointerMsType)this.msType).getUnderlyingRecordNumber());
        if (thisUnderlyingTypeApplier instanceof ModifierTypeApplier) {
            ModifierTypeApplier x = (ModifierTypeApplier)thisUnderlyingTypeApplier;
            RecordNumber recNum = ((AbstractModifierMsType)x.getMsType()).getModifiedRecordNumber();
            thisUnderlyingTypeApplier = this.applicator.getTypeApplier(recNum);
        }
        return thisUnderlyingTypeApplier;
    }

    private DataType getUnderlyingType(AbstractPointerMsType type) {
        MsTypeApplier underlyingApplier = this.applicator.getTypeApplier(type.getUnderlyingRecordNumber());
        DataType underlyingType = underlyingApplier.getCycleBreakType();
        return underlyingType;
    }

    private DataType applyAbstractPointerMsType(AbstractPointerMsType type) {
        AbstractPointerMsType.PointerMode pointerMode = type.getPointerMode();
        if (pointerMode == AbstractPointerMsType.PointerMode.MEMBER_DATA_POINTER || pointerMode == AbstractPointerMsType.PointerMode.MEMBER_FUNCTION_POINTER) {
            return this.processMemberPointer(type);
        }
        return this.processPointer(type);
    }

    private DataType processMemberPointer(AbstractPointerMsType type) {
        CompositeTypeApplier cta;
        DataTypePath dtp;
        String name;
        DataType underlyingType = this.getUnderlyingType(type);
        int size = type.getSize().intValueExact();
        RecordNumber memberPointerContainingClassRecordNumber = type.getMemberPointerContainingClassRecordNumber();
        MsTypeApplier containingClassApplier = this.applicator.getTypeApplier(memberPointerContainingClassRecordNumber);
        DataType dt = null;
        AbstractPointerMsType.PointerMode pointerMode = type.getPointerMode();
        if (pointerMode == AbstractPointerMsType.PointerMode.MEMBER_FUNCTION_POINTER) {
            name = String.format("pmf_%08x", type.toString().hashCode());
            this.memberComment = "\"::*\" (pmf) to type: " + underlyingType;
        } else {
            name = String.format("pdm_%08x", type.toString().hashCode());
            this.memberComment = "\"::*\" (pdm) to type: " + underlyingType;
        }
        if (containingClassApplier instanceof CompositeTypeApplier && (dtp = ClassTypeUtils.getInternalsDataTypePath(cta = (CompositeTypeApplier)containingClassApplier, name)) != null && (dt = this.applicator.getDataTypeManager().getDataType(dtp)) == null) {
            dt = new StructureDataType(dtp.getCategoryPath(), dtp.getDataTypeName(), size);
            dt.setDescription(type.toString());
        }
        if (dt == null) {
            dt = Undefined.getUndefinedDataType((int)size);
        }
        return dt;
    }

    private DataType processPointer(AbstractPointerMsType type) {
        this.memberComment = null;
        DataType underlyingType = this.getUnderlyingType(type);
        int size = type.getSize().intValueExact();
        if (size == this.applicator.getDataOrganization().getPointerSize()) {
            size = -1;
        }
        return new PointerDataType(underlyingType, size, this.applicator.getDataTypeManager());
    }
}

