/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.cmd.function.CallDepthChangeInfo;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractManagedProcedureMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTableRow;
import ghidra.app.util.bin.format.pe.cli.tables.CliTableMethodDef;
import ghidra.app.util.bin.format.pe.cli.tables.CliTableMethodImpl;
import ghidra.app.util.bin.format.pe.cli.tables.CliTableMethodSemantics;
import ghidra.app.util.bin.format.pe.cli.tables.CliTableMethodSpec;
import ghidra.app.util.pdb.pdbapplicator.BlockCommentsManager;
import ghidra.app.util.pdb.pdbapplicator.DefaultPdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.DeferrableFunctionSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.MsSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.SymbolGroup;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.InstructionIterator;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ManagedProcedureSymbolApplier
extends MsSymbolApplier
implements DeferrableFunctionSymbolApplier {
    private static final String BLOCK_INDENT = "   ";
    private AbstractManagedProcedureMsSymbol procedureSymbol;
    private Address specifiedAddress;
    private Address address;
    private boolean isNonReturning;
    private Function function = null;
    private long specifiedFrameSize = 0L;
    private long currentFrameSize = 0L;
    private BlockCommentsManager comments;
    private int symbolBlockNestingLevel;
    private Address currentBlockAddress;
    private int baseParamOffset = 0;
    private List<MsSymbolApplier> allAppliers = new ArrayList<MsSymbolApplier>();
    private RegisterChangeCalculator registerChangeCalculator;

    public ManagedProcedureSymbolApplier(DefaultPdbApplicator applicator, SymbolGroup.AbstractMsSymbolIterator iter) throws CancelledException {
        super(applicator, iter);
        AbstractMsSymbol abstractSymbol = iter.next();
        this.symbolBlockNestingLevel = 0;
        this.comments = new BlockCommentsManager();
        this.currentBlockAddress = null;
        if (!(abstractSymbol instanceof AbstractManagedProcedureMsSymbol)) {
            throw new AssertException("Invalid symbol type: " + abstractSymbol.getClass().getSimpleName());
        }
        applicator.getPdbApplicatorMetrics().witnessCannotApplySymbolType(abstractSymbol);
        this.procedureSymbol = (AbstractManagedProcedureMsSymbol)abstractSymbol;
        this.specifiedAddress = applicator.getRawAddress(this.procedureSymbol);
        this.address = applicator.getAddress(this.procedureSymbol);
        this.isNonReturning = this.procedureSymbol.getFlags().doesNotReturn();
        this.manageBlockNesting(this);
        while (this.notDone()) {
            applicator.checkCancelled();
            MsSymbolApplier applier = applicator.getSymbolApplier(iter);
            this.allAppliers.add(applier);
            applier.manageBlockNesting(this);
        }
    }

    @Override
    void manageBlockNesting(MsSymbolApplier applierParam) {
        ManagedProcedureSymbolApplier procedureSymbolApplier = (ManagedProcedureSymbolApplier)applierParam;
        long start = this.procedureSymbol.getDebugStartOffset();
        long end = this.procedureSymbol.getDebugEndOffset();
        Address blockAddress = this.address.add(start);
        long length = end - start;
        procedureSymbolApplier.beginBlock(blockAddress, this.procedureSymbol.getName(), length);
    }

    Function getFunction() {
        return this.function;
    }

    long getCurrentFrameSize() {
        return this.currentFrameSize;
    }

    long getSpecifiedFrameSize() {
        return this.specifiedFrameSize;
    }

    void setSpecifiedFrameSize(long specifiedFrameSize) {
        this.specifiedFrameSize = specifiedFrameSize;
        this.currentFrameSize = specifiedFrameSize;
    }

    String getName() {
        return this.procedureSymbol.getName();
    }

    @Override
    void applyTo(MsSymbolApplier applyToApplier) {
    }

    @Override
    void apply() throws PdbException, CancelledException {
    }

    boolean applyTo(TaskMonitor monitor) throws PdbException, CancelledException {
        if (this.applicator.isInvalidAddress(this.address, this.getName())) {
            return false;
        }
        for (MsSymbolApplier applier : this.allAppliers) {
            applier.applyTo(this);
        }
        boolean functionSuccess = this.applyFunction(monitor);
        return functionSuccess;
    }

    Integer getRegisterPrologChange(Register register) {
        return this.registerChangeCalculator.getRegChange(this.applicator, register);
    }

    int getBaseParamOffset() {
        return this.baseParamOffset;
    }

    void setLocalVariable(Address address, String name, DataType dataType) {
        if (this.currentBlockAddress == null) {
            return;
        }
        String comment = this.getIndent(this.symbolBlockNestingLevel + 1) + "static local (stored at " + address + ") " + dataType.getName() + " " + name;
        this.comments.addPreComment(this.currentBlockAddress, comment);
    }

    private boolean applyFunction(TaskMonitor monitor) {
        this.applicator.createSymbol(this.address, this.getName(), true);
        this.function = this.applicator.getExistingOrCreateOneByteFunction(this.address);
        if (this.function == null) {
            return false;
        }
        this.applicator.scheduleDeferredFunctionWork(this);
        if (!this.function.isThunk() && this.function.getSignatureSource().isLowerPriorityThan(SourceType.IMPORTED)) {
            this.setFunctionDefinition(monitor);
            this.function.setNoReturn(this.isNonReturning);
        }
        this.currentFrameSize = 0L;
        return true;
    }

    private boolean setFunctionDefinition(TaskMonitor monitor) {
        if (this.procedureSymbol == null) {
            return true;
        }
        long token = this.procedureSymbol.getToken();
        int table = (int)(token >> 24) & 0xFF;
        int row = (int)(token & 0xFFFFFFL);
        try {
            CliTableMethodDef.CliMethodDefRow cliMethodDefRow;
            CliAbstractTableRow tableRow = this.applicator.getCliTableRow(table, row);
            if (tableRow instanceof CliTableMethodDef.CliMethodDefRow) {
                cliMethodDefRow = (CliTableMethodDef.CliMethodDefRow)tableRow;
            }
            if (tableRow instanceof CliTableMethodImpl.CliMethodImplRow) {
                cliMethodDefRow = (CliTableMethodImpl.CliMethodImplRow)tableRow;
            }
            if (tableRow instanceof CliTableMethodSemantics.CliMethodSemanticsRow) {
                cliMethodDefRow = (CliTableMethodSemantics.CliMethodSemanticsRow)tableRow;
            }
            if (tableRow instanceof CliTableMethodSpec.CliMethodSpecRow) {
                cliMethodDefRow = (CliTableMethodSpec.CliMethodSpecRow)tableRow;
            }
        }
        catch (PdbException e) {
            return false;
        }
        return true;
    }

    private boolean notDone() {
        return this.symbolBlockNestingLevel > 0 && this.iter.hasNext();
    }

    int endBlock() {
        if (--this.symbolBlockNestingLevel < 0) {
            this.applicator.appendLogMsg("Block Nesting went negative for " + this.getName() + " at " + this.address);
        }
        if (this.symbolBlockNestingLevel == 0) {
            // empty if block
        }
        return this.symbolBlockNestingLevel;
    }

    void beginBlock(Address startAddress, String name, long length) {
        int nestingLevel = this.beginBlock(startAddress);
        if (!this.applicator.getPdbApplicatorOptions().applyCodeScopeBlockComments()) {
            return;
        }
        if (this.applicator.isInvalidAddress(startAddress, name)) {
            return;
        }
        String indent = this.getIndent(nestingLevel);
        String baseComment = "level " + nestingLevel + ", length " + length;
        String preComment = indent + "PDB: Block Beg, " + baseComment;
        if (!name.isEmpty()) {
            preComment = preComment + " (" + name + ")";
        }
        this.comments.addPreComment(startAddress, preComment);
        String postComment = indent + "PDB: Block End, " + baseComment;
        Address endAddress = startAddress.add(length <= 0L ? 0L : length - 1L);
        this.comments.addPostComment(endAddress, postComment);
    }

    private int beginBlock(Address startAddress) {
        this.currentBlockAddress = startAddress;
        ++this.symbolBlockNestingLevel;
        return this.symbolBlockNestingLevel;
    }

    private String getIndent(int indentLevel) {
        Object indent = "";
        for (int i = 1; i < indentLevel; ++i) {
            indent = (String)indent + BLOCK_INDENT;
        }
        return indent;
    }

    private int getFrameBaseOffset(TaskMonitor monitor) throws CancelledException {
        int retAddrSize = this.function.getProgram().getDefaultPointerSize();
        if (retAddrSize != 8) {
            return -retAddrSize;
        }
        Register frameReg = this.function.getProgram().getCompilerSpec().getStackPointer();
        Address entryAddr = this.function.getEntryPoint();
        AddressSet scopeSet = new AddressSet();
        scopeSet.addRange(entryAddr, entryAddr.add(64L));
        CallDepthChangeInfo valueChange = new CallDepthChangeInfo(this.function, (AddressSetView)scopeSet, frameReg, monitor);
        InstructionIterator instructions = this.function.getProgram().getListing().getInstructions((AddressSetView)scopeSet, true);
        int max = 0;
        while (instructions.hasNext()) {
            monitor.checkCancelled();
            Instruction next = instructions.next();
            int newValue = valueChange.getDepth(next.getMinAddress());
            if (newValue < -20480 || newValue > 20480 || Math.abs(newValue) <= Math.abs(max)) continue;
            max = newValue;
        }
        return max;
    }

    @Override
    public void doDeferredProcessing() {
    }

    @Override
    public Address getAddress() {
        return this.address;
    }

    private static class RegisterChangeCalculator {
        private Map<Register, Integer> registerChangeByRegisterName = new HashMap<Register, Integer>();
        private CallDepthChangeInfo callDepthChangeInfo;
        private Address debugStart;

        private RegisterChangeCalculator(AbstractManagedProcedureMsSymbol procedureSymbol, Function function, TaskMonitor monitor) throws CancelledException {
            this.callDepthChangeInfo = this.createCallDepthChangInfo(procedureSymbol, function, monitor);
        }

        private CallDepthChangeInfo createCallDepthChangInfo(AbstractManagedProcedureMsSymbol procedureSymbol, Function function, TaskMonitor monitor) throws CancelledException {
            if (procedureSymbol == null) {
                return null;
            }
            Register frameReg = function.getProgram().getCompilerSpec().getStackPointer();
            Address entryAddr = function.getEntryPoint();
            this.debugStart = entryAddr.add(procedureSymbol.getDebugStartOffset());
            AddressSet scopeSet = new AddressSet();
            scopeSet.addRange(entryAddr, this.debugStart);
            return new CallDepthChangeInfo(function, (AddressSetView)scopeSet, frameReg, monitor);
        }

        Integer getRegChange(DefaultPdbApplicator applicator, Register register) {
            if (this.callDepthChangeInfo == null || register == null) {
                return null;
            }
            Integer change = this.registerChangeByRegisterName.get(register);
            if (change != null) {
                return change;
            }
            change = this.callDepthChangeInfo.getRegDepth(this.debugStart, register);
            this.registerChangeByRegisterName.put(register, change);
            return change;
        }
    }
}

