/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractChangeExecutionModelMsSymbol
extends AbstractMsSymbol {
    protected long offset;
    protected int segment;
    protected int modelVal;
    protected Model model;
    protected long offsetToPcodeFunctionTable;
    protected long offsetToSegmentPcodeInformation;
    protected int subtype;
    protected int flag;
    protected long offsetToFunctionTable;
    protected int segmentOfFunctionTable;

    public AbstractChangeExecutionModelMsSymbol(AbstractPdb pdb, PdbByteReader reader, int offsetSize) throws PdbException {
        super(pdb, reader);
        this.offset = reader.parseVarSizedOffset(offsetSize);
        this.segment = pdb.parseSegment(reader);
        this.modelVal = reader.parseUnsignedShortVal();
        this.model = Model.fromValue(this.modelVal);
    }

    @Override
    public void emit(StringBuilder builder) {
        builder.append(String.format("%s:\n   segment, offset = %04X:%08X, model = ", this.getSymbolTypeName(), this.segment, this.offset));
        builder.append((Object)this.model);
        block0 : switch (this.model) {
            case COBOL: {
                builder.append("\n");
                switch (this.subtype) {
                    case 0: {
                        builder.append("   don't stop until next execution model\n");
                        break block0;
                    }
                    case 1: {
                        builder.append("   inter-segment perform - treat as single call instruction\n");
                        break block0;
                    }
                    case 2: {
                        builder.append("   false call - step into even with F10\n");
                        break block0;
                    }
                    case 3: {
                        builder.append(String.format("   call to EXTCALL - step into %d call levels\n", this.flag));
                        break block0;
                    }
                }
                builder.append(String.format("   UNKNOWN COBOL CONTROL 0x%04X\n", this.subtype));
                break;
            }
            case PCODE: {
                builder.append("\n");
                builder.append(String.format("offsetToPcodeFunctionTable = %08X, offsetToSegmentPcodeInformation = %08X\n", this.offsetToPcodeFunctionTable, this.offsetToSegmentPcodeInformation));
                break;
            }
            case PCODE32MACINTOSH: {
                builder.append(String.format("callTable = %08X, segment = %08X\n", this.offsetToFunctionTable, this.segmentOfFunctionTable));
                break;
            }
            case PCODE32MACINTOSH_NATIVE_ENTRY_POINT: {
                builder.append(String.format("callTable = %08X, segment = %08X\n", this.offsetToFunctionTable, this.segmentOfFunctionTable));
                break;
            }
            case UNKNOWN: {
                builder.append(String.format(" = %04X\n", this.modelVal));
                break;
            }
        }
    }

    public static enum Model {
        TABLE("DATA", 0),
        JUMPTABLE("JUMPTABLE", 1),
        DATAPAD("DATAPAD", 2),
        NATIVE("NATIVE", 32),
        COBOL("COBOL", 33),
        CODEPAD("CODEPAD", 34),
        CODE("CODE", 35),
        SQL("SQL", 48),
        PCODE("PCODE", 64),
        PCODE32MACINTOSH("PCODE for the Mac", 65),
        PCODE32MACINTOSH_NATIVE_ENTRY_POINT("PCODE for the Mac (Native Entry Point)", 66),
        JAVAINT("JAVAINT", 80),
        UNKNOWN("UNKNOWN MODEL", 255);

        private static final Map<Integer, Model> BY_VALUE;
        public final String label;
        public final int value;

        public String toString() {
            return this.label;
        }

        public static Model fromValue(int val) {
            return BY_VALUE.getOrDefault(val, UNKNOWN);
        }

        private Model(String label, int value) {
            this.label = label;
            this.value = value;
        }

        static {
            BY_VALUE = new HashMap<Integer, Model>();
            for (Model val : Model.values()) {
                BY_VALUE.put(val.value, val);
            }
        }
    }
}

