/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbLog;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordCategory;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.TPI;
import ghidra.app.util.bin.format.pdb2.pdbreader.TypeParser;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.BadMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.PrimitiveMsType;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class TypeProgramInterface
implements TPI {
    public static final int STREAM_NUMBER_SIZE = 2;
    protected static final int VERSION_NUMBER_SIZE = 4;
    protected static final int HEADER_LENGTH_SIZE = 4;
    protected static final int TYPE_INDEX_SIZE = 4;
    protected static final int TYPE_INDEX16_SIZE = 2;
    protected static final int DATA_LENGTH_SIZE = 4;
    protected AbstractPdb pdb;
    protected RecordCategory recordCategory;
    private int streamNumber;
    protected int headerLength;
    protected int typeIndexMin;
    protected int typeIndexMaxExclusive;
    protected int dataLength;
    protected TypeProgramInterfaceHash hash;
    protected Map<Integer, PrimitiveMsType> primitiveTypesByRecordNumber = new HashMap<Integer, PrimitiveMsType>();
    protected List<AbstractMsType> typeList = new ArrayList<AbstractMsType>();
    protected int versionNumber = 0;
    private List<OffLen> offLenRecords;

    public TypeProgramInterface(AbstractPdb pdb, RecordCategory recordCategory, int streamNumber) {
        Objects.requireNonNull(pdb, "pdb cannot be null");
        this.pdb = pdb;
        this.recordCategory = recordCategory;
        this.streamNumber = streamNumber;
        this.hash = new TypeProgramInterfaceHash();
    }

    static int getVersionNumberSize() {
        return 4;
    }

    static int deserializeVersionNumber(PdbByteReader reader) throws PdbException {
        return reader.parseInt();
    }

    @Override
    public int getTypeIndexMin() {
        return this.typeIndexMin;
    }

    @Override
    public int getTypeIndexMaxExclusive() {
        return this.typeIndexMaxExclusive;
    }

    @Override
    public AbstractMsType getRecord(int recordNumber) {
        if (recordNumber < 0 || recordNumber - this.typeIndexMin > this.typeList.size()) {
            PdbLog.logBadTypeRecordIndex(this, recordNumber);
            BadMsType type = new BadMsType(this.pdb, 0);
            type.setRecordNumber(RecordNumber.make(this.recordCategory, recordNumber));
            return type;
        }
        if (recordNumber < this.typeIndexMin) {
            PrimitiveMsType primitive = this.primitiveTypesByRecordNumber.get(recordNumber);
            if (primitive == null) {
                primitive = new PrimitiveMsType(this.pdb, recordNumber);
                this.primitiveTypesByRecordNumber.put(recordNumber, primitive);
            }
            return primitive;
        }
        return this.typeList.get(recordNumber - this.typeIndexMin);
    }

    @Override
    public AbstractMsType getRandomAccessRecord(int recordNumber) {
        if (recordNumber < 0 || recordNumber - this.typeIndexMin > this.typeList.size()) {
            PdbLog.logBadTypeRecordIndex(this, recordNumber);
            BadMsType type = new BadMsType(this.pdb, 0);
            type.setRecordNumber(RecordNumber.make(this.recordCategory, recordNumber));
            return type;
        }
        if (recordNumber < this.typeIndexMin) {
            PrimitiveMsType primitive = this.primitiveTypesByRecordNumber.get(recordNumber);
            if (primitive == null) {
                primitive = new PrimitiveMsType(this.pdb, recordNumber);
                this.primitiveTypesByRecordNumber.put(recordNumber, primitive);
            }
            return primitive;
        }
        RecordNumber rn = RecordNumber.make(this.recordCategory, recordNumber);
        OffLen offLen = this.offLenRecords.get(recordNumber - this.typeIndexMin);
        try {
            PdbByteReader recordReader = this.pdb.getReaderForStreamNumber(this.streamNumber, offLen.offset(), offLen.length());
            return TypeParser.parseRecord(this.pdb, recordReader, rn);
        }
        catch (PdbException | CancelledException | IOException e) {
            BadMsType badType = new BadMsType(this.pdb, 0);
            badType.setRecordNumber(RecordNumber.make(this.recordCategory, recordNumber));
            return badType;
        }
    }

    int deserialize() throws IOException, PdbException, CancelledException {
        if (this.pdb.getMsf() == null) {
            throw new PdbException("Unexpected null MSF.");
        }
        PdbByteReader reader = this.pdb.getReaderForStreamNumber(this.streamNumber);
        this.deserializeHeader(reader);
        this.createOffLenRecords(reader);
        this.deserializeTypeRecords(reader);
        return this.versionNumber;
    }

    void dump(Writer writer) throws IOException {
        writer.write("TypeProgramInterfaceHeader----------------------------------\n");
        this.dumpHeader(writer);
        writer.write("\nEnd TypeProgramInterfaceHeader------------------------------\n");
        writer.write("TypeProgramInterfaceRecords---------------------------------\n");
        this.dumpTypeRecords(writer);
        writer.write("\nEnd TypeProgramInterfaceRecords-----------------------------\n");
    }

    TypeProgramInterface(AbstractPdb pdb, int typeIndexMin, int typeIndexMaxExclusive) {
        Objects.requireNonNull(pdb, "pdb cannot be null");
        this.pdb = pdb;
        this.typeIndexMin = typeIndexMin;
        this.typeIndexMaxExclusive = typeIndexMaxExclusive;
    }

    boolean setRecord(int recordNumber, AbstractMsType type) {
        if (recordNumber < this.typeIndexMin) {
            return false;
        }
        for (int i = this.typeList.size() + this.typeIndexMin; i <= recordNumber; ++i) {
            this.typeList.add(type);
        }
        return true;
    }

    int addRecord(AbstractMsType type) {
        int newRecordNum = this.typeList.size() + this.typeIndexMin;
        this.typeList.add(type);
        return newRecordNum;
    }

    protected abstract void deserializeHeader(PdbByteReader var1) throws PdbException;

    protected abstract void dumpHeader(Writer var1) throws IOException;

    private void createOffLenRecords(PdbByteReader reader) throws PdbException, CancelledException {
        int savedIndex = reader.getIndex();
        this.offLenRecords = new ArrayList<OffLen>();
        while (reader.hasMore()) {
            this.pdb.checkCancelled();
            int recordLength = reader.parseUnsignedShortVal();
            int offset = reader.getIndex();
            reader.skip(recordLength);
            this.offLenRecords.add(new OffLen(offset, recordLength));
        }
        reader.setIndex(savedIndex);
    }

    protected void deserializeTypeRecords(PdbByteReader reader) throws PdbException, CancelledException {
        int recordNumber = this.typeIndexMin;
        while (reader.hasMore()) {
            this.pdb.checkCancelled();
            int recordLength = reader.parseUnsignedShortVal();
            PdbByteReader recordReader = reader.getSubPdbByteReader(recordLength);
            recordReader.markAlign(2);
            AbstractMsType type = TypeParser.parseRecord(this.pdb, recordReader, RecordNumber.make(this.recordCategory, recordNumber));
            this.typeList.add(type);
            ++recordNumber;
        }
        if (recordNumber != this.typeIndexMaxExclusive) {
            PdbLog.message(this.getClass().getSimpleName() + ": Header max records: " + this.typeIndexMaxExclusive + "; parsed records: " + recordNumber);
        }
    }

    protected void dumpTypeRecords(Writer writer) throws IOException {
        int recordNum = this.typeIndexMin;
        for (AbstractMsType type : this.typeList) {
            StringBuilder builder = new StringBuilder();
            builder.append("------------------------------------------------------------\n");
            builder.append("Record: ");
            builder.append(recordNum);
            builder.append("\n");
            if (type != null) {
                builder.append(type.getClass().getSimpleName());
                builder.append("\n");
                builder.append(type.toString());
                builder.append("\n");
            } else {
                builder.append("(null)\n");
            }
            writer.write(builder.toString());
            ++recordNum;
        }
    }

    protected class TypeProgramInterfaceHash {
        int hashStreamNumber;
        int hashStreamNumberAuxiliary;
        int hashKeySize;
        int numHashBins;
        int offsetHashVals;
        int lengthHashVals;
        int offsetTypeIndexOffsetPairs;
        int lengthTypeIndexOffsetPairs;
        int offsetHashAdjustment;
        int lengthHashAdjustment;
        private List<TiOff> tiOffs = new ArrayList<TiOff>();

        protected TypeProgramInterfaceHash() {
        }

        protected void deserializeHeader800(PdbByteReader reader) throws PdbException {
            this.hashStreamNumber = reader.parseUnsignedShortVal();
            this.hashStreamNumberAuxiliary = reader.parseUnsignedShortVal();
            this.hashKeySize = reader.parseInt();
            this.numHashBins = reader.parseInt();
            this.offsetHashVals = reader.parseInt();
            this.lengthHashVals = reader.parseInt();
            this.offsetTypeIndexOffsetPairs = reader.parseInt();
            this.lengthTypeIndexOffsetPairs = reader.parseInt();
            this.offsetHashAdjustment = reader.parseInt();
            this.lengthHashAdjustment = reader.parseInt();
        }

        protected void initHeader200500(int hashStreamNumberParam, int typeIndexMinParam, int typeIndexMaxExclusiveParam) throws PdbException {
            this.hashStreamNumber = hashStreamNumberParam;
            this.hashStreamNumberAuxiliary = 65535;
            this.hashKeySize = 2;
            this.numHashBins = 4096;
            this.offsetHashVals = 0;
            this.offsetTypeIndexOffsetPairs = this.lengthHashVals = (typeIndexMaxExclusiveParam - typeIndexMinParam) * this.hashKeySize;
            this.lengthTypeIndexOffsetPairs = -1;
            this.offsetHashAdjustment = 0;
            this.lengthHashAdjustment = -1;
        }

        protected void deserializeHashStreams(TaskMonitor monitor) throws IOException, PdbException, CancelledException {
            if (this.hashStreamNumber == 65535) {
                return;
            }
            PdbByteReader reader = TypeProgramInterface.this.pdb.getReaderForStreamNumber(this.hashStreamNumber);
            reader.setIndex(this.offsetHashVals);
            PdbByteReader hashValsReader = reader.getSubPdbByteReader(this.lengthHashVals);
            reader.setIndex(this.offsetTypeIndexOffsetPairs);
            PdbByteReader typeInfoOffsetPairsReader = reader.getSubPdbByteReader(this.lengthTypeIndexOffsetPairs);
            reader.setIndex(this.offsetHashAdjustment);
            PdbByteReader hashAdjustmentReader = reader.getSubPdbByteReader(this.lengthHashAdjustment);
            this.deserializeHashAdjustment(hashAdjustmentReader, monitor);
            this.deserializeTypeIndexOffsetPairs(typeInfoOffsetPairsReader, monitor);
            this.deserializeHashVals(hashValsReader, monitor);
            if (this.hashStreamNumberAuxiliary == 65535) {
                return;
            }
            PdbByteReader readerAuxiliary = TypeProgramInterface.this.pdb.getReaderForStreamNumber(this.hashStreamNumberAuxiliary);
        }

        private void deserializeHashVals(PdbByteReader reader, TaskMonitor monitor) throws PdbException, CancelledException {
            if (this.hashKeySize == 2) {
                for (int index = TypeProgramInterface.this.typeIndexMin; index < TypeProgramInterface.this.typeIndexMaxExclusive; ++index) {
                    monitor.checkCancelled();
                    long hashVal = reader.parseUnsignedShortVal();
                    if (hashVal >= 0L && hashVal < (long)this.numHashBins) continue;
                    throw new PdbException("Bad hashVal: " + hashVal);
                }
            } else if (this.hashKeySize == 4) {
                for (int index = TypeProgramInterface.this.typeIndexMin; index < TypeProgramInterface.this.typeIndexMaxExclusive; ++index) {
                    monitor.checkCancelled();
                    long hashVal = reader.parseUnsignedIntVal();
                    if (hashVal >= 0L && hashVal < (long)this.numHashBins) continue;
                    throw new PdbException("Bad hashVal: " + hashVal);
                }
            } else {
                throw new PdbException("Bad hashKeySize: " + this.hashKeySize);
            }
        }

        private void deserializeTypeIndexOffsetPairs(PdbByteReader reader, TaskMonitor monitor) throws PdbException, CancelledException {
            int numPairs = this.lengthTypeIndexOffsetPairs / 8;
            if (numPairs * 8 != this.lengthTypeIndexOffsetPairs) {
                throw new PdbException("Corruption in Length of Type Index Pairs;");
            }
            long previousTypeIndex = -1L;
            for (int i = 0; i < numPairs; ++i) {
                monitor.checkCancelled();
                TiOff32 tiOff = new TiOff32(reader);
                if ((long)tiOff.getTypeIndex() <= previousTypeIndex) {
                    throw new PdbException("Corruption in TypeIndex/Offset pairs: out of order");
                }
                previousTypeIndex = tiOff.getTypeIndex();
                this.tiOffs.add(tiOff);
            }
        }

        private void initTypeIndexToRec200400(PdbByteReader reader, TaskMonitor monitor) {
        }

        protected long getOffsetForTypeIndex(int typeIndex) {
            int retVal = Collections.binarySearch(this.tiOffs, new KeyTiOff(typeIndex));
            if (retVal < 0) {
                retVal = -retVal - 1;
            }
            long baseIndex = this.tiOffs.get(retVal).getOffset();
            return 0L;
        }

        private void deserializeHashAdjustment(PdbByteReader reader, TaskMonitor monitor) {
        }

        protected String dump() {
            StringBuilder builder = new StringBuilder();
            builder.append("Hash--------------------------------------------------------");
            builder.append("\nhashStreamNumber: ");
            builder.append(this.hashStreamNumber);
            builder.append("\nhashStreamNumberAuxiliary: ");
            builder.append(this.hashStreamNumberAuxiliary);
            builder.append("\nhashKeySize: ");
            builder.append(this.hashKeySize);
            builder.append("\nnumHashBins: ");
            builder.append(this.numHashBins);
            builder.append("\noffsetHashVals: ");
            builder.append(this.offsetHashVals);
            builder.append("\nlengthHashVals: ");
            builder.append(this.lengthHashVals);
            builder.append("\noffsetTypeIndexOffsetPairs: ");
            builder.append(this.offsetTypeIndexOffsetPairs);
            builder.append("\nlengthTypeIndexOffsetPairs: ");
            builder.append(this.lengthTypeIndexOffsetPairs);
            builder.append("\noffsetHashAdjustment: ");
            builder.append(this.offsetHashAdjustment);
            builder.append("\nlengthHashAdjustment: ");
            builder.append(this.lengthHashAdjustment);
            return builder.toString();
        }
    }

    private record OffLen(int offset, int length) {
    }

    private class TiOff16
    extends TiOff {
        protected static final int size = 4;

        protected TiOff16(PdbByteReader reader) throws PdbException {
            super(reader);
        }

        @Override
        protected int getSize() {
            return 4;
        }

        @Override
        protected void parse(PdbByteReader reader) throws PdbException {
            this.typeIndex = reader.parseUnsignedShortVal();
            this.offset = reader.parseUnsignedShortVal();
        }
    }

    private class TiOff32
    extends TiOff {
        protected static final int size = 8;

        protected TiOff32(PdbByteReader reader) throws PdbException {
            super(reader);
        }

        @Override
        protected int getSize() {
            return 8;
        }

        @Override
        protected void parse(PdbByteReader reader) throws PdbException {
            this.typeIndex = reader.parseInt();
            this.offset = reader.parseInt();
        }
    }

    private class KeyTiOff
    extends TiOff {
        protected KeyTiOff(int typeIndex) {
            super(typeIndex);
        }

        @Override
        protected int getSize() {
            throw new AssertException("Invalid to use this method.");
        }

        @Override
        protected void parse(PdbByteReader reader) {
            throw new AssertException("Invalid to use this method.");
        }
    }

    private abstract class TiOff
    implements Comparable<TiOff> {
        protected int typeIndex;
        protected int offset;

        protected TiOff(PdbByteReader reader) throws PdbException {
            this.parse(reader);
        }

        protected TiOff(int typeIndex) {
            this.typeIndex = typeIndex;
            this.offset = 0;
        }

        protected int getTypeIndex() {
            return this.typeIndex;
        }

        protected int getOffset() {
            return this.offset;
        }

        @Override
        public int compareTo(TiOff o) {
            return this.typeIndex - o.typeIndex;
        }

        protected abstract void parse(PdbByteReader var1) throws PdbException;

        protected abstract int getSize();
    }
}

