/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.C13Section;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.util.Msg;
import ghidra.util.NumericUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class C13FileChecksums
extends C13Section {
    private List<FileChecksum> fileChecksums = new ArrayList<FileChecksum>();

    static C13FileChecksums parse(PdbByteReader reader, boolean ignore, TaskMonitor monitor) throws PdbException, CancelledException {
        return new C13FileChecksums(reader, ignore, monitor);
    }

    protected C13FileChecksums(PdbByteReader reader, boolean ignore, TaskMonitor monitor) throws CancelledException, PdbException {
        super(ignore);
        while (reader.numRemaining() >= FileChecksum.getBaseRecordSize()) {
            monitor.checkCancelled();
            FileChecksum fileChecksum = new FileChecksum(reader);
            this.fileChecksums.add(fileChecksum);
        }
        if (reader.hasMore()) {
            Msg.debug(C13FileChecksums.class, (Object)String.format("Num Extra C13FileChecksums bytes: %d", reader.numRemaining()));
        }
    }

    public List<FileChecksum> getFileChecksums() {
        return this.fileChecksums;
    }

    public String toString() {
        return String.format("%s: num checksums = %d", this.getClass().getSimpleName(), this.fileChecksums.size());
    }

    @Override
    void dump(Writer writer) throws IOException {
        writer.write("C13FileChecksums--------------------------------------------\n");
        for (FileChecksum checksum : this.fileChecksums) {
            writer.write(checksum.toString());
            writer.write(10);
        }
        writer.write("End C13FileChecksums----------------------------------------\n");
    }

    static class FileChecksum {
        private long offsetFilename;
        private int length;
        private int checksumTypeValue;
        private byte[] bytes;

        private static int getBaseRecordSize() {
            return 6;
        }

        FileChecksum(PdbByteReader reader) throws PdbException {
            this.offsetFilename = reader.parseUnsignedIntVal();
            this.length = reader.parseUnsignedByteVal();
            this.checksumTypeValue = reader.parseUnsignedByteVal();
            this.bytes = reader.parseBytes(this.length);
            reader.align4();
        }

        long getOffsetFilename() {
            return this.offsetFilename;
        }

        long getLength() {
            return this.length;
        }

        long getChecksumTypeValue() {
            return this.checksumTypeValue;
        }

        byte[] getChecsumBytes() {
            return this.bytes;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(String.format("0x%08x, 0x%02x %s(%02x): ", new Object[]{this.offsetFilename, this.length, ChecksumType.fromValue(this.checksumTypeValue), this.checksumTypeValue}));
            builder.append(NumericUtilities.convertBytesToString((byte[])this.bytes));
            return builder.toString();
        }
    }

    private static enum ChecksumType {
        UnknownChecksumType(-1),
        NoneChecksumType(0),
        Md5ChecksumType(1),
        Sha1ChecksumType(2),
        Sha256ChecksumType(3);

        private static final Map<Integer, ChecksumType> BY_VALUE;
        private final int value;

        public static ChecksumType fromValue(int val) {
            ChecksumType t = BY_VALUE.getOrDefault(val, UnknownChecksumType);
            if (t == UnknownChecksumType && val != ChecksumType.UnknownChecksumType.value) {
                Msg.warn(null, (Object)String.format("PDB: C13FileChecksum - Unknown checksum type %08x", val));
            }
            return t;
        }

        private ChecksumType(int value) {
            this.value = value;
        }

        static {
            BY_VALUE = new HashMap<Integer, ChecksumType>();
            for (ChecksumType val : ChecksumType.values()) {
                BY_VALUE.put(val.value, val);
            }
        }
    }
}

