/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.model.iface2;

import SWIG.SBTarget;
import agent.lldb.manager.LldbCause;
import agent.lldb.manager.LldbEventsListenerAdapter;
import agent.lldb.manager.breakpoint.LldbBreakpointType;
import agent.lldb.manager.impl.LldbManagerImpl;
import agent.lldb.model.iface2.LldbModelTargetObject;
import agent.lldb.model.impl.LldbModelTargetAbstractXpointSpec;
import ghidra.async.AsyncFence;
import ghidra.dbg.target.TargetBreakpointSpec;
import ghidra.dbg.target.TargetBreakpointSpecContainer;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.program.model.address.AddressRange;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

@TargetObjectSchemaInfo(name="BreakpointContainer", elements={@TargetElementType(type=LldbModelTargetAbstractXpointSpec.class)}, attributes={@TargetAttributeType(type=Void.class)}, canonicalContainer=true)
public interface LldbModelTargetBreakpointContainer
extends LldbModelTargetObject,
TargetBreakpointSpecContainer,
LldbEventsListenerAdapter {
    @Override
    public void breakpointCreated(Object var1, LldbCause var2);

    @Override
    public void breakpointModified(Object var1, LldbCause var2);

    @Override
    public void breakpointDeleted(Object var1, LldbCause var2);

    @Override
    public void breakpointHit(Object var1, LldbCause var2);

    default public CompletableFuture<Void> doPlaceBreakpoint(Set<TargetBreakpointSpec.TargetBreakpointKind> kinds, Function<LldbBreakpointType, CompletableFuture<?>> placer) {
        AsyncFence fence = new AsyncFence();
        if (kinds.contains(TargetBreakpointSpec.TargetBreakpointKind.READ) && kinds.contains(TargetBreakpointSpec.TargetBreakpointKind.WRITE)) {
            fence.include(placer.apply(LldbBreakpointType.ACCESS_WATCHPOINT));
        } else if (kinds.contains(TargetBreakpointSpec.TargetBreakpointKind.READ)) {
            fence.include(placer.apply(LldbBreakpointType.READ_WATCHPOINT));
        } else if (kinds.contains(TargetBreakpointSpec.TargetBreakpointKind.WRITE)) {
            fence.include(placer.apply(LldbBreakpointType.WRITE_WATCHPOINT));
        }
        if (kinds.contains(TargetBreakpointSpec.TargetBreakpointKind.HW_EXECUTE)) {
            fence.include(placer.apply(LldbBreakpointType.HW_BREAKPOINT));
        }
        if (kinds.contains(TargetBreakpointSpec.TargetBreakpointKind.SW_EXECUTE)) {
            fence.include(placer.apply(LldbBreakpointType.BREAKPOINT));
        }
        return this.getModel().gateFuture(fence.ready());
    }

    default public CompletableFuture<Void> placeBreakpoint(String expression, Set<TargetBreakpointSpec.TargetBreakpointKind> kinds) {
        LldbManagerImpl manager = this.getManager();
        return this.doPlaceBreakpoint(kinds, t -> manager.insertBreakpoint(expression, (LldbBreakpointType)((Object)t)));
    }

    default public CompletableFuture<Void> placeBreakpoint(AddressRange range, Set<TargetBreakpointSpec.TargetBreakpointKind> kinds) {
        LldbManagerImpl manager = this.getManager();
        long offset = range.getMinAddress().getOffset();
        int len = (int)range.getLength();
        return this.doPlaceBreakpoint(kinds, t -> manager.insertBreakpoint(offset, len, (LldbBreakpointType)((Object)t)));
    }

    public SBTarget getSession();
}

