/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main;

import docking.widgets.button.BrowseButton;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.filechooser.GhidraFileChooserMode;
import docking.widgets.label.GDLabel;
import docking.wizard.AbstractWizardJPanel;
import docking.wizard.WizardManager;
import ghidra.framework.GenericRunInfo;
import ghidra.framework.main.NewProjectPanelManager;
import ghidra.framework.model.ProjectLocator;
import ghidra.framework.preferences.Preferences;
import ghidra.util.HelpLocation;
import ghidra.util.NamingUtilities;
import ghidra.util.filechooser.GhidraFileChooserModel;
import ghidra.util.filechooser.GhidraFileFilter;
import ghidra.util.layout.VerticalLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

class SelectProjectPanel
extends AbstractWizardJPanel {
    private static String PROJECT_EXTENSION = ProjectLocator.getProjectExtension().substring(1);
    private JTextField projectNameField;
    private JTextField directoryField;
    private JButton browseButton;
    private ProjectLocator projectLocator;
    private NewProjectPanelManager panelManager;
    private DocumentListener docListener;

    public SelectProjectPanel(NewProjectPanelManager panelManager) {
        super((LayoutManager)new BorderLayout());
        this.panelManager = panelManager;
        this.buildMainPanel();
        this.setBorder(BorderFactory.createEmptyBorder(80, 80, 0, 80));
    }

    public String getTitle() {
        if (this.panelManager.isSharedProject()) {
            return "Select Local Project Location for Repository " + this.panelManager.getProjectRepositoryName();
        }
        return "Select Project Location";
    }

    public void initialize() {
        this.projectLocator = null;
        Document doc = this.projectNameField.getDocument();
        doc.removeDocumentListener(this.docListener);
        this.projectNameField.setText("");
        doc.addDocumentListener(this.docListener);
    }

    public boolean isValidInformation() {
        return this.projectLocator != null;
    }

    public HelpLocation getHelpLocation() {
        if (this.panelManager.isSharedProject()) {
            return new HelpLocation("FrontEndPlugin", "SelectProjectLocation");
        }
        return new HelpLocation("FrontEndPlugin", "CreateNonSharedProject");
    }

    ProjectLocator getProjectLocator() {
        return this.projectLocator;
    }

    void setProjectName(String projectName) {
        this.projectNameField.setText(projectName);
    }

    String getStatusMessage() {
        if (this.projectLocator == null) {
            return this.checkProjectFile(false);
        }
        return "";
    }

    private void buildMainPanel() {
        JPanel outerPanel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        outerPanel.setLayout(gbl);
        GDLabel dirLabel = new GDLabel("Project Directory:", 4);
        this.directoryField = new JTextField(25);
        this.directoryField.setName("Project Directory");
        String lastDirSelected = Preferences.getProperty((String)"LastNewProjectDirectory");
        if (lastDirSelected != null) {
            this.directoryField.setText(lastDirSelected);
        } else {
            File projectDirectory = new File(GenericRunInfo.getProjectsDirPath());
            this.directoryField.setText(projectDirectory.getAbsolutePath());
        }
        this.directoryField.setCaretPosition(this.directoryField.getText().length() - 1);
        GDLabel projectNameLabel = new GDLabel("Project Name:", 4);
        this.projectNameField = new JTextField(25);
        this.projectNameField.setName("Project Name");
        this.projectNameField.addActionListener(e -> this.setProjectFile());
        this.docListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                SelectProjectPanel.this.setProjectFile();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SelectProjectPanel.this.setProjectFile();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                SelectProjectPanel.this.setProjectFile();
            }
        };
        this.projectNameField.getDocument().addDocumentListener(this.docListener);
        this.directoryField.getDocument().addDocumentListener(this.docListener);
        this.browseButton = new BrowseButton();
        this.browseButton.addActionListener(e -> this.displayFileChooser());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 13;
        gbl.setConstraints((Component)dirLabel, gbc);
        outerPanel.add((Component)dirLabel);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.insets.left = 5;
        gbc.insets.bottom = 5;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbl.setConstraints(this.directoryField, gbc);
        outerPanel.add(this.directoryField);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.insets.left = 5;
        gbc.insets.bottom = 5;
        gbc.anchor = 13;
        gbl.setConstraints(this.browseButton, gbc);
        outerPanel.add(this.browseButton);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets.left = 5;
        gbc.insets.bottom = 5;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbl.setConstraints((Component)projectNameLabel, gbc);
        outerPanel.add((Component)projectNameLabel);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.insets.left = 5;
        gbc.insets.bottom = 5;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbl.setConstraints(this.projectNameField, gbc);
        outerPanel.add(this.projectNameField);
        JPanel p = new JPanel((LayoutManager)new VerticalLayout(5));
        p.add(outerPanel);
        this.add(p, "Center");
    }

    private void setProjectFile() {
        this.checkProjectFile(true);
    }

    private String checkProjectFile(boolean showMessage) {
        WizardManager wm = this.panelManager.getWizardManager();
        if (showMessage) {
            wm.setStatusMessage("");
        }
        this.projectLocator = null;
        ProjectLocator locator = null;
        String msg = null;
        String dir = this.directoryField.getText().trim();
        if (dir.length() == 0) {
            msg = "Please specify project directory";
        } else if (!new File(dir).isDirectory()) {
            msg = "Project directory does not exist.";
        } else {
            String projectName = this.projectNameField.getText().trim();
            if (projectName.endsWith(PROJECT_EXTENSION)) {
                projectName = projectName.substring(0, projectName.length() - PROJECT_EXTENSION.length());
            }
            if (!NamingUtilities.isValidProjectName((String)projectName)) {
                msg = "Please specify valid project name";
            } else {
                try {
                    locator = new ProjectLocator(dir, projectName);
                }
                catch (IllegalArgumentException e) {
                    msg = e.getMessage();
                }
            }
        }
        if (locator != null) {
            File parentDir = new File(dir);
            if (!parentDir.isDirectory()) {
                msg = "Please specify a Project Directory";
            } else if (locator.getMarkerFile().exists() || locator.getProjectDir().exists()) {
                msg = this.getProjectName("A project named " + locator.getName() + " already exists in " + parentDir.getAbsolutePath());
            } else {
                this.projectLocator = locator;
            }
        }
        wm.validityChanged();
        if (showMessage) {
            wm.setStatusMessage(msg);
        }
        return msg;
    }

    private void displayFileChooser() {
        GhidraFileChooser fileChooser = this.createFileChooser();
        fileChooser.setTitle("Select a Ghidra Project Directory");
        fileChooser.setApproveButtonText("Select Project Directory");
        fileChooser.setApproveButtonToolTipText("Select a Ghidra Project Directory");
        File file = fileChooser.getSelectedFile();
        if (file != null) {
            this.directoryField.setText(file.getAbsolutePath());
            WizardManager wm = this.panelManager.getWizardManager();
            wm.setStatusMessage("");
            wm.validityChanged();
            this.checkProjectFile(true);
        }
        fileChooser.dispose();
    }

    private String getProjectName(String name) {
        if (name.endsWith(PROJECT_EXTENSION)) {
            name = name.substring(0, name.indexOf(PROJECT_EXTENSION) - 1);
        }
        return name;
    }

    private GhidraFileChooser createFileChooser() {
        WizardManager wm = this.panelManager.getWizardManager();
        GhidraFileChooser fileChooser = new GhidraFileChooser((Component)wm.getComponent());
        File projectDirectory = new File(GenericRunInfo.getProjectsDirPath());
        String lastDirSelected = Preferences.getProperty((String)"LastNewProjectDirectory", null, (boolean)true);
        if (lastDirSelected != null) {
            projectDirectory = new File(lastDirSelected);
        }
        fileChooser.setFileSelectionMode(GhidraFileChooserMode.DIRECTORIES_ONLY);
        fileChooser.setFileFilter(new GhidraFileFilter(){

            public String getDescription() {
                return "All Directories";
            }

            public boolean accept(File f, GhidraFileChooserModel model) {
                return model.isDirectory(f) && !f.getName().endsWith(ProjectLocator.getProjectDirExtension());
            }
        });
        fileChooser.setCurrentDirectory(projectDirectory);
        return fileChooser;
    }
}

