/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.extension.datatype.finder;

import generic.io.NullPrintWriter;
import ghidra.util.Msg;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

class DtrfDbg {
    private static ByteArrayOutputStream debugBytes;
    private static PrintWriter debugWriter;
    private static List<String> clientFilters;

    DtrfDbg() {
    }

    static void enable() {
        debugBytes = new ByteArrayOutputStream();
        debugWriter = new PrintWriter(debugBytes);
    }

    private static void close() {
        debugWriter.close();
        debugWriter = new NullPrintWriter();
    }

    static void disable(boolean write) {
        if (!write) {
            DtrfDbg.close();
            return;
        }
        debugWriter.flush();
        String output = debugBytes.toString();
        if (!StringUtils.isBlank((CharSequence)output)) {
            Msg.debug(DtrfDbg.class, (Object)("\n\nFinal Debug:\n" + output));
        }
        DtrfDbg.close();
    }

    static void setClientToStringFilters(String ... filters) {
        clientFilters.clear();
        clientFilters.addAll(Arrays.asList(filters));
    }

    static void println(String s) {
        debugWriter.println(s);
    }

    static void println(Object client, String s) {
        if (!DtrfDbg.passesFilter(client)) {
            return;
        }
        debugWriter.println(s);
    }

    private static boolean passesFilter(Object client) {
        if (client == null || clientFilters.isEmpty()) {
            return true;
        }
        String asString = client.toString();
        return clientFilters.stream().anyMatch(s -> asString.contains((CharSequence)s));
    }

    static {
        debugWriter = new NullPrintWriter();
        clientFilters = new ArrayList<String>();
    }
}

