/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg;

import ghidra.dbg.DebuggerModelListener;
import ghidra.dbg.target.TargetObject;
import ghidra.util.Msg;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class AnnotatedDebuggerAttributeListener
implements DebuggerModelListener {
    private static final String ATTR_METHODS = "@" + AttributeCallback.class.getSimpleName() + "-annotated methods";
    private static final String PARAMS_ERR = ATTR_METHODS + " must accept 2 parameters: (TargetObject, T)";
    private static final Map<Class<? extends AnnotatedDebuggerAttributeListener>, Wiring> WIRINGS_BY_CLASS = new HashMap<Class<? extends AnnotatedDebuggerAttributeListener>, Wiring>();
    private final Wiring wiring = WIRINGS_BY_CLASS.computeIfAbsent(this.getClass(), cls -> new Wiring((Class<?>)cls, lookup));

    public AnnotatedDebuggerAttributeListener(MethodHandles.Lookup lookup) {
    }

    protected boolean checkFire(TargetObject object) {
        return true;
    }

    @Override
    public void attributesChanged(TargetObject object, Collection<String> removed, Map<String, ?> added) {
        if (!this.checkFire(object)) {
            return;
        }
        for (String string : removed) {
            this.wiring.fireChange(this, object, string, null);
        }
        for (Map.Entry entry : added.entrySet()) {
            this.wiring.fireChange(this, object, (String)entry.getKey(), entry.getValue());
        }
    }

    private static class Wiring {
        private final Map<String, Set<MethodHandle>> handles = new HashMap<String, Set<MethodHandle>>();

        private Wiring(Class<?> cls, MethodHandles.Lookup lookup) {
            try {
                this.collect(cls, lookup);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Lookup must have access " + ATTR_METHODS, e);
            }
        }

        private void collectFromClass(Class<?> cls, MethodHandles.Lookup lookup) throws IllegalAccessException {
            for (Method m : cls.getDeclaredMethods()) {
                AttributeCallback annot = m.getAnnotation(AttributeCallback.class);
                if (annot == null) continue;
                Parameter[] parameters = m.getParameters();
                if (parameters.length != 2) {
                    throw new IllegalArgumentException(PARAMS_ERR);
                }
                if (!parameters[0].getType().isAssignableFrom(TargetObject.class)) {
                    throw new IllegalArgumentException(PARAMS_ERR);
                }
                MethodHandle handle = lookup.unreflect(m);
                this.handles.computeIfAbsent(annot.value(), __ -> new HashSet()).add(handle);
            }
        }

        private void collect(Class<?> cls, MethodHandles.Lookup lookup) throws IllegalAccessException {
            this.collectFromClass(cls, lookup);
            Class<?> s = cls.getSuperclass();
            if (s != null) {
                this.collect(s, lookup);
            }
            for (Class<?> i : cls.getInterfaces()) {
                this.collect(i, lookup);
            }
        }

        private void fireChange(AnnotatedDebuggerAttributeListener l, TargetObject object, String name, Object value) {
            Set<MethodHandle> set = this.handles.get(name);
            if (set == null) {
                return;
            }
            for (MethodHandle h : set) {
                try {
                    h.invoke(l, object, value);
                }
                catch (Throwable e) {
                    Msg.error((Object)this, (Object)("Error invoking " + h + ": " + e));
                }
            }
        }
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    protected static @interface AttributeCallback {
        public String value();
    }
}

