/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.guest;

import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetRegister;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.util.PathMatcher;
import ghidra.dbg.util.PathPredicates;
import ghidra.dbg.util.PathUtils;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.trace.database.guest.DBTraceGuestPlatform;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.symbol.TraceLabelSymbol;
import ghidra.trace.model.symbol.TraceNamespaceSymbol;
import ghidra.trace.model.symbol.TraceNamespaceSymbolView;
import ghidra.trace.model.symbol.TraceSymbolManager;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.util.TraceRegisterUtils;
import ghidra.util.LockHold;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;

public interface InternalTracePlatform
extends TracePlatform {
    public static final String REG_MAP_BE = "__reg_map_be__";
    public static final String REG_MAP_LE = "__reg_map_le__";

    public static String regMap(Register register) {
        return register.isBigEndian() ? REG_MAP_BE : REG_MAP_LE;
    }

    public int getIntKey();

    public DBTraceGuestPlatform.DBTraceGuestLanguage getLanguageEntry();

    @Override
    default public AddressRange getConventionalRegisterRange(AddressSpace space, Register register) {
        AddressRange result = this.mapGuestToHost(TraceRegisterUtils.rangeForRegister(register));
        if (result == null) {
            throw new IllegalArgumentException("Register " + register + " is not mapped");
        }
        if (space == null) {
            return result;
        }
        if (register.getAddressSpace().isRegisterSpace()) {
            if (result.getAddressSpace() != space.getPhysicalSpace()) {
                throw new IllegalArgumentException("Register " + register + " does not map to space " + space + "'s physical space (" + space.getPhysicalSpace() + ")");
            }
            return new AddressRangeImpl(space.getOverlayAddress(result.getMinAddress()), space.getOverlayAddress(result.getMaxAddress()));
        }
        if (result.getAddressSpace() != space) {
            throw new IllegalArgumentException("Memory-mapped register " + register + " does not map to space " + space);
        }
        return result;
    }

    default public List<String> listRegNames(Register register) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        result.add(register.getName());
        result.add(register.getName().toUpperCase());
        result.add(register.getName().toLowerCase());
        for (String alias : register.getAliases()) {
            result.add(alias);
            result.add(alias.toUpperCase());
            result.add(alias.toLowerCase());
        }
        return List.copyOf(result);
    }

    @Override
    default public Collection<String> getConventionalRegisterObjectNames(Register register) {
        Address pmin = this.mapGuestToHost(register.getAddress());
        if (pmin == null) {
            return this.listRegNames(register);
        }
        TraceSymbolManager symbolManager = this.getTrace().getSymbolManager();
        TraceNamespaceSymbol nsRegMap = (TraceNamespaceSymbol)symbolManager.namespaces().getGlobalNamed(InternalTracePlatform.regMap(register));
        List<String> labels = symbolManager.labels().getAt(0L, null, pmin, false).stream().filter(s -> s.getParentNamespace() == nsRegMap).map(Symbol::getName).toList();
        if (!labels.isEmpty()) {
            return labels;
        }
        return this.listRegNames(register);
    }

    @Override
    default public PathMatcher getConventionalRegisterPath(TargetObjectSchema schema, List<String> path, Collection<String> names) {
        PathMatcher matcher = schema.searchFor(TargetRegister.class, path, true);
        if (matcher.isEmpty()) {
            return matcher;
        }
        PathMatcher result = new PathMatcher();
        for (String name : names) {
            result.addAll(matcher.applyKeys(PathPredicates.Align.RIGHT, List.of(name)));
        }
        return result;
    }

    @Override
    default public PathMatcher getConventionalRegisterPath(TargetObjectSchema schema, List<String> path, Register register) {
        return this.getConventionalRegisterPath(schema, path, this.getConventionalRegisterObjectNames(register));
    }

    @Override
    default public PathMatcher getConventionalRegisterPath(TraceObject container, Register register) {
        return this.getConventionalRegisterPath(container.getTargetSchema(), container.getCanonicalPath().getKeyList(), register);
    }

    @Override
    default public PathMatcher getConventionalRegisterPath(TargetObject container, Register register) {
        return this.getConventionalRegisterPath(container.getSchema(), (List<String>)container.getPath(), register);
    }

    @Override
    default public PathMatcher getConventionalRegisterPath(AddressSpace space, Register register) {
        List path = PathUtils.parse((String)space.getName());
        TargetObjectSchema rootSchema = this.getTrace().getObjectManager().getRootSchema();
        if (rootSchema == null) {
            return null;
        }
        TargetObjectSchema schema = rootSchema.getSuccessorSchema(path);
        return this.getConventionalRegisterPath(schema, (List<String>)path, register);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    default public TraceLabelSymbol addRegisterMapOverride(Register register, String objectName) {
        Address hostAddr = this.mapGuestToHost(register.getAddress());
        if (hostAddr == null) {
            throw new IllegalStateException("Given register is not mapped to the host, or it's not in the guest language");
        }
        try (LockHold hold = this.getTrace().lockWrite();){
            TraceLabelSymbol exists;
            TraceSymbolManager symbolManager = this.getTrace().getSymbolManager();
            TraceNamespaceSymbol globals = symbolManager.getGlobalNamespace();
            TraceNamespaceSymbolView namespaces = symbolManager.namespaces();
            String regMap = InternalTracePlatform.regMap(register);
            TraceNamespaceSymbol nsRegMap = (TraceNamespaceSymbol)namespaces.getGlobalNamed(regMap);
            if (nsRegMap == null) {
                nsRegMap = namespaces.add(regMap, globals, SourceType.USER_DEFINED);
            }
            if ((exists = (TraceLabelSymbol)symbolManager.labels().getChildWithNameAt(objectName, this.getIntKey(), null, hostAddr, nsRegMap)) != null) {
                TraceLabelSymbol traceLabelSymbol2 = exists;
                return traceLabelSymbol2;
            }
            TraceLabelSymbol traceLabelSymbol = symbolManager.labels().create(0L, null, hostAddr, objectName, nsRegMap, SourceType.USER_DEFINED);
            return traceLabelSymbol;
        }
        catch (DuplicateNameException | InvalidInputException e) {
            throw new AssertionError();
        }
    }

    default public AddressRange getRegistersRange() {
        Language language = this.getLanguage();
        AddressSpace regSpace = language.getAddressFactory().getRegisterSpace();
        AddressSetView regAddrs = language.getRegisterAddresses();
        AddressIterator minIt = regAddrs.getAddresses(regSpace.getMinAddress(), true);
        if (!minIt.hasNext()) {
            return null;
        }
        AddressIterator maxIt = regAddrs.getAddresses(regSpace.getMaxAddress(), false);
        return new AddressRangeImpl(minIt.next(), maxIt.next());
    }
}

