/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.guest;

import db.DBRecord;
import ghidra.app.util.PseudoInstruction;
import ghidra.lifecycle.Internal;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.InstructionBlock;
import ghidra.program.model.lang.InstructionSet;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.lang.LanguageService;
import ghidra.program.model.lang.ProcessorContext;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.mem.DumbMemBufferImpl;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.Memory;
import ghidra.program.util.DefaultLanguageService;
import ghidra.trace.database.DBTraceUtils;
import ghidra.trace.database.guest.DBTraceGuestPlatformMappedMemory;
import ghidra.trace.database.guest.DBTraceGuestPlatformMappedRange;
import ghidra.trace.database.guest.DBTracePlatformManager;
import ghidra.trace.database.guest.InternalTracePlatform;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.guest.TraceGuestPlatform;
import ghidra.trace.model.guest.TraceGuestPlatformMappedRange;
import ghidra.trace.util.OverlappingObjectIterator;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.trace.util.TraceChangeType;
import ghidra.util.LockHold;
import ghidra.util.database.DBAnnotatedObject;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBObjectColumn;
import ghidra.util.database.annot.DBAnnotatedColumn;
import ghidra.util.database.annot.DBAnnotatedField;
import ghidra.util.database.annot.DBAnnotatedObjectInfo;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import org.apache.commons.lang3.tuple.Pair;

@DBAnnotatedObjectInfo(version=0)
public class DBTraceGuestPlatform
extends DBAnnotatedObject
implements TraceGuestPlatform,
InternalTracePlatform {
    public static final String TABLE_NAME = "Platforms";
    static final String LANGKEY_COLUMN_NAME = "Lang";
    static final String CSPECID_COLUMN_NAME = "CSpec";
    @DBAnnotatedColumn(value="Lang")
    static DBObjectColumn LANGKEY_COLUMN;
    @DBAnnotatedColumn(value="CSpec")
    static DBObjectColumn CSPECID_COLUMN;
    @DBAnnotatedField(column="Lang")
    private int langKey;
    @DBAnnotatedField(column="CSpec", codec=DBTraceUtils.CompilerSpecIDDBFieldCodec.class)
    private CompilerSpecID cSpecID;
    private DBTraceGuestLanguage languageEntry;
    private CompilerSpec compilerSpec;
    final DBTracePlatformManager manager;
    protected final NavigableMap<Address, DBTraceGuestPlatformMappedRange> rangesByHostAddress = new TreeMap<Address, DBTraceGuestPlatformMappedRange>();
    protected final AddressSet hostAddressSet = new AddressSet();
    protected final NavigableMap<Address, DBTraceGuestPlatformMappedRange> rangesByGuestAddress = new TreeMap<Address, DBTraceGuestPlatformMappedRange>();
    protected final AddressSet guestAddressSet = new AddressSet();

    public DBTraceGuestPlatform(DBTracePlatformManager manager, DBCachedObjectStore<?> store, DBRecord record) {
        super(store, record);
        this.manager = manager;
    }

    void set(CompilerSpec compilerSpec) {
        this.languageEntry = this.manager.getOrCreateLanguage(compilerSpec.getLanguage());
        this.langKey = (int)(this.languageEntry == null ? -1L : this.languageEntry.getKey());
        this.cSpecID = compilerSpec.getCompilerSpecID();
        this.update(LANGKEY_COLUMN, CSPECID_COLUMN);
        this.compilerSpec = compilerSpec;
    }

    protected void fresh(boolean created) throws IOException {
        super.fresh(created);
        if (created) {
            return;
        }
        this.languageEntry = this.manager.getLanguageByKey(this.langKey);
        if (this.languageEntry == null && this.langKey != -1) {
            throw new IOException("Platform table is corrupt. Missing language " + this.langKey);
        }
        this.compilerSpec = this.getLanguage().getCompilerSpecByID(this.cSpecID);
        if (this.compilerSpec == null) {
            throw new IOException("Platform table is corrupt. Invalid compiler spec " + this.compilerSpec);
        }
    }

    @Override
    public Trace getTrace() {
        return this.manager.trace;
    }

    @Override
    public int getIntKey() {
        return (int)this.key;
    }

    @Override
    public boolean isGuest() {
        return true;
    }

    protected void deleteMappedRange(DBTraceGuestPlatformMappedRange range, TaskMonitor monitor) throws CancelledException {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            this.manager.trace.getCodeManager().clearPlatform(Lifespan.ALL, range.getHostRange(), this, monitor);
            this.manager.rangeMappingStore.delete((DBAnnotatedObject)range);
            AddressRange hostRange = range.getHostRange();
            AddressRange guestRange = range.getGuestRange();
            this.rangesByHostAddress.remove(hostRange.getMinAddress());
            this.rangesByGuestAddress.remove(guestRange.getMinAddress());
            this.hostAddressSet.delete(hostRange);
            this.guestAddressSet.delete(guestRange);
        }
        this.manager.trace.setChanged(new TraceChangeRecord<DBTraceGuestPlatform, Object>((TraceChangeType<DBTraceGuestPlatform, Object>)Trace.TracePlatformChangeType.MAPPING_DELETED, null, this, range, null));
    }

    @Override
    @Internal
    public DBTraceGuestLanguage getLanguageEntry() {
        return this.languageEntry;
    }

    @Override
    public Language getLanguage() {
        return this.languageEntry == null ? this.manager.baseLanguage : this.languageEntry.getLanguage();
    }

    @Override
    public CompilerSpec getCompilerSpec() {
        return this.compilerSpec;
    }

    @Override
    public void delete(TaskMonitor monitor) throws CancelledException {
        this.manager.deleteGuestPlatform(this, monitor);
    }

    @Override
    public DBTraceGuestPlatformMappedRange addMappedRange(Address hostStart, Address guestStart, long length) throws AddressOverflowException {
        DBTraceGuestPlatformMappedRange mappedRange;
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            Address hostEnd = hostStart.addWrap(length - 1L);
            if (this.hostAddressSet.intersects(hostStart, hostEnd)) {
                throw new IllegalArgumentException("Range overlaps existing host mapped range(s) for this guest language");
            }
            Address guestEnd = guestStart.addWrap(length - 1L);
            if (this.guestAddressSet.intersects(guestStart, guestEnd)) {
                throw new IllegalArgumentException("Range overlaps existing guest mapped range(s)");
            }
            mappedRange = (DBTraceGuestPlatformMappedRange)this.manager.rangeMappingStore.create();
            mappedRange.set(hostStart, this, guestStart, length);
            this.rangesByHostAddress.put(hostStart, mappedRange);
            this.rangesByGuestAddress.put(guestStart, mappedRange);
            this.hostAddressSet.add(mappedRange.getHostRange());
            this.guestAddressSet.add(mappedRange.getGuestRange());
        }
        this.manager.trace.setChanged(new TraceChangeRecord<DBTraceGuestPlatform, DBTraceGuestPlatformMappedRange>(Trace.TracePlatformChangeType.MAPPING_ADDED, null, this, null, mappedRange));
        return mappedRange;
    }

    protected Address computeNextRegisterMin() {
        Address regMax = this.manager.hostPlatform.getLanguage().getAddressFactory().getRegisterSpace().getMaxAddress();
        AddressRangeIterator rit = this.hostAddressSet.getAddressRanges(regMax, false);
        if (!rit.hasNext()) {
            return null;
        }
        AddressRange next = (AddressRange)rit.next();
        if (!next.getAddressSpace().isRegisterSpace()) {
            return null;
        }
        return next.getMaxAddress().add(1L);
    }

    @Override
    public TraceGuestPlatformMappedRange addMappedRegisterRange() throws AddressOverflowException {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            AddressRange guestRange = this.getRegistersRange();
            if (guestRange == null) {
                TraceGuestPlatformMappedRange traceGuestPlatformMappedRange = null;
                return traceGuestPlatformMappedRange;
            }
            Address hostMin = this.manager.computeNextRegisterMin();
            long size = guestRange.getLength();
            DBTraceGuestPlatformMappedRange dBTraceGuestPlatformMappedRange = this.addMappedRange(hostMin, guestRange.getMinAddress(), size);
            return dBTraceGuestPlatformMappedRange;
        }
    }

    @Override
    public AddressSetView getHostAddressSet() {
        return new AddressSet((AddressSetView)this.hostAddressSet);
    }

    @Override
    public AddressSetView getGuestAddressSet() {
        return new AddressSet((AddressSetView)this.guestAddressSet);
    }

    @Override
    public Address mapHostToGuest(Address hostAddress) {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            Map.Entry<Address, DBTraceGuestPlatformMappedRange> floorEntry = this.rangesByHostAddress.floorEntry(hostAddress);
            if (floorEntry == null) {
                Address address = null;
                return address;
            }
            Address address = floorEntry.getValue().mapHostToGuest(hostAddress);
            return address;
        }
    }

    @Override
    public AddressRange mapHostToGuest(AddressRange hostRange) {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            Map.Entry<Address, DBTraceGuestPlatformMappedRange> floorEntry = this.rangesByHostAddress.floorEntry(hostRange.getMinAddress());
            if (floorEntry == null) {
                AddressRange addressRange = null;
                return addressRange;
            }
            AddressRange addressRange = floorEntry.getValue().mapHostToGuest(hostRange);
            return addressRange;
        }
    }

    @Override
    public AddressSetView mapHostToGuest(AddressSetView hostSet) {
        OverlappingObjectIterator<DBTraceGuestPlatformMappedRange, AddressRange> it = new OverlappingObjectIterator<DBTraceGuestPlatformMappedRange, AddressRange>(this.rangesByHostAddress.values().iterator(), MappedRangeRanger.HOST, hostSet.iterator(), OverlappingObjectIterator.ADDRESS_RANGE);
        AddressSet result = new AddressSet();
        while (it.hasNext()) {
            Pair next = (Pair)it.next();
            DBTraceGuestPlatformMappedRange entry = (DBTraceGuestPlatformMappedRange)next.getLeft();
            AddressRange hostRange = (AddressRange)next.getRight();
            result.add(entry.mapHostToGuest(hostRange));
        }
        return result;
    }

    @Override
    public Address mapGuestToHost(Address guestAddress) {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            Map.Entry<Address, DBTraceGuestPlatformMappedRange> floorEntry = this.rangesByGuestAddress.floorEntry(guestAddress);
            if (floorEntry == null) {
                Address address = null;
                return address;
            }
            Address address = floorEntry.getValue().mapGuestToHost(guestAddress);
            return address;
        }
    }

    @Override
    public AddressRange mapGuestToHost(AddressRange guestRange) {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            Map.Entry<Address, DBTraceGuestPlatformMappedRange> floorEntry = this.rangesByGuestAddress.floorEntry(guestRange.getMinAddress());
            if (floorEntry == null) {
                AddressRange addressRange = null;
                return addressRange;
            }
            AddressRange addressRange = floorEntry.getValue().mapGuestToHost(guestRange);
            return addressRange;
        }
    }

    @Override
    public AddressSetView mapGuestToHost(AddressSetView guestSet) {
        OverlappingObjectIterator<DBTraceGuestPlatformMappedRange, AddressRange> it = new OverlappingObjectIterator<DBTraceGuestPlatformMappedRange, AddressRange>(this.rangesByGuestAddress.values().iterator(), MappedRangeRanger.GUEST, guestSet.iterator(), OverlappingObjectIterator.ADDRESS_RANGE);
        AddressSet result = new AddressSet();
        while (it.hasNext()) {
            Pair next = (Pair)it.next();
            DBTraceGuestPlatformMappedRange entry = (DBTraceGuestPlatformMappedRange)next.getLeft();
            AddressRange hostRange = (AddressRange)next.getRight();
            result.add(entry.mapGuestToHost(hostRange));
        }
        return result;
    }

    public Address mapGuestToHost(Address guestMin, Address guestMax) {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            Map.Entry<Address, DBTraceGuestPlatformMappedRange> floorEntry = this.rangesByGuestAddress.floorEntry(guestMin);
            if (floorEntry == null) {
                Address address = null;
                return address;
            }
            DBTraceGuestPlatformMappedRange range = floorEntry.getValue();
            if (!range.getGuestRange().contains(guestMax)) {
                Address address = null;
                return address;
            }
            Address address = range.mapGuestToHost(guestMin);
            return address;
        }
    }

    @Override
    public MemBuffer getMappedMemBuffer(long snap, Address guestAddress) {
        return new DumbMemBufferImpl((Memory)new DBTraceGuestPlatformMappedMemory(this.manager.trace.getMemoryManager(), this, snap), guestAddress);
    }

    @Override
    public InstructionSet mapGuestInstructionAddressesToHost(InstructionSet instructionSet) {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            HashMap<Address, InstructionBlock> blocksByNext = new HashMap<Address, InstructionBlock>();
            InstructionSet mappedSet = new InstructionSet(this.getAddressFactory());
            for (InstructionBlock block : instructionSet) {
                for (Instruction instruction : block) {
                    PseudoInstruction mappedIntruction;
                    Address hostAddr = this.mapGuestToHost(instruction.getAddress(), instruction.getMaxAddress());
                    if (hostAddr == null) continue;
                    try {
                        mappedIntruction = new PseudoInstruction(hostAddr, instruction.getPrototype(), (MemBuffer)instruction, (ProcessorContext)instruction);
                    }
                    catch (AddressOverflowException e) {
                        throw new AssertionError((Object)e);
                    }
                    InstructionBlock addTo = (InstructionBlock)blocksByNext.remove(hostAddr);
                    if (addTo == null) {
                        addTo = new InstructionBlock(hostAddr);
                    }
                    addTo.addInstruction((Instruction)mappedIntruction);
                    Address next = addTo.getMaxAddress().next();
                    if (next == null) continue;
                    blocksByNext.put(next, addTo);
                }
            }
            blocksByNext.values().forEach(arg_0 -> ((InstructionSet)mappedSet).addBlock(arg_0));
            Iterator iterator = mappedSet;
            return iterator;
        }
    }

    @DBAnnotatedObjectInfo(version=0)
    public static class DBTraceGuestLanguage
    extends DBAnnotatedObject {
        public static final String TABLE_NAME = "Languages";
        static final String LANGID_COLUMN_NAME = "Lang";
        static final String VERSION_COLUMN_NAME = "Version";
        static final String MINOR_VERSION_COLUMN_NAME = "MinorVersion";
        @DBAnnotatedColumn(value="Lang")
        static DBObjectColumn LANGID_COLUMN;
        @DBAnnotatedColumn(value="Version")
        static DBObjectColumn VERSION_COLUMN;
        @DBAnnotatedColumn(value="MinorVersion")
        static DBObjectColumn MINOR_VERSION_COLUMN;
        @DBAnnotatedField(column="Lang", codec=DBTraceUtils.LanguageIDDBFieldCodec.class)
        private LanguageID langID;
        @DBAnnotatedField(column="Version")
        private int version;
        @DBAnnotatedField(column="MinorVersion")
        private int minorVersion;
        private Language language;

        public DBTraceGuestLanguage(DBCachedObjectStore<?> store, DBRecord record) {
            super(store, record);
        }

        protected void fresh(boolean created) throws IOException {
            super.fresh(created);
            if (created) {
                return;
            }
            LanguageService langServ = DefaultLanguageService.getLanguageService();
            this.language = langServ.getLanguage(this.langID);
            if (this.version != this.language.getVersion() || this.minorVersion != this.language.getMinorVersion()) {
                throw new IOException(new VersionException());
            }
        }

        void set(Language language) {
            this.langID = language.getLanguageID();
            this.version = language.getVersion();
            this.minorVersion = language.getMinorVersion();
            this.update(LANGID_COLUMN, VERSION_COLUMN, MINOR_VERSION_COLUMN);
            this.language = language;
        }

        public Language getLanguage() {
            return this.language;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum MappedRangeRanger implements OverlappingObjectIterator.Ranger<DBTraceGuestPlatformMappedRange>
    {
        HOST{

            @Override
            AddressRange getRange(DBTraceGuestPlatformMappedRange t) {
                return t.getHostRange();
            }
        }
        ,
        GUEST{

            @Override
            AddressRange getRange(DBTraceGuestPlatformMappedRange t) {
                return t.getGuestRange();
            }
        };


        abstract AddressRange getRange(DBTraceGuestPlatformMappedRange var1);

        @Override
        public Address getMinAddress(DBTraceGuestPlatformMappedRange t) {
            return this.getRange(t).getMinAddress();
        }

        @Override
        public Address getMaxAddress(DBTraceGuestPlatformMappedRange t) {
            return this.getRange(t).getMaxAddress();
        }
    }
}

