/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.GenericAddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.pcode.Varnode;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;

public class ValueLocation {
    private static final AddressSpace CONST = new GenericAddressSpace("const", 64, 0, 0);
    private final List<Varnode> nodes;

    public static String vnToString(Varnode vn, Language language) {
        Register register;
        Register register2 = register = language == null ? null : language.getRegister(vn.getAddress(), vn.getSize());
        if (register != null) {
            return String.format("%s:%d", register.getName(), vn.getSize());
        }
        return String.format("%s:%d", vn.getAddress(), vn.getSize());
    }

    private static boolean isZero(Varnode vn) {
        return vn.isConstant() && vn.getOffset() == 0L;
    }

    private static List<Varnode> removeLeading0s(List<Varnode> nodes) {
        for (int i = 0; i < nodes.size(); ++i) {
            if (ValueLocation.isZero(nodes.get(i))) continue;
            return nodes.subList(i, nodes.size());
        }
        return List.of();
    }

    public static ValueLocation fromConst(long value, int size) {
        return new ValueLocation(new Varnode(CONST.getAddress(value), size));
    }

    public static ValueLocation fromVarnode(Address address, int size) {
        return new ValueLocation(new Varnode(address, size));
    }

    public ValueLocation(Varnode ... nodes) {
        this.nodes = ValueLocation.removeLeading0s(List.of(nodes));
    }

    public ValueLocation(List<Varnode> nodes) {
        this.nodes = ValueLocation.removeLeading0s(List.copyOf(nodes));
    }

    public int nodeCount() {
        return this.nodes.size();
    }

    public Address getAddress() {
        return this.nodes.isEmpty() ? null : this.nodes.get(0).getAddress();
    }

    public String toString(Language language) {
        return this.nodes.stream().map(vn -> ValueLocation.vnToString(vn, language)).collect(Collectors.joining(","));
    }

    public String toString() {
        return this.toString(null);
    }

    public ValueLocation intOr(ValueLocation that) {
        if (this.isEmpty()) {
            return that;
        }
        if (that.isEmpty()) {
            return this;
        }
        ListIterator<Varnode> itA = this.nodes.listIterator(this.nodeCount());
        ListIterator<Varnode> itB = that.nodes.listIterator(that.nodeCount());
        Varnode[] result = new Varnode[Math.max(this.nodeCount(), that.nodeCount())];
        int i = result.length;
        while (itA.hasNext() && itB.hasPrevious()) {
            Varnode vnA = itA.previous();
            Varnode vnB = itB.previous();
            if (vnA.getSize() != vnB.getSize()) {
                return null;
            }
            if (ValueLocation.isZero(vnA)) {
                result[--i] = vnB;
                continue;
            }
            if (!ValueLocation.isZero(vnB)) continue;
            result[--i] = vnA;
        }
        while (itA.hasPrevious()) {
            result[--i] = itA.previous();
        }
        while (itB.hasPrevious()) {
            result[--i] = itB.previous();
        }
        return new ValueLocation(result);
    }

    public BigInteger getConst() {
        BigInteger result = BigInteger.ZERO;
        for (Varnode vn : this.nodes) {
            if (!vn.isConstant()) {
                return null;
            }
            result = result.shiftLeft(vn.getSize() * 8);
            result = result.or(vn.getAddress().getOffsetAsBigInteger());
        }
        return result;
    }

    public ValueLocation shiftLeft(int amount) {
        if (amount % 8 != 0) {
            return null;
        }
        ArrayList<Varnode> result = new ArrayList<Varnode>(this.nodes);
        result.add(new Varnode(CONST.getAddress(0L), amount / 8));
        return new ValueLocation(result);
    }

    public int size() {
        int result = 0;
        for (Varnode vn : this.nodes) {
            result += vn.getSize();
        }
        return result;
    }

    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }
}

