/*
 * Decompiled with CFR 0.152.
 */
package ghidra.sleigh.grammar;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TokenExtractor {
    private static Pattern P1 = Pattern.compile("^\\s*([A-Z_][A-Z_0-9]*)\\s*$");
    private static Pattern P2 = Pattern.compile("^\\s*([A-Z_][A-Z_0-9]*)\\s*;");
    private static Pattern P3 = Pattern.compile("^\\s*([A-Z_][A-Z_0-9]*)\\s*=");
    private static Pattern P4 = Pattern.compile("^\\s*([A-Z_][A-Z_0-9]*)\\s*:");

    public static void main(String[] args) {
        try {
            int numberParams = 4;
            File baseInPath = new File(args[0]);
            File baseOutPath = new File(args[1]);
            String packedge = args[2];
            String name = args[3];
            File outputFile = new File(baseOutPath, name + ".g");
            File[] inFiles = new File[args.length - 4];
            for (int ii = 0; ii < inFiles.length; ++ii) {
                inFiles[ii] = new File(baseInPath, args[ii + 4]);
            }
            HashSet<String> set = TokenExtractor.extract(inFiles);
            TokenExtractor.write(packedge, name, outputFile, set);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void write(String packedge, String name, File outputFile, HashSet<String> set) throws IOException {
        try (PrintWriter out = null;){
            if (!outputFile.getParentFile().exists()) {
                outputFile.getParentFile().mkdirs();
            }
            System.out.println("writing tokens to: " + outputFile.getCanonicalPath());
            out = new PrintWriter(outputFile);
            out.println("lexer grammar " + name + ";");
            if (packedge != null && !packedge.trim().equals("")) {
                out.println("@lexer::header{");
                out.println("package " + packedge + ";");
                out.println("}");
            }
            int ii = 4;
            for (String s : set) {
                out.format("%s: '%04d';", s, ii);
                out.println();
                ++ii;
            }
        }
    }

    private static void match(Matcher m, HashSet<String> set) {
        if (m.find()) {
            set.add(m.group(1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HashSet<String> extract(File[] inFiles) throws IOException {
        HashSet<String> result = new HashSet<String>();
        BufferedReader in = null;
        for (int ii = 0; ii < inFiles.length; ++ii) {
            System.out.println("extracting tokens from: " + inFiles[ii].getCanonicalPath());
            try {
                String line;
                in = new BufferedReader(new FileReader(inFiles[ii]));
                while ((line = in.readLine()) != null) {
                    TokenExtractor.match(P1.matcher(line), result);
                    TokenExtractor.match(P2.matcher(line), result);
                    TokenExtractor.match(P3.matcher(line), result);
                    TokenExtractor.match(P4.matcher(line), result);
                }
                continue;
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        return result;
    }
}

