/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.BlockMap;
import ghidra.program.model.pcode.Decoder;
import ghidra.program.model.pcode.DecoderException;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.Encoder;
import ghidra.program.model.pcode.ListLinked;
import ghidra.program.model.pcode.PcodeBlock;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.PcodeOpAST;
import java.io.IOException;
import java.util.Iterator;

public class PcodeBlockBasic
extends PcodeBlock {
    private ListLinked<PcodeOp> oplist;
    private AddressSet cover;

    PcodeBlockBasic() {
        this.blocktype = 1;
        this.oplist = new ListLinked();
        this.cover = new AddressSet();
    }

    @Override
    public Address getStart() {
        return this.cover.getMinAddress();
    }

    @Override
    public Address getStop() {
        return this.cover.getMaxAddress();
    }

    public boolean contains(Address addr) {
        return this.cover.contains(addr);
    }

    protected void insertBefore(Iterator<PcodeOp> iter, PcodeOp op) {
        PcodeOpAST opast = (PcodeOpAST)op;
        opast.setParent(this);
        Iterator<PcodeOp> newiter = this.oplist.insertBefore(iter, op);
        opast.setBasicIter(newiter);
    }

    protected void insertAfter(Iterator<PcodeOp> iter, PcodeOp op) {
        PcodeOpAST opast = (PcodeOpAST)op;
        opast.setParent(this);
        Iterator<PcodeOp> newiter = this.oplist.insertAfter(iter, opast);
        opast.setBasicIter(newiter);
    }

    protected void insertEnd(PcodeOp op) {
        PcodeOpAST opast = (PcodeOpAST)op;
        opast.setParent(this);
        Iterator<PcodeOp> newiter = this.oplist.add(opast);
        opast.setBasicIter(newiter);
    }

    protected void remove(PcodeOp op) {
        PcodeOpAST opast = (PcodeOpAST)op;
        opast.setParent(null);
        this.oplist.remove(op.getBasicIter());
    }

    public Iterator<PcodeOp> getIterator() {
        return this.oplist.iterator();
    }

    @Override
    protected void encodeBody(Encoder encoder) throws IOException {
        encoder.openElement(ElementId.ELEM_RANGELIST);
        AddressRangeIterator iter = this.cover.getAddressRanges(true);
        while (iter.hasNext()) {
            AddressRange range = (AddressRange)iter.next();
            encoder.openElement(ElementId.ELEM_RANGE);
            encoder.writeSpace(AttributeId.ATTRIB_SPACE, range.getAddressSpace());
            encoder.writeUnsignedInteger(AttributeId.ATTRIB_FIRST, range.getMinAddress().getOffset());
            encoder.writeUnsignedInteger(AttributeId.ATTRIB_LAST, range.getMaxAddress().getOffset());
        }
        encoder.closeElement(ElementId.ELEM_RANGELIST);
    }

    @Override
    protected void decodeBody(Decoder decoder, BlockMap resolver) throws DecoderException {
        int rangeel;
        int rangelistel = decoder.openElement(ElementId.ELEM_RANGELIST);
        while ((rangeel = decoder.peekElement()) == ElementId.ELEM_RANGE.id()) {
            decoder.openElement();
            AddressSpace addressSpace = decoder.readSpace(AttributeId.ATTRIB_SPACE);
            long offset = decoder.readUnsignedInteger(AttributeId.ATTRIB_FIRST);
            Address start = addressSpace.getAddress(offset);
            offset = decoder.readUnsignedInteger(AttributeId.ATTRIB_LAST);
            Address stop = addressSpace.getAddress(offset);
            this.cover.addRange(start, stop);
            decoder.closeElement(rangeel);
        }
        decoder.closeElement(rangelistel);
    }
}

