/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import java.util.Iterator;

public class ListLinked<T> {
    private LinkedNode terminal;

    ListLinked() {
        this.terminal.nextNode = this.terminal = new LinkedNode(null, null, null);
        this.terminal.previousNode = this.terminal;
    }

    public Iterator<T> add(T o) {
        LinkedNode newNode;
        this.terminal.previousNode.nextNode = newNode = new LinkedNode(this.terminal.previousNode, this.terminal, o);
        this.terminal.previousNode = newNode;
        LinkedIterator iter = new LinkedIterator(newNode);
        return iter;
    }

    public Iterator<T> insertAfter(Iterator<T> itr, T o) {
        LinkedNode newNode;
        LinkedNode cur = ((LinkedIterator)itr).curNode;
        cur.nextNode.previousNode = newNode = new LinkedNode(cur, cur.nextNode, o);
        cur.nextNode = newNode;
        return new LinkedIterator(newNode);
    }

    public Iterator<T> insertBefore(Iterator<T> itr, T o) {
        LinkedNode newNode;
        LinkedNode cur = ((LinkedIterator)itr).curNode;
        cur.previousNode.nextNode = newNode = new LinkedNode(cur.previousNode, cur, o);
        cur.previousNode = newNode;
        return new LinkedIterator(newNode);
    }

    public void remove(Iterator<T> itr) {
        LinkedNode cur = ((LinkedIterator)itr).curNode;
        if (cur.data == null) {
            return;
        }
        cur.previousNode.nextNode = cur.nextNode;
        cur.nextNode.previousNode = cur.previousNode;
    }

    public Iterator<T> iterator() {
        LinkedIterator iter = new LinkedIterator(this.terminal);
        return iter;
    }

    public void clear() {
        this.terminal.nextNode = this.terminal;
        this.terminal.previousNode = this.terminal;
    }

    private class LinkedNode {
        public LinkedNode previousNode;
        public LinkedNode nextNode;
        public T data;

        LinkedNode(LinkedNode prev, LinkedNode nxt, T d) {
            this.previousNode = prev;
            this.nextNode = nxt;
            this.data = d;
        }
    }

    private class LinkedIterator
    implements Iterator<T> {
        private LinkedNode curNode;

        public LinkedIterator(LinkedNode cur) {
            this.curNode = cur;
        }

        @Override
        public void remove() {
            if (this.curNode.data == null) {
                return;
            }
            this.curNode.nextNode.previousNode = this.curNode.previousNode;
            this.curNode.previousNode.nextNode = this.curNode.nextNode;
            this.curNode = this.curNode.previousNode;
        }

        @Override
        public boolean hasNext() {
            return this.curNode.nextNode.data != null;
        }

        @Override
        public T next() {
            this.curNode = this.curNode.nextNode;
            return this.curNode.data;
        }

        public boolean hasPrevious() {
            return this.curNode.data != null;
        }

        public Object previous() {
            this.curNode = this.curNode.previousNode;
            return this.curNode.nextNode.data;
        }
    }
}

