/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.program.model.data.DataType;
import ghidra.util.exception.UsrException;

public class DataTypeEncodeException
extends UsrException {
    private final Object value;
    private final DataType dt;

    private static String computeMessage(String message, Object value, DataType dt, Throwable cause) {
        if (cause != null) {
            String encodeError = "while encoding '" + value + "' for " + dt.getDisplayName();
            if (message != null) {
                return cause.getMessage() + " (" + encodeError + ": " + message + ")";
            }
            return cause.getMessage() + "(" + encodeError + ")";
        }
        String encodeError = "Cannot encode '" + value + "' for " + dt.getDisplayName();
        if (message != null) {
            return encodeError + ": " + message;
        }
        return encodeError;
    }

    public DataTypeEncodeException(String message, Object value, DataType dt) {
        this(message, value, dt, null);
    }

    public DataTypeEncodeException(String message, Object value, DataType dt, Throwable cause) {
        super(DataTypeEncodeException.computeMessage(message, value, dt, cause), cause);
        this.value = value;
        this.dt = dt;
    }

    public DataTypeEncodeException(Object value, DataType dt, Throwable cause) {
        this(null, value, dt, cause);
    }

    public Object getValue() {
        return this.value;
    }

    public DataType getDataType() {
        return this.dt;
    }
}

