/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.register;

import db.ByteField;
import db.DBHandle;
import db.Field;
import db.Table;
import db.util.ErrorHandler;
import ghidra.program.database.ManagerDB;
import ghidra.program.database.ProgramDB;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.register.InMemoryRangeMapAdapter;
import ghidra.program.database.register.RegisterValueRange;
import ghidra.program.database.register.SimpleAddressRangeIterator;
import ghidra.program.database.util.AddressRangeMapDB;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.lang.UndefinedValueException;
import ghidra.program.model.listing.DefaultProgramContext;
import ghidra.program.model.listing.ProgramContext;
import ghidra.program.util.RegisterValueStore;
import ghidra.util.Lock;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

public class OldProgramContextDB
implements ProgramContext,
DefaultProgramContext,
ManagerDB {
    private static final UndefinedValueException UNDEFINED_VALUE_EXCEPTION = new UndefinedValueException();
    private static final String OLD_CONTEXT_TABLE_PREFIX = "Range Map - ProgContext";
    private DBHandle dbHandle;
    private ErrorHandler errHandler;
    private Language language;
    private AddressMap addrMap;
    private Lock lock;
    private Map<Integer, AddressRangeMapDB> valueMaps;
    private Register baseContextRegister;
    protected Map<Register, RegisterValueStore> defaultRegisterValueMap;
    private Register[] registersWithValues;
    private RegisterValue defaultDisassemblyContext;

    public OldProgramContextDB(DBHandle dbHandle, ErrorHandler errHandler, Language language, AddressMap addrMap, Lock lock) {
        this.dbHandle = dbHandle;
        this.errHandler = errHandler;
        this.lock = lock;
        this.addrMap = addrMap.getOldAddressMap();
        this.language = language;
        this.defaultRegisterValueMap = new HashMap<Register, RegisterValueStore>();
        this.valueMaps = new HashMap<Integer, AddressRangeMapDB>();
        this.baseContextRegister = language.getContextBaseRegister();
        this.defaultDisassemblyContext = new RegisterValue(this.baseContextRegister);
        this.initializeDefaultValues(language);
    }

    static boolean oldContextDataExists(DBHandle dbh) {
        for (Table table : dbh.getTables()) {
            if (!table.getName().startsWith(OLD_CONTEXT_TABLE_PREFIX)) continue;
            return true;
        }
        return false;
    }

    static void removeOldContextData(DBHandle dbh) throws IOException {
        for (Table table : dbh.getTables()) {
            if (!table.getName().startsWith(OLD_CONTEXT_TABLE_PREFIX)) continue;
            dbh.deleteTable(table.getName());
        }
    }

    private void initializeDefaultValues(Language lang) {
        if (lang != null) {
            lang.applyContextSettings(this);
        }
    }

    @Override
    public void deleteAddressRange(Address start, Address end, TaskMonitor monitor) throws CancelledException {
        throw new UnsupportedOperationException();
    }

    public long get(Address addr, Register reg) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Register getBaseContextRegister() {
        return this.baseContextRegister;
    }

    @Override
    public AddressRangeIterator getDefaultRegisterValueAddressRanges(Register register) {
        RegisterValueStore store = this.defaultRegisterValueMap.get(register.getBaseRegister());
        if (store == null) {
            return new AddressSet().getAddressRanges();
        }
        return store.getAddressRangeIterator();
    }

    @Override
    public AddressRangeIterator getDefaultRegisterValueAddressRanges(Register register, Address start, Address end) {
        RegisterValueStore store = this.defaultRegisterValueMap.get(register.getBaseRegister());
        if (store == null) {
            return new AddressSet().getAddressRanges();
        }
        return store.getAddressRangeIterator(start, end);
    }

    @Override
    public RegisterValue getDefaultValue(Register register, Address address) {
        RegisterValueStore store = this.defaultRegisterValueMap.get(register.getBaseRegister());
        if (store == null) {
            return null;
        }
        return store.getValue(register, address);
    }

    @Override
    public RegisterValue getNonDefaultValue(Register register, Address address) {
        return this.getRegisterValue(register, address);
    }

    @Override
    public List<Register> getContextRegisters() {
        return this.language.getContextRegisters();
    }

    @Override
    public Register getRegister(String name) {
        return this.language.getRegister(name);
    }

    @Override
    public List<String> getRegisterNames() {
        return this.language.getRegisterNames();
    }

    @Override
    public AddressRangeIterator getRegisterValueAddressRanges(Register register) {
        AddressSet set = this.addrMap.getAddressFactory().getAddressSet();
        return this.getRegisterValueAddressRanges(register, set.getMinAddress(), set.getMaxAddress());
    }

    @Override
    public AddressRangeIterator getRegisterValueAddressRanges(Register register, Address start, Address end) {
        RegisterValueRange[] valueRanges = this.getRegisterValues(register, start, end);
        return new SimpleAddressRangeIterator(valueRanges);
    }

    int getRegisterOffset(Register reg) {
        int offset = reg.getOffset();
        if (reg.getBitLength() == 1 && !reg.isProcessorContext()) {
            offset |= reg.getLeastSignificantBit() << 28;
            offset |= 0x90000000;
        }
        return offset;
    }

    public RegisterValueRange[] getRegisterValues(Register reg, Address start, Address end) {
        SortedSet<Address> changePoints = this.getChangePoints(start, end, this.getRegisterOffset(reg), reg.getMinimumByteSize());
        ArrayList<RegisterValueRange> ranges = new ArrayList<RegisterValueRange>();
        Iterator it = changePoints.iterator();
        Address currentAddress = start;
        while (it.hasNext()) {
            Address nextChange = (Address)it.next();
            this.addRange(reg, ranges, currentAddress, nextChange.previous());
            currentAddress = nextChange;
        }
        this.addRange(reg, ranges, currentAddress, end);
        RegisterValueRange[] rangeArray = new RegisterValueRange[ranges.size()];
        ranges.toArray(rangeArray);
        return rangeArray;
    }

    private void addRange(Register reg, ArrayList<RegisterValueRange> ranges, Address start, Address end) {
        if (end == null) {
            this.addRange(reg, ranges, start, start.getAddressSpace().getMaxAddress());
        } else {
            if (!start.getAddressSpace().equals(end.getAddressSpace())) {
                this.addRange(reg, ranges, start, start.getAddressSpace().getMaxAddress());
                this.addRange(reg, ranges, end.getAddressSpace().getMinAddress(), end);
                return;
            }
            RegisterValueRange valueRange = this.getRegisterRange(reg, start, end);
            if (valueRange.getValue() != null) {
                ranges.add(valueRange);
            }
        }
    }

    @Override
    public List<Register> getRegisters() {
        return this.language.getRegisters();
    }

    public long getSigned(Address addr, Register reg) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public RegisterValue getRegisterValue(Register register, Address address) {
        Register baseReg = register.getBaseRegister();
        int size = baseReg.getMinimumByteSize();
        int offset = this.getRegisterOffset(register);
        byte[] bytes = new byte[2 * size];
        for (int i = 0; i < size; ++i) {
            int index = register.isBigEndian() ? i : size - i - 1;
            bytes[i] = 0;
            try {
                bytes[size + index] = this.getByte(offset + i, address);
                bytes[index] = -1;
                continue;
            }
            catch (UndefinedValueException undefinedValueException) {
                // empty catch block
            }
        }
        return new RegisterValue(register, bytes);
    }

    @Override
    public BigInteger getValue(Register register, Address address, boolean signed) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasValueOverRange(Register reg, BigInteger value, AddressSetView addrSet) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(Address start, Address end, Register register) {
        throw new UnsupportedOperationException();
    }

    public void set(Address start, Address end, Register reg, long value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDefaultValue(RegisterValue registerValue, Address start, Address end) {
        Register baseRegister = registerValue.getRegister().getBaseRegister();
        RegisterValueStore store = this.defaultRegisterValueMap.get(baseRegister);
        if (store == null) {
            InMemoryRangeMapAdapter adapter = new InMemoryRangeMapAdapter();
            store = new RegisterValueStore(registerValue.getRegister().getBaseRegister(), adapter, false);
            this.defaultRegisterValueMap.put(baseRegister, store);
        }
        store.setValue(start, end, registerValue);
    }

    @Override
    public void setValue(Register register, Address start, Address end, BigInteger value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setRegisterValue(Address start, Address end, RegisterValue value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void invalidateCache(boolean all) throws IOException {
        this.lock.acquire();
        try {
            this.valueMaps.clear();
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public void moveAddressRange(Address fromAddr, Address toAddr, long length, TaskMonitor monitor) throws CancelledException {
    }

    @Override
    public void programReady(int openMode, int currentRevision, TaskMonitor monitor) throws IOException, CancelledException {
    }

    @Override
    public void setProgram(ProgramDB program) {
    }

    @Override
    public RegisterValue getDefaultDisassemblyContext() {
        return this.defaultDisassemblyContext;
    }

    @Override
    public void setDefaultDisassemblyContext(RegisterValue newContext) {
        this.defaultDisassemblyContext = newContext;
    }

    private byte getByte(int offset, Address addr) throws UndefinedValueException {
        Field value;
        AddressRangeMapDB map = this.getRangeMap(offset);
        if (map != null && (value = map.getValue(addr)) != null) {
            return value.getByteValue();
        }
        throw UNDEFINED_VALUE_EXCEPTION;
    }

    private AddressRangeMapDB getRangeMap(int offset) {
        AddressRangeMapDB map = this.valueMaps.get(offset);
        if (map == null) {
            map = this.createMap(offset);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AddressRangeMapDB createMap(int offset) {
        this.lock.acquire();
        try {
            AddressRangeMapDB map = new AddressRangeMapDB(this.dbHandle, this.addrMap, this.lock, "ProgContext" + offset, this.errHandler, (Field)ByteField.INSTANCE, false);
            this.valueMaps.put(offset, map);
            AddressRangeMapDB addressRangeMapDB = map;
            return addressRangeMapDB;
        }
        finally {
            this.lock.release();
        }
    }

    private SortedSet<Address> getChangePoints(Address startAddr, Address endAddr, int registerOffset, int registerLength) {
        TreeSet<Address> changePoints = new TreeSet<Address>();
        AddressRangeMapDB map = this.getRangeMap(registerOffset);
        if (map != null) {
            AddressRangeIterator iter = map.getAddressRanges(startAddr, endAddr);
            Address curr = startAddr;
            while (iter.hasNext() && curr.compareTo(endAddr) < 0) {
                Address rangeEnd;
                AddressRange range = (AddressRange)iter.next();
                Address rangeStart = range.getMinAddress();
                if (!rangeStart.equals(curr)) {
                    changePoints.add(rangeStart);
                }
                if ((curr = (rangeEnd = range.getMaxAddress()).addWrap(1L)).compareTo(endAddr) > 0) continue;
                changePoints.add(curr);
            }
        }
        return changePoints;
    }

    private RegisterValueRange getRegisterRange(Register register, Address start, Address end) {
        return new RegisterValueRange(start, end, this.getRegisterValue(register, start));
    }

    @Override
    public Register[] getRegistersWithValues() {
        if (this.registersWithValues == null) {
            ArrayList<Register> tmp = new ArrayList<Register>();
            for (Register register : this.getRegisters()) {
                AddressRangeIterator it = this.getRegisterValueAddressRanges(register);
                if (it.hasNext()) {
                    tmp.add(register);
                    continue;
                }
                it = this.getDefaultRegisterValueAddressRanges(register);
                if (!it.hasNext()) continue;
                tmp.add(register);
            }
            this.registersWithValues = tmp.toArray(new Register[tmp.size()]);
        }
        return this.registersWithValues;
    }

    @Override
    public RegisterValue getDisassemblyContext(Address address) {
        return this.getDefaultDisassemblyContext();
    }

    @Override
    public AddressRange getRegisterValueRangeContaining(Register register, Address addr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasNonFlowingContext() {
        throw new UnsupportedOperationException();
    }

    @Override
    public RegisterValue getFlowValue(RegisterValue value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RegisterValue getNonFlowValue(RegisterValue value) {
        throw new UnsupportedOperationException();
    }
}

