/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.DBHandle;
import db.Schema;
import ghidra.program.database.data.CallingConventionDBAdapterNoTable;
import ghidra.program.database.data.CallingConventionDBAdapterV0;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Set;
import java.util.function.Consumer;

abstract class CallingConventionDBAdapter {
    static final byte UNKNOWN_CALLING_CONVENTION_ID = 0;
    static final byte DEFAULT_CALLING_CONVENTION_ID = 1;
    static final byte FIRST_CALLING_CONVENTION_ID = 2;
    static final String CALLING_CONVENTION_TABLE_NAME = "Calling Conventions";
    static final Schema CALLING_CONVENTION_SCHEMA = CallingConventionDBAdapterV0.V0_CALLING_CONVENTION_SCHEMA;
    static final int CALLING_CONVENTION_NAME_COL = 0;

    CallingConventionDBAdapter() {
    }

    static CallingConventionDBAdapter getAdapter(DBHandle handle, int openMode, String tablePrefix, TaskMonitor monitor) throws VersionException, IOException, CancelledException {
        if (openMode == 0) {
            return new CallingConventionDBAdapterV0(handle, tablePrefix, true);
        }
        try {
            return new CallingConventionDBAdapterV0(handle, tablePrefix, false);
        }
        catch (VersionException e) {
            if (!e.isUpgradable() || openMode == 1) {
                throw e;
            }
            CallingConventionDBAdapter adapter = CallingConventionDBAdapter.findReadOnlyAdapter(handle);
            if (openMode == 3) {
                adapter = CallingConventionDBAdapter.upgrade(handle, adapter, tablePrefix, monitor);
            }
            return adapter;
        }
    }

    private static CallingConventionDBAdapter findReadOnlyAdapter(DBHandle handle) {
        return new CallingConventionDBAdapterNoTable();
    }

    private static CallingConventionDBAdapter upgrade(DBHandle handle, CallingConventionDBAdapter oldAdapter, String tablePrefix, TaskMonitor monitor) throws VersionException, IOException {
        return new CallingConventionDBAdapterV0(handle, tablePrefix, true);
    }

    abstract byte getCallingConventionId(String var1, Consumer<String> var2) throws IOException;

    abstract String getCallingConventionName(byte var1) throws IOException;

    abstract void invalidateCache();

    abstract Set<String> getCallingConventionNames() throws IOException;
}

