/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.address;

import ghidra.pcodeCPort.address.Address;
import ghidra.pcodeCPort.address.AddressUtils;
import ghidra.pcodeCPort.error.LowlevelError;
import ghidra.pcodeCPort.pcoderaw.VarnodeData;
import ghidra.pcodeCPort.space.AddrSpace;
import ghidra.pcodeCPort.translate.Translate;
import ghidra.pcodeCPort.utils.XmlUtils;
import java.io.PrintStream;
import org.jdom.Element;

public class Range
implements Comparable<Range> {
    private AddrSpace spc;
    private long first;
    private long last;

    public Range(AddrSpace s, long f, long l) {
        this.spc = s;
        this.first = f;
        this.last = l;
    }

    public Range() {
    }

    public AddrSpace getSpace() {
        return this.spc;
    }

    public long getFirst() {
        return this.first;
    }

    public long getLast() {
        return this.last;
    }

    public Address getFirstAddr() {
        return new Address(this.spc, this.first);
    }

    public Address getLastAddr() {
        return new Address(this.spc, this.last);
    }

    @Override
    public int compareTo(Range other) {
        int result = this.spc.compareTo(other.spc);
        if (result != 0) {
            return result;
        }
        return AddressUtils.unsignedCompare(this.first, other.first);
    }

    void printBounds(PrintStream s) {
        s.append(this.spc.getName());
        s.append(": ");
        s.append(Long.toHexString(this.first));
        s.append('-');
        s.append(Long.toHexString(this.last));
    }

    void saveXml(PrintStream s) {
        s.append("<range");
        XmlUtils.a_v(s, "space", this.spc.getName());
        XmlUtils.a_v_u(s, "first", this.first);
        XmlUtils.a_v_u(s, "last", this.last);
        s.append("/>\n");
    }

    public Address getLastAddrOpen(Translate trans) {
        long curlast = this.last;
        AddrSpace curspc = this.spc;
        if (curlast == curspc.getMask()) {
            curspc = trans.getNextSpaceInOrder(curspc);
            curlast = 0L;
        } else {
            ++curlast;
        }
        if (curspc == null) {
            return new Address(Address.mach_extreme.m_maximal);
        }
        return new Address(curspc, curlast);
    }

    public void restoreXml(Element el, Translate trans) {
        this.spc = null;
        this.first = 0L;
        this.last = -1L;
        String attrvalue = el.getAttributeValue("space");
        if (attrvalue != null) {
            this.spc = trans.getSpaceByName(attrvalue);
            if (this.spc == null) {
                throw new LowlevelError("Undefined space: " + attrvalue);
            }
        }
        if ((attrvalue = el.getAttributeValue("first")) != null) {
            this.first = XmlUtils.decodeUnknownLong(attrvalue);
        }
        if ((attrvalue = el.getAttributeValue("last")) != null) {
            this.last = XmlUtils.decodeUnknownLong(attrvalue);
        }
        if ((attrvalue = el.getAttributeValue("name")) != null) {
            VarnodeData point = trans.getRegister(attrvalue);
            this.spc = point.space;
            this.first = point.offset;
            this.last = this.first - 1L + (long)point.size;
        }
        if (this.spc == null) {
            throw new LowlevelError("No address space indicated in range tag");
        }
        this.first &= this.spc.getMask();
        this.last &= this.spc.getMask();
    }
}

