/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.DialogComponentProvider;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.widgets.CursorPosition;
import docking.widgets.FindDialog;
import docking.widgets.FindDialogSearcher;
import docking.widgets.SearchLocation;
import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.support.FieldLocation;
import ghidra.app.decompiler.component.ClangTextField;
import ghidra.app.decompiler.component.DecompilerPanel;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompile.actions.AbstractDecompilerAction;
import ghidra.app.plugin.core.decompile.actions.DecompilerCursorPosition;
import ghidra.app.plugin.core.decompile.actions.FieldBasedSearchLocation;
import ghidra.util.HelpLocation;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class FindAction
extends AbstractDecompilerAction {
    private FindDialog findDialog;

    public FindAction() {
        super("Find");
        this.setHelpLocation(new HelpLocation("DecompilePlugin", "ActionFind"));
        this.setPopupMenuData(new MenuData(new String[]{"Find..."}, "Decompile"));
        this.setKeyBindingData(new KeyBindingData(70, 128));
        this.setEnabled(true);
    }

    public void dispose() {
        if (this.findDialog != null) {
            this.findDialog.dispose();
        }
        super.dispose();
    }

    protected FindDialog getFindDialog(final DecompilerPanel decompilerPanel) {
        if (this.findDialog == null) {
            this.findDialog = new FindDialog("Decompiler Find Text", new DecompilerSearcher(decompilerPanel)){

                protected void dialogClosed() {
                    decompilerPanel.setSearchResults(null);
                }
            };
            this.findDialog.setHelpLocation(new HelpLocation("DecompilePlugin", "ActionFind"));
        }
        return this.findDialog;
    }

    @Override
    protected boolean isEnabledForDecompilerContext(DecompilerActionContext context) {
        return true;
    }

    @Override
    protected void decompilerActionPerformed(DecompilerActionContext context) {
        DecompilerPanel decompilerPanel = context.getDecompilerPanel();
        FindDialog dialog = this.getFindDialog(decompilerPanel);
        String text = decompilerPanel.getSelectedText();
        if (text == null) {
            text = decompilerPanel.getHighlightedText();
        }
        if (!StringUtils.isBlank((CharSequence)text)) {
            dialog.setSearchText(text);
        }
        context.getTool().showDialog((DialogComponentProvider)dialog);
    }

    private static class DecompilerSearcher
    implements FindDialogSearcher {
        private DecompilerPanel decompilerPanel;

        public DecompilerSearcher(DecompilerPanel dPanel) {
            this.decompilerPanel = dPanel;
        }

        public CursorPosition getCursorPosition() {
            FieldLocation fieldLocation = this.decompilerPanel.getCursorPosition();
            return new DecompilerCursorPosition(fieldLocation);
        }

        public CursorPosition getStart() {
            int lineNumber = 0;
            int fieldNumber = 0;
            int column = 0;
            FieldLocation fieldLocation = new FieldLocation(lineNumber, fieldNumber, 0, column);
            return new DecompilerCursorPosition(fieldLocation);
        }

        public CursorPosition getEnd() {
            List<Field> lines = this.decompilerPanel.getFields();
            int lineNumber = lines.size() - 1;
            ClangTextField textLine = (ClangTextField)lines.get(lineNumber);
            int fieldNumber = 0;
            int rowCount = textLine.getNumRows();
            int row = rowCount - 1;
            int column = textLine.getNumCols(row);
            FieldLocation fieldLocation = new FieldLocation(lineNumber, fieldNumber, row, column);
            return new DecompilerCursorPosition(fieldLocation);
        }

        public void setCursorPosition(CursorPosition position) {
            this.decompilerPanel.setCursorPosition(((DecompilerCursorPosition)position).getFieldLocation());
        }

        public void highlightSearchResults(SearchLocation location) {
            this.decompilerPanel.setSearchResults(location);
        }

        public SearchLocation search(String text, CursorPosition position, boolean searchForward, boolean useRegex) {
            DecompilerCursorPosition decompilerCursorPosition = (DecompilerCursorPosition)position;
            FieldLocation startLocation = this.getNextSearchStartLocation(decompilerCursorPosition, searchForward);
            return useRegex ? this.decompilerPanel.searchTextRegex(text, startLocation, searchForward) : this.decompilerPanel.searchText(text, startLocation, searchForward);
        }

        private FieldLocation getNextSearchStartLocation(DecompilerCursorPosition decompilerCursorPosition, boolean searchForward) {
            FieldLocation startLocation = decompilerCursorPosition.getFieldLocation();
            FieldBasedSearchLocation currentSearchLocation = this.decompilerPanel.getSearchResults();
            if (currentSearchLocation == null) {
                return startLocation;
            }
            if (Objects.equals(startLocation, currentSearchLocation.getFieldLocation())) {
                if (searchForward) {
                    ++startLocation.col;
                } else {
                    int length = currentSearchLocation.getMatchLength();
                    startLocation.col += length - 1;
                }
            }
            return startLocation;
        }
    }
}

