/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.time;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.Tool;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.ToggleDockingAction;
import docking.action.builder.ActionBuilder;
import docking.action.builder.ToggleActionBuilder;
import ghidra.app.plugin.core.debug.DebuggerCoordinates;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.DebuggerSnapActionContext;
import ghidra.app.plugin.core.debug.gui.time.DebuggerSnapshotTablePanel;
import ghidra.app.plugin.core.debug.gui.time.DebuggerTimePlugin;
import ghidra.app.plugin.core.debug.gui.time.DebuggerTimeSelectionDialog;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.AutoConfigState;
import ghidra.framework.plugintool.AutoService;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.annotation.AutoConfigStateField;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.trace.model.time.schedule.TraceSchedule;
import ghidra.util.HelpLocation;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.invoke.MethodHandles;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JComponent;

public class DebuggerTimeProvider
extends ComponentProviderAdapter {
    private static final AutoConfigState.ClassHandler<DebuggerTimeProvider> CONFIG_STATE_HANDLER = AutoConfigState.wireHandler(DebuggerTimeProvider.class, (MethodHandles.Lookup)MethodHandles.lookup());
    protected final DebuggerTimePlugin plugin;
    DebuggerCoordinates current = DebuggerCoordinates.NOWHERE;
    @AutoServiceConsumed
    protected DebuggerTraceManagerService traceManager;
    private final AutoService.Wiring autoServiceWiring;
    final DebuggerSnapshotTablePanel mainPanel;
    protected final DebuggerTimeSelectionDialog timeDialog;
    DockingAction actionGoToTime;
    ToggleDockingAction actionHideScratch;
    private DebuggerSnapActionContext myActionContext;
    @AutoConfigStateField
    boolean hideScratch = true;

    protected static boolean sameCoordinates(DebuggerCoordinates a, DebuggerCoordinates b) {
        if (!Objects.equals(a.getTrace(), b.getTrace())) {
            return false;
        }
        return Objects.equals(a.getTime(), b.getTime());
    }

    public DebuggerTimeProvider(DebuggerTimePlugin plugin) {
        super(plugin.getTool(), "Time", plugin.getName());
        this.plugin = plugin;
        this.autoServiceWiring = AutoService.wireServicesConsumed((Plugin)plugin, (Object)((Object)this));
        this.setTitle("Time");
        this.setIcon(DebuggerResources.ICON_PROVIDER_TIME);
        this.setHelpLocation(DebuggerResources.HELP_PROVIDER_TIME);
        this.setWindowMenuGroup("Debugger");
        this.timeDialog = new DebuggerTimeSelectionDialog(this.tool);
        this.mainPanel = new DebuggerSnapshotTablePanel(this.tool);
        this.buildMainPanel();
        this.myActionContext = new DebuggerSnapActionContext(this.current.getTrace(), this.current.getSnap());
        this.createActions();
        this.contextChanged();
        this.setVisible(true);
    }

    public void addLocalAction(DockingActionIf action) {
        super.addLocalAction(action);
    }

    public JComponent getComponent() {
        return this.mainPanel;
    }

    public ActionContext getActionContext(MouseEvent event) {
        if (this.myActionContext == null) {
            return super.getActionContext(event);
        }
        return this.myActionContext;
    }

    protected void buildMainPanel() {
        this.mainPanel.getSelectionModel().addListSelectionListener(evt -> {
            if (evt.getValueIsAdjusting()) {
                return;
            }
            Long snap = this.mainPanel.getSelectedSnapshot();
            if (snap == null) {
                this.myActionContext = null;
                return;
            }
            if (snap.longValue() == this.current.getSnap()) {
                return;
            }
            this.myActionContext = new DebuggerSnapActionContext(this.current.getTrace(), snap);
            this.contextChanged();
        });
        this.mainPanel.snapshotTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && e.getButton() == 1) {
                    DebuggerTimeProvider.this.activateSelectedSnapshot();
                }
            }
        });
        this.mainPanel.snapshotTable.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    DebuggerTimeProvider.this.activateSelectedSnapshot();
                    e.consume();
                }
            }
        });
    }

    private void activateSelectedSnapshot() {
        Long snap = this.mainPanel.getSelectedSnapshot();
        if (snap != null && this.traceManager != null) {
            this.traceManager.activateSnap(snap);
        }
    }

    protected void createActions() {
        this.actionGoToTime = (DockingAction)((ActionBuilder)((ActionBuilder)GoToTimeAction.builder(this.plugin).enabledWhen(c -> this.current.getTrace() != null)).onAction(c -> this.activatedGoToTime())).buildAndInstall((Tool)this.tool);
        this.actionHideScratch = (ToggleDockingAction)((ToggleActionBuilder)DebuggerResources.HideScratchSnapshotsAction.builder(this.plugin).selected(this.hideScratch).onAction(this::activatedHideScratch)).buildAndInstallLocal((ComponentProvider)this);
    }

    private void activatedGoToTime() {
        TraceSchedule time = this.timeDialog.promptTime(this.current.getTrace(), this.current.getTime());
        if (time == null) {
            return;
        }
        this.traceManager.activateTime(time);
    }

    private void activatedHideScratch(ActionContext ctx) {
        this.hideScratch = !this.hideScratch;
        this.mainPanel.setHideScratchSnapshots(this.hideScratch);
    }

    public void coordinatesActivated(DebuggerCoordinates coordinates) {
        if (DebuggerTimeProvider.sameCoordinates(this.current, coordinates)) {
            this.current = coordinates;
            return;
        }
        this.current = coordinates;
        this.mainPanel.setTrace(this.current.getTrace());
        this.mainPanel.setSelectedSnapshot(this.current.getSnap());
    }

    public void writeConfigState(SaveState saveState) {
        CONFIG_STATE_HANDLER.writeConfigState((Object)this, saveState);
    }

    public void readConfigState(SaveState saveState) {
        CONFIG_STATE_HANDLER.readConfigState((Object)this, saveState);
        this.actionHideScratch.setSelected(this.hideScratch);
        this.mainPanel.setHideScratchSnapshots(this.hideScratch);
    }

    static interface GoToTimeAction {
        public static final String NAME = "Go To Time";
        public static final String DESCRIPTION = "Go to a specific time, optionally using emulation";
        public static final String GROUP = "Dbg7. Trace";
        public static final Icon ICON = DebuggerResources.ICON_TIME;
        public static final String HELP_ANCHOR = "goto_time";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).menuPath(new String[]{"Debugger", NAME})).menuGroup(GROUP)).menuIcon(ICON)).keyBinding("CTRL G")).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }
}

