/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.control;

import docking.ActionContext;
import docking.DockingContextListener;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.ToolBarData;
import docking.action.builder.AbstractActionBuilder;
import docking.action.builder.ActionBuilder;
import docking.menu.ActionState;
import docking.menu.MultiStateDockingAction;
import docking.widgets.EventTrigger;
import ghidra.app.plugin.core.debug.AbstractDebuggerPlugin;
import ghidra.app.plugin.core.debug.DebuggerCoordinates;
import ghidra.app.plugin.core.debug.event.ModelObjectFocusedPluginEvent;
import ghidra.app.plugin.core.debug.event.TraceActivatedPluginEvent;
import ghidra.app.plugin.core.debug.event.TraceClosedPluginEvent;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.service.emulation.DebuggerPcodeMachine;
import ghidra.app.services.ControlMode;
import ghidra.app.services.DebuggerControlService;
import ghidra.app.services.DebuggerEmulationService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.app.services.TraceRecorder;
import ghidra.async.AsyncUtils;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.target.TargetExecutionStateful;
import ghidra.dbg.target.TargetInterruptible;
import ghidra.dbg.target.TargetKillable;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetResumable;
import ghidra.dbg.target.TargetSteppable;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceDomainObjectListener;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.TraceObjectValue;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.model.time.schedule.Scheduler;
import ghidra.trace.util.TraceChangeType;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.Swing;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.KeyStroke;

@PluginInfo(shortDescription="Debugger global controls", description="GUI to control target, trace, and emulator; and edit machine state", category="Debugger", packageName="Debugger", status=PluginStatus.RELEASED, eventsConsumed={TraceActivatedPluginEvent.class, TraceClosedPluginEvent.class, ModelObjectFocusedPluginEvent.class}, servicesRequired={DebuggerControlService.class, DebuggerTraceManagerService.class})
public class DebuggerControlPlugin
extends AbstractDebuggerPlugin
implements DockingContextListener {
    private final TraceDomainObjectListener listenerForObjects = new TraceDomainObjectListener(){
        {
            this.listenFor((TraceChangeType)Trace.TraceObjectChangeType.VALUE_CREATED, this::valueChanged);
            this.listenFor((TraceChangeType)Trace.TraceObjectChangeType.VALUE_DELETED, this::valueChanged);
            this.listenFor((TraceChangeType)Trace.TraceObjectChangeType.VALUE_LIFESPAN_CHANGED, this::valueLifespanChanged);
        }

        private void valueChanged(TraceObjectValue value) {
            if (value.getLifespan().contains(DebuggerControlPlugin.this.current.getSnap())) {
                Swing.runIfSwingOrRunLater(() -> DebuggerControlPlugin.this.updateActionsEnabled());
            }
        }

        private void valueLifespanChanged(TraceObjectValue value, Lifespan oldLife, Lifespan newLife) {
            if (newLife.contains(DebuggerControlPlugin.this.current.getSnap()) != oldLife.contains(DebuggerControlPlugin.this.current.getSnap())) {
                Swing.runIfSwingOrRunLater(() -> DebuggerControlPlugin.this.updateActionsEnabled());
            }
        }
    };
    private final DebuggerControlService.ControlModeChangeListener listenerForModeChanges = this::modeChanged;
    private final DebuggerEmulationService.EmulatorStateListener listenerForEmuStateChanges = new DebuggerEmulationService.EmulatorStateListener(){

        @Override
        public void running(DebuggerEmulationService.CachedEmulator emu) {
            Swing.runIfSwingOrRunLater(() -> DebuggerControlPlugin.this.updateActions());
        }

        @Override
        public void stopped(DebuggerEmulationService.CachedEmulator emu) {
            Swing.runIfSwingOrRunLater(() -> DebuggerControlPlugin.this.updateActions());
        }
    };
    protected DebuggerCoordinates current = DebuggerCoordinates.NOWHERE;
    protected MultiStateDockingAction<ControlMode> actionControlMode;
    DockingAction actionTargetResume;
    DockingAction actionTargetInterrupt;
    DockingAction actionTargetKill;
    DockingAction actionTargetDisconnect;
    DockingAction actionTargetStepInto;
    DockingAction actionTargetStepOver;
    DockingAction actionTargetStepFinish;
    DockingAction actionTargetStepLast;
    Set<DockingAction> actionsTarget;
    DockingAction actionEmulateResume;
    DockingAction actionEmulateInterrupt;
    DockingAction actionEmulateStepBack;
    DockingAction actionEmulateStepInto;
    DockingAction actionEmulateSkipOver;
    Set<DockingAction> actionsEmulate;
    DockingAction actionTraceSnapBackward;
    DockingAction actionTraceSnapForward;
    Set<DockingAction> actionsTrace;
    Set<Set<DockingAction>> actionSets;
    Collection<? extends DockingActionIf> curActionSet;
    ActionContext context;
    @AutoServiceConsumed
    private DebuggerTraceManagerService traceManager;
    private DebuggerControlService controlService;
    private DebuggerEmulationService emulationService;

    static String intSubGroup(int subGroup) {
        return String.format("%02d", subGroup);
    }

    public DebuggerControlPlugin(PluginTool tool) {
        super(tool);
        tool.addContextListener((DockingContextListener)this);
        this.createActions();
    }

    protected Set<DockingAction> getActionSet(ControlMode mode) {
        switch (mode) {
            case RO_TARGET: 
            case RW_TARGET: {
                return this.actionsTarget;
            }
            case RO_TRACE: 
            case RW_TRACE: {
                return this.actionsTrace;
            }
            case RW_EMULATOR: {
                return this.actionsEmulate;
            }
        }
        throw new AssertionError();
    }

    protected Set<DockingAction> getActionSet() {
        return this.getActionSet(this.computeCurrentEditingMode());
    }

    protected void updateActionsEnabled(ControlMode mode) {
        for (DockingAction action : this.getActionSet(mode)) {
            action.setEnabled(action.isEnabledForContext(this.context));
        }
    }

    protected void updateActionsEnabled() {
        this.updateActionsEnabled(this.computeCurrentEditingMode());
    }

    public void contextChanged(ActionContext context) {
        this.context = context;
        this.updateActionsEnabled();
    }

    protected void createActions() {
        this.actionControlMode = new ControlModeAction();
        this.tool.addAction(this.actionControlMode);
        this.actionTargetResume = TargetResumeAction.builder(this).enabledWhenTarget(this::isActionTargetResumeEnabled).onTargetAction(this::activatedTargetResume).build();
        this.actionTargetInterrupt = TargetInterruptAction.builder(this).enabledWhenTarget(this::isActionTargetInterruptEnabled).onTargetAction(this::activatedTargetInterrupt).build();
        this.actionTargetKill = TargetKillAction.builder(this).enabledWhenTarget(this::isActionTargetKillEnabled).onTargetAction(this::activatedTargetKill).build();
        this.actionTargetDisconnect = ((ActionBuilder)((ActionBuilder)DisconnectAction.builder(this).enabledWhen(this::isActionTargetDisconnectEnabled)).onAction(this::activatedTargetDisconnect)).build();
        this.actionTargetStepInto = TargetStepIntoAction.builder(this).enabledWhenTarget(this::isActionTargetStepEnabled).onTargetAction(this::activatedTargetStepInto).build();
        this.actionTargetStepOver = TargetStepOverAction.builder(this).enabledWhenTarget(this::isActionTargetStepEnabled).onTargetAction(this::activatedTargetStepOver).build();
        this.actionTargetStepFinish = TargetStepFinishAction.builder(this).enabledWhenTarget(this::isActionTargetStepEnabled).onTargetAction(this::activatedTargetStepFinish).build();
        this.actionTargetStepLast = TargetStepLastAction.builder(this).enabledWhenTarget(this::isActionTargetStepEnabled).onTargetAction(this::activatedTargetStepLast).build();
        this.actionsTarget = Set.of(this.actionTargetResume, this.actionTargetInterrupt, this.actionTargetKill, this.actionTargetDisconnect, this.actionTargetStepInto, this.actionTargetStepOver, this.actionTargetStepFinish, this.actionTargetStepLast);
        this.actionEmulateResume = ((ActionBuilder)((ActionBuilder)EmulateResumeAction.builder(this).enabledWhen(this::isActionEmulateResumeEnabled)).onAction(this::activateEmulateResume)).build();
        this.actionEmulateInterrupt = ((ActionBuilder)((ActionBuilder)EmulateInterruptAction.builder(this).enabledWhen(this::isActionEmulateInterruptEnabled)).onAction(this::activateEmulateInterrupt)).build();
        this.actionEmulateStepBack = ((ActionBuilder)((ActionBuilder)EmulateStepBackAction.builder(this).enabledWhen(this::isActionEmulateStepBackEnabled)).onAction(this::activateEmulateStepBack)).build();
        this.actionEmulateStepInto = ((ActionBuilder)((ActionBuilder)EmulateStepIntoAction.builder(this).enabledWhen(this::isActionEmulateStepIntoEnabled)).onAction(this::activateEmulateStepInto)).build();
        this.actionEmulateSkipOver = ((ActionBuilder)((ActionBuilder)EmulateSkipOverAction.builder(this).enabledWhen(this::isActionEmulateSkipOverEnabled)).onAction(this::activateEmulateSkipOver)).build();
        this.actionsEmulate = Set.of(this.actionEmulateResume, this.actionEmulateInterrupt, this.actionEmulateStepBack, this.actionEmulateStepInto, this.actionEmulateSkipOver);
        this.actionTraceSnapBackward = ((ActionBuilder)((ActionBuilder)TraceSnapBackwardAction.builder(this).enabledWhen(this::isActionTraceSnapBackwardEnabled)).onAction(this::activateTraceSnapBackward)).build();
        this.actionTraceSnapForward = ((ActionBuilder)((ActionBuilder)TraceSnapForwardAction.builder(this).enabledWhen(this::isActionTraceSnapForwardEnabled)).onAction(this::activateTraceSnapForward)).build();
        this.actionsTrace = Set.of(this.actionTraceSnapBackward, this.actionTraceSnapForward);
        this.actionSets = Set.of(this.actionsTarget, this.actionsEmulate, this.actionsTrace);
        this.updateActions();
    }

    protected void activateControlMode(ActionState<ControlMode> state, EventTrigger trigger) {
        if (this.current.getTrace() == null) {
            return;
        }
        if (this.controlService == null) {
            return;
        }
        this.controlService.setCurrentMode(this.current.getTrace(), (ControlMode)((Object)state.getUserData()));
    }

    private void modeChanged(Trace trace, ControlMode mode) {
        Swing.runIfSwingOrRunLater(() -> {
            if (this.current.getTrace() == trace) {
                this.updateActions();
            }
        });
    }

    private TargetExecutionStateful.TargetExecutionState getStateOf(TraceObject traceObject, TargetObject targetObject) {
        if (traceObject != null) {
            return traceObject.getExecutionState(this.current.getSnap());
        }
        TargetExecutionStateful stateful = (TargetExecutionStateful)targetObject.getCachedSuitable(TargetExecutionStateful.class);
        return stateful == null ? null : stateful.getExecutionState();
    }

    private boolean isActionTargetResumeEnabled(TraceObject object, TargetResumable resumable) {
        TargetExecutionStateful.TargetExecutionState state = this.getStateOf(object, (TargetObject)resumable);
        return state == null || state.isStopped();
    }

    private CompletableFuture<?> activatedTargetResume(TargetResumable resumable) {
        return resumable.resume();
    }

    private boolean isActionTargetInterruptEnabled(TraceObject object, TargetInterruptible interruptible) {
        TargetExecutionStateful.TargetExecutionState state = this.getStateOf(object, (TargetObject)interruptible);
        return state == null || state.isRunning();
    }

    private CompletableFuture<?> activatedTargetInterrupt(TargetInterruptible interruptible) {
        return interruptible.interrupt();
    }

    private boolean isActionTargetKillEnabled(TraceObject object, TargetKillable killable) {
        TargetExecutionStateful.TargetExecutionState state = this.getStateOf(object, (TargetObject)killable);
        return state == null || state.isAlive();
    }

    private CompletableFuture<?> activatedTargetKill(TargetKillable killable) {
        return killable.kill();
    }

    private boolean isActionTargetDisconnectEnabled(ActionContext context) {
        return this.current.isAlive();
    }

    private void activatedTargetDisconnect(ActionContext context) {
        TraceRecorder recorder = this.current.getRecorder();
        if (recorder == null) {
            return;
        }
        DebuggerObjectModel model = recorder.getTarget().getModel();
        model.close().exceptionally(ex -> {
            this.tool.setStatusInfo("Disconnect failed: " + ex.getMessage(), true);
            Msg.error((Object)((Object)this), (Object)"Disconnect failed", (Throwable)ex);
            return null;
        });
    }

    private boolean isActionTargetStepEnabled(TraceObject object, TargetSteppable steppable) {
        TargetExecutionStateful.TargetExecutionState state = this.getStateOf(object, (TargetObject)steppable);
        return state == null || state.isStopped();
    }

    private CompletableFuture<?> activatedTargetStepInto(TargetSteppable steppable) {
        return steppable.step(TargetSteppable.TargetStepKind.INTO);
    }

    private CompletableFuture<?> activatedTargetStepOver(TargetSteppable steppable) {
        return steppable.step(TargetSteppable.TargetStepKind.OVER);
    }

    private CompletableFuture<?> activatedTargetStepFinish(TargetSteppable steppable) {
        return steppable.step(TargetSteppable.TargetStepKind.FINISH);
    }

    private CompletableFuture<?> activatedTargetStepLast(TargetSteppable steppable) {
        return steppable.step(TargetSteppable.TargetStepKind.EXTENDED);
    }

    private boolean haveEmuAndTrace() {
        if (this.emulationService == null) {
            return false;
        }
        return this.current.getTrace() != null;
    }

    private boolean haveEmuAndThread() {
        if (this.emulationService == null) {
            return false;
        }
        return this.current.getThread() != null;
    }

    private DebuggerPcodeMachine<?> getBusyEmulator() {
        Iterator<DebuggerEmulationService.CachedEmulator> iterator = this.emulationService.getBusyEmulators().iterator();
        if (iterator.hasNext()) {
            DebuggerEmulationService.CachedEmulator ce = iterator.next();
            return ce.emulator();
        }
        return null;
    }

    private boolean isActionEmulateResumeEnabled(ActionContext context) {
        if (!this.haveEmuAndThread()) {
            return false;
        }
        return this.getBusyEmulator() == null;
    }

    private void activateEmulateResume(ActionContext context) {
        if (!this.haveEmuAndThread()) {
            return;
        }
        if (this.getBusyEmulator() != null) {
            return;
        }
        DebuggerCoordinates current = this.current;
        ((CompletableFuture)this.emulationService.backgroundRun(current.getPlatform(), current.getTime(), Scheduler.oneThread((TraceThread)current.getThread())).thenAcceptAsync(r -> this.traceManager.activate(current.time(r.schedule()), DebuggerTraceManagerService.ActivationCause.USER), (Executor)AsyncUtils.SWING_EXECUTOR)).exceptionally(ex -> {
            Msg.showError((Object)((Object)this), null, (String)"Emulate", (Object)"Error emulating", (Throwable)ex);
            return null;
        });
    }

    private boolean isActionEmulateInterruptEnabled(ActionContext context) {
        if (!this.haveEmuAndThread()) {
            return false;
        }
        return this.getBusyEmulator() != null;
    }

    private void activateEmulateInterrupt(ActionContext context) {
        if (this.emulationService == null) {
            return;
        }
        DebuggerPcodeMachine<?> emu = this.getBusyEmulator();
        emu.setSuspended(true);
    }

    private boolean isActionEmulateStepBackEnabled(ActionContext context) {
        if (!this.haveEmuAndTrace()) {
            return false;
        }
        return this.current.getTime().steppedBackward(this.current.getTrace(), 1L) != null;
    }

    private void activateEmulateStepBack(ActionContext context) {
        this.traceManager.activateTime(this.current.getTime().steppedBackward(this.current.getTrace(), 1L));
    }

    private boolean isActionEmulateStepIntoEnabled(ActionContext context) {
        return this.haveEmuAndThread();
    }

    private void activateEmulateStepInto(ActionContext context) {
        this.traceManager.activateTime(this.current.getTime().steppedForward(this.current.getThread(), 1L));
    }

    private boolean isActionEmulateSkipOverEnabled(ActionContext context) {
        return this.haveEmuAndThread();
    }

    private void activateEmulateSkipOver(ActionContext context) {
        this.traceManager.activateTime(this.current.getTime().skippedForward(this.current.getThread(), 1L));
    }

    private boolean isActionTraceSnapBackwardEnabled(ActionContext context) {
        if (this.current.getTrace() == null) {
            return false;
        }
        if (!this.current.getTime().isSnapOnly()) {
            return true;
        }
        return this.current.getSnap() > 0L;
    }

    private void activateTraceSnapBackward(ActionContext context) {
        if (this.current.getTime().isSnapOnly()) {
            this.traceManager.activateSnap(this.current.getSnap() - 1L);
        } else {
            this.traceManager.activateSnap(this.current.getSnap());
        }
    }

    private boolean isActionTraceSnapForwardEnabled(ActionContext context) {
        Trace curTrace = this.current.getTrace();
        if (curTrace == null) {
            return false;
        }
        Long maxSnap = curTrace.getTimeManager().getMaxSnap();
        return maxSnap != null && this.current.getSnap() < maxSnap;
    }

    private void activateTraceSnapForward(ActionContext contetxt) {
        this.traceManager.activateSnap(this.current.getSnap() + 1L);
    }

    protected void coordinatesActivated(DebuggerCoordinates coords) {
        if (this.current.getTrace() != coords.getTrace()) {
            if (this.current.getTrace() != null) {
                this.current.getTrace().removeListener((DomainObjectListener)this.listenerForObjects);
            }
            if (coords.getTrace() != null) {
                coords.getTrace().addListener((DomainObjectListener)this.listenerForObjects);
            }
        }
        this.current = coords;
        this.updateActions();
    }

    private ControlMode computeCurrentEditingMode() {
        if (this.controlService == null) {
            return ControlMode.DEFAULT;
        }
        if (this.current.getTrace() == null) {
            return ControlMode.DEFAULT;
        }
        return this.controlService.getCurrentMode(this.current.getTrace());
    }

    private void hideActions(Collection<? extends DockingActionIf> actions) {
        if (this.tool == null) {
            return;
        }
        if (this.curActionSet == actions) {
            this.curActionSet = null;
        }
        for (DockingActionIf dockingActionIf : actions) {
            this.tool.removeAction(dockingActionIf);
        }
    }

    private void showActions(Collection<? extends DockingActionIf> actions) {
        if (this.tool == null) {
            return;
        }
        if (this.curActionSet == actions) {
            return;
        }
        for (DockingActionIf dockingActionIf : actions) {
            this.tool.addAction(dockingActionIf);
        }
        this.curActionSet = actions;
    }

    private void updateActions() {
        ControlMode mode = this.computeCurrentEditingMode();
        this.actionControlMode.setCurrentActionStateByUserData((Object)mode);
        Set<DockingAction> actions = this.getActionSet(mode);
        for (Set<DockingAction> set : this.actionSets) {
            if (set == actions) {
                this.showActions(set);
                continue;
            }
            this.hideActions(set);
        }
        this.updateActionsEnabled(mode);
    }

    protected void traceClosed(Trace trace) {
        if (this.current.getTrace() == trace) {
            trace.removeListener((DomainObjectListener)this.listenerForObjects);
            this.current = DebuggerCoordinates.NOWHERE;
        }
        this.updateActions();
    }

    @AutoServiceConsumed
    private void setControlService(DebuggerControlService editingService) {
        if (this.controlService != null) {
            this.controlService.removeModeChangeListener(this.listenerForModeChanges);
        }
        this.controlService = editingService;
        if (this.controlService != null) {
            this.controlService.addModeChangeListener(this.listenerForModeChanges);
        }
        this.updateActions();
    }

    @AutoServiceConsumed
    private void setEmulationService(DebuggerEmulationService emulationService) {
        if (this.emulationService != null) {
            this.emulationService.removeStateListener(this.listenerForEmuStateChanges);
        }
        this.emulationService = emulationService;
        if (this.emulationService != null) {
            this.emulationService.addStateListener(this.listenerForEmuStateChanges);
        }
        this.updateActions();
    }

    public void processEvent(PluginEvent event) {
        super.processEvent(event);
        if (event instanceof TraceActivatedPluginEvent) {
            TraceActivatedPluginEvent ev = (TraceActivatedPluginEvent)event;
            this.coordinatesActivated(ev.getActiveCoordinates());
        } else if (event instanceof TraceClosedPluginEvent) {
            TraceClosedPluginEvent ev = (TraceClosedPluginEvent)event;
            this.traceClosed(ev.getTrace());
        }
    }

    protected class ControlModeAction
    extends MultiStateDockingAction<ControlMode> {
        public static final String NAME = "Control Mode";
        public static final String DESCRIPTION = "Choose what to control and edit in dynamic views";
        public static final String GROUP = "Dbg4. Control";
        public static final String HELP_ANCHOR = "control_mode";

        public ControlModeAction() {
            super(NAME, DebuggerControlPlugin.this.getName());
            this.setDescription(DESCRIPTION);
            this.setToolBarData(new ToolBarData(DebuggerResources.ICON_BLANK, GROUP, ""));
            this.setHelpLocation(new HelpLocation(this.getOwner(), HELP_ANCHOR));
            this.setActionStates(ControlMode.ALL.stream().map(m -> new ActionState(m.name, m.icon, (Object)m)).collect(Collectors.toList()));
            this.setEnabled(false);
        }

        public boolean isEnabledForContext(ActionContext context) {
            return DebuggerControlPlugin.this.current.getTrace() != null;
        }

        protected boolean isStateEnabled(ActionState<ControlMode> state) {
            return ((ControlMode)((Object)state.getUserData())).isSelectable(DebuggerControlPlugin.this.current);
        }

        public void actionStateChanged(ActionState<ControlMode> newActionState, EventTrigger trigger) {
            DebuggerControlPlugin.this.activateControlMode(newActionState, trigger);
        }
    }

    static interface TargetResumeAction
    extends ResumeAction {
        public static final String NAME = "Resume Target";
        public static final String DESCRIPTION = "Resume, i.e., go or continue execution of the target";
        public static final String HELP_ANCHOR = "target_resume";

        public static TargetActionBuilder<TargetResumable> builder(DebuggerControlPlugin owner) {
            String ownerName = owner.getName();
            return ((TargetActionBuilder)((TargetActionBuilder)((TargetActionBuilder)((TargetActionBuilder)((TargetActionBuilder)new TargetActionBuilder(NAME, owner).description(DESCRIPTION)).toolBarIcon(ICON)).toolBarGroup("Dbg4. Control", DebuggerControlPlugin.intSubGroup(0))).keyBinding(KEY_BINDING)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR))).withInterface(TargetResumable.class);
        }
    }

    static class TargetActionBuilder<T extends TargetObject>
    extends AbstractActionBuilder<TargetAction<T>, ActionContext, TargetActionBuilder<T>> {
        final DebuggerControlPlugin owner;
        Class<T> iface = TargetObject.class;
        Function<T, CompletableFuture<?>> actionCallback;
        BiPredicate<TraceObject, T> enabledPredicate;

        public TargetActionBuilder(String name, DebuggerControlPlugin owner) {
            super(name, owner.getName());
            this.owner = owner;
        }

        public <U extends TargetObject> TargetActionBuilder<U> withInterface(Class<U> iface) {
            this.iface = iface;
            return this.self();
        }

        public TargetActionBuilder<T> enabledWhenTarget(BiPredicate<TraceObject, T> enabledPredicate) {
            this.enabledPredicate = enabledPredicate;
            return this.self();
        }

        public TargetActionBuilder<T> onTargetAction(Function<T, CompletableFuture<?>> actionCallback) {
            this.actionCallback = actionCallback;
            return this.self();
        }

        protected TargetActionBuilder<T> self() {
            return this;
        }

        public TargetAction<T> build() {
            Objects.requireNonNull(this.iface, "Must specify withInterface");
            Objects.requireNonNull(this.enabledPredicate, "Must specify enabledWhenTarget");
            Objects.requireNonNull(this.actionCallback, "Must specify onTargetAction");
            DebuggerControlPlugin debuggerControlPlugin = this.owner;
            Objects.requireNonNull(debuggerControlPlugin);
            TargetAction action = new TargetAction<T>(debuggerControlPlugin, this.name){
                {
                    DebuggerControlPlugin debuggerControlPlugin = x0;
                    Objects.requireNonNull(debuggerControlPlugin);
                    super(name);
                }

                @Override
                Class<T> getTargetInterface() {
                    return iface;
                }

                @Override
                boolean isEnabledForObject(T t) {
                    return enabledPredicate.test(this.object, (TraceObject)t);
                }

                @Override
                void actionPerformed(T t) {
                    actionCallback.apply(t).exceptionally(ex -> {
                        owner.tool.setStatusInfo(name + " failed: " + ex.getMessage(), true);
                        Msg.error((Object)((Object)this), (Object)(name + " failed"), (Throwable)ex);
                        return null;
                    });
                }
            };
            this.decorateAction(action);
            return action;
        }
    }

    abstract class TargetAction<T extends TargetObject>
    extends DockingAction {
        TraceObject object;

        public TargetAction(String name) {
            super(name, DebuggerControlPlugin.this.getName());
        }

        abstract Class<T> getTargetInterface();

        TraceObject findTraceObject() {
            TraceObject focus = DebuggerControlPlugin.this.current.getObject();
            if (focus == null) {
                return null;
            }
            return focus.querySuitableTargetInterface(this.getTargetInterface());
        }

        T getTargetObject(TraceObject object) {
            TraceRecorder recorder = DebuggerControlPlugin.this.current.getRecorder();
            if (recorder == null || !recorder.isRecording()) {
                return null;
            }
            Class<T> iface = this.getTargetInterface();
            if (object != null) {
                return (T)((TargetObject)iface.cast(recorder.getTargetObject(object)));
            }
            TargetObject focus = recorder.getFocus();
            if (focus == null) {
                return null;
            }
            return (T)focus.getCachedSuitable(iface);
        }

        abstract boolean isEnabledForObject(T var1);

        abstract void actionPerformed(T var1);

        public boolean isEnabledForContext(ActionContext context) {
            this.object = this.findTraceObject();
            T t = this.getTargetObject(this.object);
            if (t == null || !t.getModel().isAlive()) {
                return false;
            }
            return this.isEnabledForObject(t);
        }

        public void actionPerformed(ActionContext context) {
            T t = this.getTargetObject(this.object);
            if (t == null) {
                return;
            }
            this.actionPerformed(t);
        }
    }

    static interface TargetInterruptAction
    extends InterruptAction {
        public static final String NAME = "Interrupt Target";
        public static final String DESCRIPTION = "Interrupt, i.e., suspend, the target";
        public static final String HELP_ANCHOR = "target_interrupt";

        public static TargetActionBuilder<TargetInterruptible> builder(DebuggerControlPlugin owner) {
            String ownerName = owner.getName();
            return ((TargetActionBuilder)((TargetActionBuilder)((TargetActionBuilder)((TargetActionBuilder)((TargetActionBuilder)new TargetActionBuilder(NAME, owner).description(DESCRIPTION)).toolBarIcon(ICON)).toolBarGroup("Dbg4. Control", DebuggerControlPlugin.intSubGroup(1))).keyBinding(KEY_BINDING)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR))).withInterface(TargetInterruptible.class);
        }
    }

    static interface TargetKillAction
    extends ControlAction {
        public static final Icon ICON = DebuggerResources.ICON_KILL;
        public static final String HELP_ANCHOR = "target_kill";
        public static final int SUB_GROUP = 2;
        public static final String NAME = "Kill Target";
        public static final String DESCRIPTION = "Kill, i.e., forcibly terminate the target";
        public static final KeyStroke KEY_BINDING = KeyStroke.getKeyStroke(75, 192);

        public static TargetActionBuilder<TargetKillable> builder(DebuggerControlPlugin owner) {
            String ownerName = owner.getName();
            return ((TargetActionBuilder)((TargetActionBuilder)((TargetActionBuilder)((TargetActionBuilder)((TargetActionBuilder)new TargetActionBuilder(NAME, owner).description(DESCRIPTION)).toolBarIcon(ICON)).toolBarGroup("Dbg4. Control", DebuggerControlPlugin.intSubGroup(2))).keyBinding(KEY_BINDING)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR))).withInterface(TargetKillable.class);
        }
    }

    static interface DisconnectAction
    extends ControlAction {
        public static final String NAME = "Disconnect";
        public static final String DESCRIPTION = "Close the connection to the debugging agent";
        public static final Icon ICON = DebuggerResources.ICON_DISCONNECT;
        public static final String HELP_ANCHOR = "target_disconnect";
        public static final int SUB_GROUP = 3;
        public static final KeyStroke KEY_BINDING = KeyStroke.getKeyStroke(75, 640);

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).toolBarIcon(ICON)).toolBarGroup("Dbg4. Control", DebuggerControlPlugin.intSubGroup(3))).keyBinding(KEY_BINDING)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    static interface TargetStepIntoAction
    extends StepIntoAction {
        public static final String NAME = "Step Target Into";
        public static final String DESCRIPTION = "Step the target a single instruction, descending into calls";
        public static final String HELP_ANCHOR = "target_step_into";

        public static TargetActionBuilder<TargetSteppable> builder(DebuggerControlPlugin owner) {
            String ownerName = owner.getName();
            return ((TargetActionBuilder)((TargetActionBuilder)((TargetActionBuilder)((TargetActionBuilder)((TargetActionBuilder)new TargetActionBuilder(NAME, owner).description(DESCRIPTION)).toolBarIcon(ICON)).toolBarGroup("Dbg4. Control", DebuggerControlPlugin.intSubGroup(5))).keyBinding(KEY_BINDING)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR))).withInterface(TargetSteppable.class);
        }
    }

    static interface TargetStepOverAction
    extends ControlAction {
        public static final String NAME = "Step Target Over";
        public static final String DESCRIPTION = "Step the target a single instruction, without following calls";
        public static final Icon ICON = DebuggerResources.ICON_STEP_OVER;
        public static final String HELP_ANCHOR = "target_step_over";
        public static final int SUB_GROUP = 6;
        public static final KeyStroke KEY_BINDING = KeyStroke.getKeyStroke(121, 0);

        public static TargetActionBuilder<TargetSteppable> builder(DebuggerControlPlugin owner) {
            String ownerName = owner.getName();
            return ((TargetActionBuilder)((TargetActionBuilder)((TargetActionBuilder)((TargetActionBuilder)((TargetActionBuilder)new TargetActionBuilder(NAME, owner).description(DESCRIPTION)).toolBarIcon(ICON)).toolBarGroup("Dbg4. Control", DebuggerControlPlugin.intSubGroup(6))).keyBinding(KEY_BINDING)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR))).withInterface(TargetSteppable.class);
        }
    }

    static interface TargetStepFinishAction
    extends ControlAction {
        public static final String NAME = "Step Target Finish";
        public static final String DESCRIPTION = "Step the target until it completes the current frame";
        public static final Icon ICON = DebuggerResources.ICON_STEP_FINISH;
        public static final String HELP_ANCHOR = "target_step_finish";
        public static final int SUB_GROUP = 8;
        public static final KeyStroke KEY_BINDING = KeyStroke.getKeyStroke(123, 0);

        public static TargetActionBuilder<TargetSteppable> builder(DebuggerControlPlugin owner) {
            String ownerName = owner.getName();
            return ((TargetActionBuilder)((TargetActionBuilder)((TargetActionBuilder)((TargetActionBuilder)((TargetActionBuilder)new TargetActionBuilder(NAME, owner).description(DESCRIPTION)).toolBarIcon(ICON)).toolBarGroup("Dbg4. Control", DebuggerControlPlugin.intSubGroup(8))).keyBinding(KEY_BINDING)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR))).withInterface(TargetSteppable.class);
        }
    }

    static interface TargetStepLastAction
    extends ControlAction {
        public static final String NAME = "Step Target Repeat Last";
        public static final String DESCRIPTION = "Step the target in a target-defined way";
        public static final Icon ICON = DebuggerResources.ICON_STEP_LAST;
        public static final String HELP_ANCHOR = "target_step_last";
        public static final int SUB_GROUP = 9;
        public static final KeyStroke KEY_BINDING = KeyStroke.getKeyStroke(119, 128);

        public static TargetActionBuilder<TargetSteppable> builder(DebuggerControlPlugin owner) {
            String ownerName = owner.getName();
            return ((TargetActionBuilder)((TargetActionBuilder)((TargetActionBuilder)((TargetActionBuilder)((TargetActionBuilder)new TargetActionBuilder(NAME, owner).description(DESCRIPTION)).toolBarIcon(ICON)).toolBarGroup("Dbg4. Control", DebuggerControlPlugin.intSubGroup(9))).keyBinding(KEY_BINDING)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR))).withInterface(TargetSteppable.class);
        }
    }

    static interface EmulateResumeAction
    extends ResumeAction {
        public static final String NAME = "Resume Emulator";
        public static final String DESCRIPTION = "Resume, i.e., go or continue execution of the integrated emulator";
        public static final String HELP_ANCHOR = "emu_resume";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).toolBarIcon(ICON)).toolBarGroup("Dbg4. Control", DebuggerControlPlugin.intSubGroup(0))).keyBinding(KEY_BINDING)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    static interface EmulateInterruptAction
    extends InterruptAction {
        public static final String NAME = "Interrupt Emulator";
        public static final String DESCRIPTION = "Interrupt, i.e., suspend, the integrated emulator";
        public static final String HELP_ANCHOR = "emu_interrupt";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).toolBarIcon(ICON)).toolBarGroup("Dbg4. Control", DebuggerControlPlugin.intSubGroup(1))).keyBinding(KEY_BINDING)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    static interface EmulateStepBackAction
    extends ControlAction {
        public static final String NAME = "Step Emulator Back";
        public static final String DESCRIPTION = "Step the integrated emulator a single instruction backward";
        public static final Icon ICON = DebuggerResources.ICON_STEP_BACK;
        public static final String HELP_ANCHOR = "emu_step_back";
        public static final int SUB_GROUP = 4;
        public static final KeyStroke KEY_BINDING = KeyStroke.getKeyStroke(118, 0);

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).toolBarIcon(ICON)).toolBarGroup("Dbg4. Control", DebuggerControlPlugin.intSubGroup(4))).keyBinding(KEY_BINDING)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    static interface EmulateStepIntoAction
    extends StepIntoAction {
        public static final String NAME = "Step Emulator Into";
        public static final String DESCRIPTION = "Step the integrated emulator a single instruction, descending into calls";
        public static final String HELP_ANCHOR = "emu_step_into";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).toolBarIcon(ICON)).toolBarGroup("Dbg4. Control", DebuggerControlPlugin.intSubGroup(5))).keyBinding(KEY_BINDING)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    static interface EmulateSkipOverAction
    extends ControlAction {
        public static final String NAME = "Skip Emulator";
        public static final String DESCRIPTION = "Skip the integrated emulator a single instruction, ignoring its effects";
        public static final Icon ICON = DebuggerResources.ICON_SKIP_OVER;
        public static final String HELP_ANCHOR = "emu_skip_over";
        public static final int SUB_GROUP = 7;
        public static final KeyStroke KEY_BINDING = KeyStroke.getKeyStroke(121, 128);

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).toolBarIcon(ICON)).toolBarGroup("Dbg4. Control", DebuggerControlPlugin.intSubGroup(7))).keyBinding(KEY_BINDING)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    static interface TraceSnapBackwardAction
    extends ControlAction {
        public static final String NAME = "Trace Snapshot Backward";
        public static final String DESCRIPTION = "Navigate the trace recording backward one snapshot";
        public static final Icon ICON = DebuggerResources.ICON_SNAP_BACKWARD;
        public static final String HELP_ANCHOR = "trace_snap_backward";
        public static final int SUB_GROUP = 10;
        public static final KeyStroke KEY_BINDING = KeyStroke.getKeyStroke(118, 0);

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).toolBarIcon(ICON)).toolBarGroup("Dbg4. Control", DebuggerControlPlugin.intSubGroup(10))).keyBinding(KEY_BINDING)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    static interface TraceSnapForwardAction
    extends ControlAction {
        public static final String NAME = "Trace Snapshot Forward";
        public static final String DESCRIPTION = "Navigate the trace recording forward one snapshot";
        public static final Icon ICON = DebuggerResources.ICON_SNAP_FORWARD;
        public static final String HELP_ANCHOR = "trace_snap_backward";
        public static final int SUB_GROUP = 11;
        public static final KeyStroke KEY_BINDING = KeyStroke.getKeyStroke(119, 0);

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).toolBarIcon(ICON)).toolBarGroup("Dbg4. Control", DebuggerControlPlugin.intSubGroup(11))).keyBinding(KEY_BINDING)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    static interface StepIntoAction
    extends ControlAction {
        public static final Icon ICON = DebuggerResources.ICON_STEP_INTO;
        public static final int SUB_GROUP = 5;
        public static final KeyStroke KEY_BINDING = KeyStroke.getKeyStroke(119, 0);
    }

    static interface InterruptAction
    extends ControlAction {
        public static final Icon ICON = DebuggerResources.ICON_INTERRUPT;
        public static final int SUB_GROUP = 1;
        public static final KeyStroke KEY_BINDING = KeyStroke.getKeyStroke(73, 128);
    }

    static interface ResumeAction
    extends ControlAction {
        public static final Icon ICON = DebuggerResources.ICON_RESUME;
        public static final int SUB_GROUP = 0;
        public static final KeyStroke KEY_BINDING = KeyStroke.getKeyStroke(116, 0);
    }

    static interface ControlAction {
        public static final String GROUP = "Dbg4. Control";
    }
}

