/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.breakpoint;

import db.Transaction;
import ghidra.app.plugin.core.debug.gui.breakpoint.DebuggerBreakpointsProvider;
import ghidra.app.services.LogicalBreakpoint;
import ghidra.program.model.address.Address;
import ghidra.trace.model.breakpoint.TraceBreakpoint;
import ghidra.trace.model.thread.TraceThread;
import java.util.Set;
import java.util.stream.Collectors;

public class BreakpointLocationRow {
    private final DebuggerBreakpointsProvider provider;
    private final TraceBreakpoint loc;

    public BreakpointLocationRow(DebuggerBreakpointsProvider provider, TraceBreakpoint loc) {
        this.provider = provider;
        this.loc = loc;
    }

    public String getName() {
        return this.loc.getName();
    }

    public boolean isEnabled() {
        long snap = this.provider.traceManager.getCurrentFor(this.loc.getTrace()).getSnap();
        return this.loc.isEnabled(snap);
    }

    public LogicalBreakpoint.State getState() {
        LogicalBreakpoint lb = this.provider.breakpointService.getBreakpoint(this.loc);
        if (lb == null) {
            return LogicalBreakpoint.State.NONE;
        }
        return lb.computeStateForLocation(this.loc);
    }

    public void setEnabled(boolean enabled) {
        if (enabled) {
            this.provider.breakpointService.enableLocs(Set.of(this.loc)).exceptionally(ex -> {
                this.provider.breakpointError("Toggle breakpoint", "Could not enable breakpoint", (Throwable)ex);
                return null;
            });
        } else {
            this.provider.breakpointService.disableLocs(Set.of(this.loc)).exceptionally(ex -> {
                this.provider.breakpointError("Toggle breakpoint", "Could not disable breakpoint", (Throwable)ex);
                return null;
            });
        }
    }

    public void setState(LogicalBreakpoint.State state) {
        assert (state.isNormal());
        this.setEnabled(state.isEnabled());
    }

    public void setName(String name) {
        try (Transaction tid = this.loc.getTrace().openTransaction("Set breakpoint name");){
            this.loc.setName(name);
        }
    }

    public Address getAddress() {
        return this.loc.getMinAddress();
    }

    public String getTraceName() {
        return this.loc.getTrace().getName();
    }

    public String getThreads() {
        return this.loc.getThreads().stream().map(TraceThread::getName).collect(Collectors.toSet()).toString();
    }

    public String getComment() {
        return this.loc.getComment();
    }

    public void setComment(String comment) {
        try (Transaction tid = this.loc.getTrace().openTransaction("Set breakpoint comment");){
            this.loc.setComment(comment);
        }
    }

    public boolean hasSleigh() {
        return !"emu_swi();\nemu_exec_decoded();\n".equals(this.loc.getEmuSleigh());
    }

    public TraceBreakpoint getTraceBreakpoint() {
        return this.loc;
    }
}

